/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientBuilderProvider;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Component;

@Component
public class OkHttpClientProvider {
    private final List<OkHttpClientBuilderProvider> providers;

    public OkHttpClientProvider(List<OkHttpClientBuilderProvider> providers) {
        this.providers = providers;
    }

    public OkHttpClient getClient(ServiceEndpoint service) {
        return this.getClient(service, List.of());
    }

    public OkHttpClient getClient(ServiceEndpoint service, List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = this.findProvider(service).get(service);
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
        return builder.build();
    }

    private OkHttpClientBuilderProvider findProvider(ServiceEndpoint service) {
        return this.providers.stream().filter(provider -> provider.supports(service)).findFirst().orElseThrow(() -> new SystemException(String.format("No client provider found for url (%s)", service.getBaseUrl())));
    }
}

