/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.client.ServiceClientFactory;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.List;
import okhttp3.Interceptor;
import org.springframework.stereotype.Component;

@NonnullByDefault
@Component
public class DefaultServiceClientProvider
implements ServiceClientProvider {
    private final List<ServiceClientFactory> serviceClientFactories;
    private final ObjectMapper objectMapper;

    public DefaultServiceClientProvider(List<ServiceClientFactory> serviceClientFactories, ObjectMapper objectMapper) {
        this.serviceClientFactories = serviceClientFactories;
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T getService(Class<T> type, ServiceEndpoint serviceEndpoint) {
        ServiceClientFactory serviceClientFactory = this.findProvider(type, serviceEndpoint);
        return serviceClientFactory.create(type, serviceEndpoint, this.objectMapper);
    }

    @Override
    public <T> T getService(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper) {
        ServiceClientFactory serviceClientFactory = this.findProvider(type, serviceEndpoint);
        return serviceClientFactory.create(type, serviceEndpoint, objectMapper);
    }

    @Override
    public <T> T getService(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper, List<Interceptor> interceptors) {
        ServiceClientFactory serviceClientFactory = this.findProvider(type, serviceEndpoint);
        return serviceClientFactory.create(type, serviceEndpoint, objectMapper, interceptors);
    }

    private ServiceClientFactory findProvider(Class<?> type, ServiceEndpoint service) {
        return this.serviceClientFactories.stream().filter(provider -> provider.supports(type, service)).findFirst().orElseThrow(() -> new SystemException(String.format("No service client provider found for url (%s)", service.getBaseUrl())));
    }
}

