/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.security.AuthenticatedRequest;
import com.netflix.spinnaker.security.AuthenticatedRequestDecorator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ClientRequest;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration
public class AuthenticatedRequestConfiguration {
    private static final String KEY = AuthenticatedRequestConfiguration.class.getName();

    @PostConstruct
    public void registerHook() {
        Schedulers.onScheduleHook((String)KEY, AuthenticatedRequestDecorator::wrap);
    }

    @PreDestroy
    public void unregisterHook() {
        Schedulers.resetOnScheduleHook((String)KEY);
    }

    @Bean
    public WebClientCustomizer authenticationHeadersPropagator() {
        return webClientBuilder -> webClientBuilder.filter((request, next) -> Mono.deferContextual(context -> {
            Map authenticationHeaders = (Map)context.get((Object)KEY);
            ClientRequest authenticatedRequest = ClientRequest.from((ClientRequest)request).headers(httpHeaders -> httpHeaders.setAll(authenticationHeaders)).build();
            return next.exchange(authenticatedRequest);
        }).contextWrite(context -> context.put((Object)KEY, AuthenticatedRequestConfiguration.getAuthenticationHeaders())));
    }

    private static Map<String, String> getAuthenticationHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        AuthenticatedRequest.getAuthenticationHeaders().forEach((headerName, value) -> value.ifPresent(headerValue -> headers.put((String)headerName, (String)headerValue)));
        return headers;
    }
}

