/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientBuilderProvider;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.okhttp.Retrofit2EncodeCorrectionInterceptor;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Component;

@Component
public class OkHttpClientProvider {
    private final List<OkHttpClientBuilderProvider> providers;
    private final Retrofit2EncodeCorrectionInterceptor retrofit2EncodeCorrectionInterceptor;

    public OkHttpClientProvider(List<OkHttpClientBuilderProvider> providers, Retrofit2EncodeCorrectionInterceptor retrofit2EncodeCorrectionInterceptor) {
        this.providers = providers;
        this.retrofit2EncodeCorrectionInterceptor = retrofit2EncodeCorrectionInterceptor;
    }

    public OkHttpClient getClient(ServiceEndpoint service) {
        return this.getClient(service, List.of());
    }

    public OkHttpClient getClient(ServiceEndpoint service, boolean skipEncodeCorrection) {
        return this.getClient(service, List.of(), skipEncodeCorrection);
    }

    public OkHttpClient getClient(ServiceEndpoint service, List<Interceptor> interceptors) {
        return this.getClient(service, interceptors, false);
    }

    public OkHttpClient getClient(ServiceEndpoint service, List<Interceptor> interceptors, boolean skipEncodeCorrection) {
        boolean encodeCorrectionExist;
        OkHttpClient.Builder builder = this.findProvider(service).get(service);
        if (!skipEncodeCorrection && !(encodeCorrectionExist = interceptors.stream().anyMatch(i -> i instanceof Retrofit2EncodeCorrectionInterceptor))) {
            builder.addInterceptor((Interceptor)this.retrofit2EncodeCorrectionInterceptor);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
        return builder.build();
    }

    private OkHttpClientBuilderProvider findProvider(ServiceEndpoint service) {
        return this.providers.stream().filter(provider -> provider.supports(service)).findFirst().orElseThrow(() -> new SystemException(String.format("No client provider found for url (%s)", service.getBaseUrl())));
    }
}

