/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.SelectableService;
import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ByAuthenticatedUserServiceSelector
implements ServiceSelector {
    private final Object service;
    private final int priority;
    private final List<Pattern> userPatterns;

    public ByAuthenticatedUserServiceSelector(Object service, Integer priority, Map<String, Object> config) {
        this.service = service;
        this.priority = priority;
        HashSet users = new HashSet(((Map)config.get("users")).values());
        this.userPatterns = users.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean supports(SelectableService.Criteria criteria) {
        if (criteria.getAuthenticatedUser() == null) {
            return false;
        }
        return this.userPatterns.stream().anyMatch(userPattern -> userPattern.matcher(criteria.getAuthenticatedUser()).matches());
    }
}

