/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.okhttp;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OkHttpMetricsInterceptorProperties;
import com.netflix.spinnaker.kork.common.Header;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Provider;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

class MetricsInterceptor {
    private final Provider<Registry> registry;
    private final OkHttpMetricsInterceptorProperties okHttpMetricsInterceptorProperties;
    private final Logger log;

    MetricsInterceptor(Provider<Registry> registry, OkHttpMetricsInterceptorProperties okHttpMetricsInterceptorProperties) {
        this.registry = registry;
        this.okHttpMetricsInterceptorProperties = okHttpMetricsInterceptorProperties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object doIntercept(Object chainObject) throws IOException {
        boolean missingAuthHeaders;
        Response response;
        long start = System.nanoTime();
        boolean wasSuccessful = false;
        int statusCode = -1;
        Interceptor.Chain chain3 = chainObject instanceof Interceptor.Chain ? (Interceptor.Chain)chainObject : null;
        Request request3 = chain3 != null ? chain3.request() : null;
        ArrayList<String> missingHeaders = new ArrayList<String>();
        String method = null;
        URL url = null;
        try {
            method = request3.method();
            url = request3.url().url();
            Response response2 = chain3.proceed(request3);
            statusCode = response2.code();
            if (this.checkForHeaders(url.toString())) {
                for (Response header : Header.values()) {
                    String headerValue = request3.header(header.getHeader());
                    if (!header.isRequired() || !StringUtils.isEmpty((Object)headerValue)) continue;
                    missingHeaders.add(header.getHeader());
                }
            }
            wasSuccessful = true;
            response = response2;
            boolean bl = missingAuthHeaders = missingHeaders.size() > 0;
        }
        catch (Throwable throwable) {
            boolean missingAuthHeaders2;
            boolean bl = missingAuthHeaders2 = missingHeaders.size() > 0;
            if (missingAuthHeaders2) {
                List stack = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).filter(x -> x.contains("com.netflix.spinnaker")).collect(Collectors.toList());
                String stackTrace = String.join((CharSequence)"\n\tat ", stack);
                this.log.warn(String.format("Request %s:%s is missing %s authentication headers and will be treated as anonymous.\nRequest from: %s", method, url, missingHeaders, stackTrace));
            }
            MetricsInterceptor.recordTimer((Registry)this.registry.get(), url, System.nanoTime() - start, statusCode, wasSuccessful, !missingAuthHeaders2);
            throw throwable;
        }
        if (missingAuthHeaders) {
            List stack = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).filter(x -> x.contains("com.netflix.spinnaker")).collect(Collectors.toList());
            String stackTrace = String.join((CharSequence)"\n\tat ", stack);
            this.log.warn(String.format("Request %s:%s is missing %s authentication headers and will be treated as anonymous.\nRequest from: %s", method, url, missingHeaders, stackTrace));
        }
        MetricsInterceptor.recordTimer((Registry)this.registry.get(), url, System.nanoTime() - start, statusCode, wasSuccessful, !missingAuthHeaders);
        return response;
    }

    private boolean checkForHeaders(String url) {
        String xSpinAnonymous = MDC.get((String)Header.XSpinnakerAnonymous);
        Pattern endPointPatternForHeaderCheck = this.okHttpMetricsInterceptorProperties.getEndPointPatternForHeaderCheck();
        return xSpinAnonymous == null && !this.okHttpMetricsInterceptorProperties.isSkipHeaderCheck() && (endPointPatternForHeaderCheck == null || endPointPatternForHeaderCheck.matcher(url).matches());
    }

    private static void recordTimer(Registry registry, URL requestUrl, Long durationNs, int statusCode, boolean wasSuccessful, boolean hasAuthHeaders) {
        registry.timer(registry.createId("okhttp.requests").withTag("requestHost", requestUrl.getHost()).withTag("statusCode", String.valueOf(statusCode)).withTag("status", MetricsInterceptor.bucket(statusCode)).withTag("success", wasSuccessful).withTag("authenticated", hasAuthHeaders)).record(durationNs.longValue(), TimeUnit.NANOSECONDS);
    }

    private static String bucket(int statusCode) {
        if (statusCode < 0) {
            return "Unknown";
        }
        return Integer.toString(statusCode).charAt(0) + "xx";
    }
}

