/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.okhttp;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class Retrofit2EncodeCorrectionInterceptor
implements Interceptor {
    private final boolean skipEncodingCorrection;

    public Retrofit2EncodeCorrectionInterceptor() {
        this.skipEncodingCorrection = false;
    }

    public Retrofit2EncodeCorrectionInterceptor(boolean skipEncodingCorrection) {
        this.skipEncodingCorrection = skipEncodingCorrection;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.skipEncodingCorrection) {
            return chain.proceed(chain.request());
        }
        Request originalRequest = chain.request();
        HttpUrl originalUrl = originalRequest.url();
        HttpUrl.Builder newUrlBuilder = originalUrl.newBuilder();
        for (int i = 0; i < originalUrl.pathSize(); ++i) {
            String retrofit2EncodedSegment = (String)originalUrl.encodedPathSegments().get(i);
            String encodedPathSegmentAfterCorrection = this.processRetrofit2EncodedString(retrofit2EncodedSegment);
            newUrlBuilder.setEncodedPathSegment(i, encodedPathSegmentAfterCorrection);
        }
        for (String paramName : originalUrl.queryParameterNames()) {
            String retrofit2EncodedParam = this.getEncodedQueryParam(originalUrl, paramName);
            if (retrofit2EncodedParam == null) continue;
            String encodedParam = this.processRetrofit2EncodedString(retrofit2EncodedParam);
            newUrlBuilder.setEncodedQueryParameter(paramName, encodedParam);
        }
        Request newRequest = originalRequest.newBuilder().url(newUrlBuilder.build()).build();
        return chain.proceed(newRequest);
    }

    private String getEncodedQueryParam(HttpUrl url, String paramName) {
        String encodedQuery = url.encodedQuery();
        if (encodedQuery == null) {
            return null;
        }
        for (String pair : encodedQuery.split("&")) {
            String[] parts = pair.split("=", 2);
            if (parts.length != 2 || !parts[0].equals(paramName)) continue;
            return parts[1];
        }
        return null;
    }

    private String processRetrofit2EncodedString(String retrofit2EncodedString) {
        String retrofit2EncodedVal = retrofit2EncodedString.replaceAll("%(?![0-9A-Fa-f]{2})", "%25").replaceAll("\\+", "%2B");
        String decodedVal = URLDecoder.decode(retrofit2EncodedVal, StandardCharsets.UTF_8);
        String encodedString = URLEncoder.encode(decodedVal, StandardCharsets.UTF_8);
        return encodedString.replace("+", "%20");
    }
}

