/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.okhttp;

import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SpinnakerRequestHeaderInterceptor
implements Interceptor {
    private final boolean propagateSpinnakerHeaders;
    private final boolean skipAccountsHeader;

    public SpinnakerRequestHeaderInterceptor(boolean propagateSpinnakerHeaders) {
        this.propagateSpinnakerHeaders = propagateSpinnakerHeaders;
        this.skipAccountsHeader = false;
    }

    public SpinnakerRequestHeaderInterceptor(boolean propagateSpinnakerHeaders, boolean skipAccountsHeader) {
        this.propagateSpinnakerHeaders = propagateSpinnakerHeaders;
        this.skipAccountsHeader = skipAccountsHeader;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (!this.propagateSpinnakerHeaders) {
            return chain.proceed(builder.build());
        }
        AuthenticatedRequest.getAuthenticationHeaders().forEach((key, value) -> {
            if (!(!value.isPresent() || this.skipAccountsHeader && Header.ACCOUNTS.getHeader().equals(key))) {
                builder.addHeader(key, (String)value.get());
            }
        });
        return chain.proceed(builder.build());
    }
}

