/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spinnaker.config.ObjectMapperSubtypeProperties;
import com.netflix.spinnaker.config.RedisQueueProperties;
import com.netflix.spinnaker.config.SpringObjectMapperConfigurer;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.RedisClusterDeadMessageHandler;
import com.netflix.spinnaker.q.redis.RedisClusterQueue;
import com.netflix.spinnaker.q.redis.RedisDeadMessageHandler;
import com.netflix.spinnaker.q.redis.RedisQueue;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

@Configuration
@EnableConfigurationProperties(value={RedisQueueProperties.class})
@ConditionalOnProperty(havingValue="true", matchIfMissing=true, value={"keiko.queue.redis.enabled"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017JN\u0010\u0014\u001a\u00020\u00152\u000e\b\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J4\u0010\u001a\u001a\u00020\u00062\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0017J*\u0010\"\u001a\u00020#2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0017J\"\u0010$\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J(\u0010%\u001a\u00020\u00192\u000e\b\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0012H\u0017\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/config/RedisQueueConfiguration;", "", "()V", "clusterQueue", "Lcom/netflix/spinnaker/q/redis/RedisClusterQueue;", "cluster", "Lredis/clients/jedis/JedisCluster;", "redisQueueProperties", "Lcom/netflix/spinnaker/config/RedisQueueProperties;", "clock", "Ljava/time/Clock;", "deadMessageHandler", "Lcom/netflix/spinnaker/q/redis/RedisClusterDeadMessageHandler;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "redisQueueObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "queue", "Lcom/netflix/spinnaker/q/redis/RedisQueue;", "redisPool", "Lredis/clients/jedis/util/Pool;", "Lredis/clients/jedis/Jedis;", "Lcom/netflix/spinnaker/q/redis/RedisDeadMessageHandler;", "queueRedisCluster", "connection", "", "timeout", "", "maxAttempts", "redisPoolConfig", "Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;", "queueRedisPool", "Lredis/clients/jedis/JedisPool;", "redisClusterDeadMessageHandler", "redisDeadMessageHandler", "properties", "Lcom/netflix/spinnaker/config/ObjectMapperSubtypeProperties;", "keiko-redis-spring"})
public class RedisQueueConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GenericObjectPoolConfig.class})
    @NotNull
    public GenericObjectPoolConfig<Object> redisPoolConfig() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        boolean bl = false;
        boolean bl2 = false;
        GenericObjectPoolConfig $this$apply = genericObjectPoolConfig;
        boolean bl3 = false;
        $this$apply.setBlockWhenExhausted(false);
        $this$apply.setMaxWaitMillis(2000L);
        return genericObjectPoolConfig;
    }

    @Bean
    @ConditionalOnMissingBean(name={"queueRedisPool"})
    @ConditionalOnProperty(havingValue="false", matchIfMissing=true, value={"redis.cluster-enabled"})
    @NotNull
    public JedisPool queueRedisPool(@Value(value="${redis.connection:redis://localhost:6379}") @NotNull String connection, @Value(value="${redis.timeout:2000}") int timeout, @NotNull GenericObjectPoolConfig<Object> redisPoolConfig) {
        int n;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(redisPoolConfig, (String)"redisPoolConfig");
        URI uRI = URI.create(connection);
        boolean bl = false;
        boolean bl2 = false;
        URI cx = uRI;
        boolean bl3 = false;
        URI uRI2 = cx;
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"cx");
        int port = uRI2.getPort() == -1 ? 6379 : cx.getPort();
        CharSequence charSequence = cx.getPath();
        boolean bl4 = false;
        boolean bl5 = false;
        if (charSequence == null || charSequence.length() == 0) {
            n = 0;
        } else {
            String string = cx.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cx.path");
            charSequence = StringsKt.substringAfter$default((String)string, (String)"/", null, (int)2, null);
            bl4 = false;
            n = Integer.parseInt((String)charSequence);
        }
        int db = n;
        String string = cx.getUserInfo();
        String password = string != null ? StringsKt.substringAfter$default((String)string, (String)":", null, (int)2, null) : null;
        boolean isSSL = Intrinsics.areEqual((Object)cx.getScheme(), (Object)"rediss");
        return new JedisPool(redisPoolConfig, cx.getHost(), port, timeout, password, db, isSSL);
    }

    @Bean
    @ConditionalOnMissingBean(name={"queue"})
    @ConditionalOnProperty(havingValue="false", matchIfMissing=true, value={"redis.cluster-enabled"})
    @NotNull
    public RedisQueue queue(@Qualifier(value="queueRedisPool") @NotNull Pool<Jedis> redisPool, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull RedisDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper redisQueueObjectMapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter(redisPool, (String)"redisPool");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)redisQueueObjectMapper, (String)"redisQueueObjectMapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        String string = redisQueueProperties.getQueueName();
        List list = CollectionsKt.listOf((Object)deadMessageHandler);
        Duration duration = Duration.ofSeconds(redisQueueProperties.getAckTimeoutSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofSeconds(redis\u2026kTimeoutSeconds.toLong())");
        Optional<SerializationMigrator> optional = serializationMigrator;
        boolean bl = false;
        TemporalAmount temporalAmount = duration;
        EventPublisher eventPublisher = publisher;
        List list2 = list;
        return new RedisQueue(string, redisPool, clock, 0, redisQueueObjectMapper, optional, temporalAmount, list2, bl, eventPublisher, 264, null);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisDeadMessageHandler"})
    @ConditionalOnProperty(havingValue="false", matchIfMissing=true, value={"redis.cluster-enabled"})
    @NotNull
    public RedisDeadMessageHandler redisDeadMessageHandler(@Qualifier(value="queueRedisPool") @NotNull Pool<Jedis> redisPool, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(redisPool, (String)"redisPool");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new RedisDeadMessageHandler(redisQueueProperties.getDeadLetterQueueName(), redisPool, clock);
    }

    @Bean
    @ConditionalOnMissingBean(name={"queueRedisCluster"})
    @ConditionalOnProperty(value={"redis.cluster-enabled"})
    @NotNull
    public JedisCluster queueRedisCluster(@Value(value="${redis.connection:redis://localhost:6379}") @NotNull String connection, @Value(value="${redis.timeout:2000}") int timeout, @Value(value="${redis.maxattempts:4}") int maxAttempts, @NotNull GenericObjectPoolConfig<Object> redisPoolConfig) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(redisPoolConfig, (String)"redisPoolConfig");
        URI uRI = URI.create(connection);
        boolean bl = false;
        boolean bl2 = false;
        URI cx = uRI;
        boolean bl3 = false;
        URI uRI2 = cx;
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"cx");
        int port = uRI2.getPort() == -1 ? 6379 : cx.getPort();
        String string = cx.getUserInfo();
        String password = string != null ? StringsKt.substringAfter$default((String)string, (String)":", null, (int)2, null) : null;
        return new JedisCluster(new HostAndPort(cx.getHost(), port), timeout, timeout, maxAttempts, password, redisPoolConfig);
    }

    @Bean
    @ConditionalOnMissingBean(name={"queue", "clusterQueue"})
    @ConditionalOnProperty(value={"redis.cluster-enabled"})
    @NotNull
    public RedisClusterQueue clusterQueue(@Qualifier(value="queueRedisCluster") @NotNull JedisCluster cluster, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull RedisClusterDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper redisQueueObjectMapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)redisQueueObjectMapper, (String)"redisQueueObjectMapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        String string = redisQueueProperties.getQueueName();
        List list = CollectionsKt.listOf((Object)deadMessageHandler);
        Duration duration = Duration.ofSeconds(redisQueueProperties.getAckTimeoutSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofSeconds(redis\u2026kTimeoutSeconds.toLong())");
        Optional<SerializationMigrator> optional = serializationMigrator;
        boolean bl = false;
        TemporalAmount temporalAmount = duration;
        EventPublisher eventPublisher = publisher;
        List list2 = list;
        return new RedisClusterQueue(string, cluster, clock, 0, redisQueueObjectMapper, optional, temporalAmount, list2, bl, eventPublisher, 264, null);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisClusterDeadMessageHandler"})
    @ConditionalOnProperty(value={"redis.cluster-enabled"})
    @NotNull
    public RedisClusterDeadMessageHandler redisClusterDeadMessageHandler(@Qualifier(value="queueRedisCluster") @NotNull JedisCluster cluster, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new RedisClusterDeadMessageHandler(redisQueueProperties.getDeadLetterQueueName(), cluster, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ObjectMapper redisQueueObjectMapper(@NotNull Optional<ObjectMapperSubtypeProperties> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        ObjectMapper objectMapper = new ObjectMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule.Builder().build());
        $this$apply.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties = properties.orElse(new ObjectMapperSubtypeProperties());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapperSubtypeProperties, (String)"properties.orElse(ObjectMapperSubtypeProperties())");
        new SpringObjectMapperConfigurer(objectMapperSubtypeProperties).registerSubtypes($this$apply);
        return objectMapper;
    }
}

