/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.redis;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.io.Closeable;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u0005B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/q/redis/RedisDeadMessageHandler;", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Queue;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "deadLetterQueueName", "", "pool", "Lredis/clients/jedis/util/Pool;", "Lredis/clients/jedis/Jedis;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Lredis/clients/jedis/util/Pool;Ljava/time/Clock;)V", "dlqKey", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "invoke", "queue", "message", "keiko-redis"})
public final class RedisDeadMessageHandler
implements Function2<Queue, Message, Unit> {
    private final String dlqKey;
    private final ObjectMapper mapper;
    private final Pool<Jedis> pool;
    private final Clock clock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Queue queue, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            double score = this.clock.instant().toEpochMilli();
            Long l = redis.zadd(this.dlqKey, score, this.mapper.writeValueAsString((Object)message));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public RedisDeadMessageHandler(@NotNull String deadLetterQueueName, @NotNull Pool<Jedis> pool, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)deadLetterQueueName, (String)"deadLetterQueueName");
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.pool = pool;
        this.clock = clock;
        this.dlqKey = deadLetterQueueName + ".messages";
        this.mapper = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().build());
    }
}

