/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.redis;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0003"}, d2={"READ_MESSAGE_SRC", "", "READ_MESSAGE_WITH_LOCK_SRC", "keiko-redis"})
public final class AbstractRedisQueueKt {
    @NotNull
    public static final String READ_MESSAGE_SRC = "\n  local java_scientific = function(x)\n    return string.format(\"%.12E\", x):gsub(\"\\+\", \"\")\n  end\n\n  -- get the message, move the fingerprint to the unacked queue and return\n  local message = redis.call(\"HGET\", messagesKey, fingerprint)\n\n  -- check for an ack timeout override on the message\n  local unackScore = unackDefaultScore\n  if type(message) == \"string\" and message ~= nil then\n    local ackTimeoutOverride = tonumber(cjson.decode(message)[\"ackTimeoutMs\"])\n    if ackTimeoutOverride ~= nil and unackBaseScore ~= nil then\n      unackScore = unackBaseScore + ackTimeoutOverride\n    end\n  end\n\n  unackScore = java_scientific(unackScore)\n\n  redis.call(\"ZREM\", queueKey, fingerprint)\n  redis.call(\"ZADD\", unackKey, unackScore, fingerprint)\n";
    @NotNull
    public static final String READ_MESSAGE_WITH_LOCK_SRC = "\n  local queueKey = KEYS[1]\n  local unackKey = KEYS[2]\n  local lockKey = KEYS[3]\n  local messagesKey = KEYS[4]\n  local maxScore = ARGV[1]\n  local peekFingerprintCount = ARGV[2]\n  local lockTtlSeconds = ARGV[3]\n  local unackDefaultScore = ARGV[4]\n  local unackBaseScore = ARGV[5]\n\n  local not_empty = function(x)\n    return (type(x) == \"table\") and (not x.err) and (#x ~= 0)\n  end\n\n  local acquire_lock = function(fingerprints, locksKey, lockTtlSeconds)\n    if not_empty(fingerprints) then\n      local i=1\n      while (i <= #fingerprints) do\n        redis.call(\"ECHO\", \"attempting lock on \" .. fingerprints[i])\n        if redis.call(\"SET\", locksKey .. \":\" .. fingerprints[i], \"\\uD83D\\uDD12\", \"EX\", lockTtlSeconds, \"NX\") then\n          redis.call(\"ECHO\", \"acquired lock on \" .. fingerprints[i])\n          return fingerprints[i], fingerprints[i+1]\n        end\n        i=i+2\n      end\n    end\n    return nil, nil\n  end\n\n  -- acquire a lock on a fingerprint\n  local fingerprints = redis.call(\"ZRANGEBYSCORE\", queueKey, 0.0, maxScore, \"WITHSCORES\", \"LIMIT\", 0, peekFingerprintCount)\n  local fingerprint, fingerprintScore = acquire_lock(fingerprints, lockKey, lockTtlSeconds)\n\n  -- no lock could be acquired\n  if fingerprint == nil then\n    if #fingerprints == 0 then\n      return \"NoReadyMessages\"\n    end\n    return \"AcquireLockFailed\"\n  end\n\n  \n  local java_scientific = function(x)\n    return string.format(\"%.12E\", x):gsub(\"\\+\", \"\")\n  end\n\n  -- get the message, move the fingerprint to the unacked queue and return\n  local message = redis.call(\"HGET\", messagesKey, fingerprint)\n\n  -- check for an ack timeout override on the message\n  local unackScore = unackDefaultScore\n  if type(message) == \"string\" and message ~= nil then\n    local ackTimeoutOverride = tonumber(cjson.decode(message)[\"ackTimeoutMs\"])\n    if ackTimeoutOverride ~= nil and unackBaseScore ~= nil then\n      unackScore = unackBaseScore + ackTimeoutOverride\n    end\n  end\n\n  unackScore = java_scientific(unackScore)\n\n  redis.call(\"ZREM\", queueKey, fingerprint)\n  redis.call(\"ZADD\", unackKey, unackScore, fingerprint)\n\n\n  return {fingerprint, fingerprintScore, message}\n";
}

