/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.hash.Hashing;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.metrics.MonitorableQueue;
import com.netflix.spinnaker.q.metrics.QueueEvent;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0001gBm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\"\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0002`\u00130\u000e\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u00107\u001a\u00020\u0012H&J\u0015\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b=J\u0017\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bAJ'\u0010B\u001a\u00020\u0015*\u00020C2\u0006\u0010D\u001a\u00020\u001c2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0FH\u0000\u00a2\u0006\u0002\bGJ'\u0010B\u001a\u00020\u0015*\u00020H2\u0006\u0010D\u001a\u00020\u001c2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0FH\u0000\u00a2\u0006\u0002\bGJ\u0011\u0010I\u001a\u00020J*\u00020\u0011H\u0000\u00a2\u0006\u0002\bKJ#\u0010L\u001a\u0004\u0018\u00010\u001c*\u00020C2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0000\u00a2\u0006\u0002\bMJ#\u0010L\u001a\u0004\u0018\u00010\u001c*\u00020H2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0000\u00a2\u0006\u0002\bMJ\u0011\u0010N\u001a\u00020\u001c*\u00020\u0011H\u0001\u00a2\u0006\u0002\bOJ\u0011\u0010P\u001a\u00020\u001c*\u00020\u0011H\u0000\u00a2\u0006\u0002\bQJ+\u0010R\u001a\u00020\u0005*\u00020C2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010S\u001a\u00020\u001c2\b\b\u0002\u0010T\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bUJ+\u0010R\u001a\u00020\u0005*\u00020H2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010S\u001a\u00020\u001c2\b\b\u0002\u0010T\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bUJN\u0010V\u001a&\u0012\f\u0012\n $*\u0004\u0018\u00010X0X $*\u0012\u0012\f\u0012\n $*\u0004\u0018\u00010X0X\u0018\u00010\u000e0W*\u00020Y2\u0017\u0010Z\u001a\u0013\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020\u00120[\u00a2\u0006\u0002\b]H\u0000\u00a2\u0006\u0002\b^J$\u0010_\u001a\u0002H`\"\u0006\b\u0000\u0010`\u0018\u0001*\u00020\u00072\u0006\u0010a\u001a\u00020\u001cH\u0080\b\u00a2\u0006\u0004\bb\u0010cJ!\u0010d\u001a\u00020\u0015*\u00020C2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010e\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bfJ!\u0010d\u001a\u00020\u0015*\u00020H2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010e\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bfR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0002`\u00130\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\n $*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u001cX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0012\u0010'\u001a\u00020(X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u001cX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001eR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u00020\u001cX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001eR\u0018\u00101\u001a\u00020\u001cX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u00104R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\u001cX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001e\u00a8\u0006h"}, d2={"Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue;", "Lcom/netflix/spinnaker/q/metrics/MonitorableQueue;", "clock", "Ljava/time/Clock;", "lockTtlSeconds", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "ackTimeout", "Ljava/time/temporal/TemporalAmount;", "deadMessageHandlers", "", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Queue;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "canPollMany", "", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "(Ljava/time/Clock;ILcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/Optional;Ljava/time/temporal/TemporalAmount;Ljava/util/List;ZLcom/netflix/spinnaker/q/metrics/EventPublisher;)V", "getAckTimeout", "()Ljava/time/temporal/TemporalAmount;", "attemptsKey", "", "getAttemptsKey$keiko_redis", "()Ljava/lang/String;", "getCanPollMany", "()Z", "getDeadMessageHandlers", "()Ljava/util/List;", "hashObjectMapper", "kotlin.jvm.PlatformType", "locksKey", "getLocksKey$keiko_redis", "log", "Lorg/slf4j/Logger;", "getLog$keiko_redis", "()Lorg/slf4j/Logger;", "messagesKey", "getMessagesKey$keiko_redis", "getPublisher", "()Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "queueKey", "getQueueKey$keiko_redis", "readMessageWithLockScriptSha", "getReadMessageWithLockScriptSha", "setReadMessageWithLockScriptSha", "(Ljava/lang/String;)V", "unackedKey", "getUnackedKey$keiko_redis", "cacheScript", "handleDeadMessage", "message", "handleDeadMessage$keiko_redis", "runSerializationMigration", "json", "runSerializationMigration$keiko_redis", "score", "", "delay", "score$keiko_redis", "anyZismember", "Lredis/clients/jedis/commands/JedisClusterCommands;", "key", "members", "", "anyZismember$keiko_redis", "Lredis/clients/jedis/commands/JedisCommands;", "fingerprint", "Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue$Fingerprint;", "fingerprint$keiko_redis", "firstFingerprint", "firstFingerprint$keiko_redis", "hashV1", "hashV1$keiko_redis", "hashV2", "hashV2$keiko_redis", "hgetInt", "field", "default", "hgetInt$keiko_redis", "multi", "", "", "Lredis/clients/jedis/Jedis;", "block", "Lkotlin/Function1;", "Lredis/clients/jedis/Transaction;", "Lkotlin/ExtensionFunctionType;", "multi$keiko_redis", "readValue", "R", "content", "readValue$keiko_redis", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;)Ljava/lang/Object;", "zismember", "member", "zismember$keiko_redis", "Fingerprint", "keiko-redis"})
public abstract class AbstractRedisQueue
implements MonitorableQueue {
    private final ObjectMapper hashObjectMapper;
    private final Clock clock;
    private final int lockTtlSeconds;
    private final ObjectMapper mapper;
    private final Optional<SerializationMigrator> serializationMigrator;
    @NotNull
    private final TemporalAmount ackTimeout;
    @NotNull
    private final List<Function2<Queue, Message, Unit>> deadMessageHandlers;
    private final boolean canPollMany;
    @NotNull
    private final EventPublisher publisher;

    @NotNull
    public abstract String getQueueKey$keiko_redis();

    @NotNull
    public abstract String getUnackedKey$keiko_redis();

    @NotNull
    public abstract String getMessagesKey$keiko_redis();

    @NotNull
    public abstract String getLocksKey$keiko_redis();

    @NotNull
    public abstract String getAttemptsKey$keiko_redis();

    @NotNull
    public abstract Logger getLog$keiko_redis();

    public abstract void cacheScript();

    @NotNull
    public abstract String getReadMessageWithLockScriptSha();

    public abstract void setReadMessageWithLockScriptSha(@NotNull String var1);

    @NotNull
    public final String runSerializationMigration$keiko_redis(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.serializationMigrator.isPresent()) {
            return this.serializationMigrator.get().migrate(json);
        }
        return json;
    }

    public final void handleDeadMessage$keiko_redis(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = this.getDeadMessageHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)this, (Object)message);
        }
    }

    public final double score$keiko_redis(@NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        return this.clock.instant().plus(delay).toEpochMilli();
    }

    public static /* synthetic */ double score$keiko_redis$default(AbstractRedisQueue abstractRedisQueue, TemporalAmount temporalAmount, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: score");
        }
        if ((n & 1) != 0) {
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
            temporalAmount = duration;
        }
        return abstractRedisQueue.score$keiko_redis(temporalAmount);
    }

    public final /* synthetic */ <R> R readValue$keiko_redis(ObjectMapper $this$readValue, String content) {
        int $i$f$readValue$keiko_redis = 0;
        Intrinsics.checkNotNullParameter((Object)$this$readValue, (String)"$this$readValue");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.reifiedOperationMarker((int)4, (String)"R");
        return (R)$this$readValue.readValue(content, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Object> multi$keiko_redis(@NotNull Jedis $this$multi, @NotNull Function1<? super Transaction, Unit> block) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = (Closeable)$this$multi.multi();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Transaction tx = (Transaction)closeable;
            boolean bl3 = false;
            Transaction transaction = tx;
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"tx");
            block.invoke((Object)transaction);
            list = tx.exec();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public final int hgetInt$keiko_redis(@NotNull JedisCommands $this$hgetInt, @NotNull String key, @NotNull String field, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$hgetInt, (String)"$this$hgetInt");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = $this$hgetInt.hget(key, field);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n2 = Integer.parseInt(string2);
        } else {
            n2 = n;
        }
        return n2;
    }

    public static /* synthetic */ int hgetInt$keiko_redis$default(AbstractRedisQueue abstractRedisQueue, JedisCommands jedisCommands, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hgetInt");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return abstractRedisQueue.hgetInt$keiko_redis(jedisCommands, string, string2, n);
    }

    public final int hgetInt$keiko_redis(@NotNull JedisClusterCommands $this$hgetInt, @NotNull String key, @NotNull String field, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$hgetInt, (String)"$this$hgetInt");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = $this$hgetInt.hget(key, field);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n2 = Integer.parseInt(string2);
        } else {
            n2 = n;
        }
        return n2;
    }

    public static /* synthetic */ int hgetInt$keiko_redis$default(AbstractRedisQueue abstractRedisQueue, JedisClusterCommands jedisClusterCommands, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hgetInt");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return abstractRedisQueue.hgetInt$keiko_redis(jedisClusterCommands, string, string2, n);
    }

    public final boolean zismember$keiko_redis(@NotNull JedisCommands $this$zismember, @NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)$this$zismember, (String)"$this$zismember");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        return $this$zismember.zrank(key, member) != null;
    }

    public final boolean zismember$keiko_redis(@NotNull JedisClusterCommands $this$zismember, @NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)$this$zismember, (String)"$this$zismember");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        return $this$zismember.zrank(key, member) != null;
    }

    public final boolean anyZismember$keiko_redis(@NotNull JedisCommands $this$anyZismember, @NotNull String key, @NotNull Set<String> members) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$anyZismember, (String)"$this$anyZismember");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            Iterable $this$any$iv = members;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.zismember$keiko_redis($this$anyZismember, key, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean anyZismember$keiko_redis(@NotNull JedisClusterCommands $this$anyZismember, @NotNull String key, @NotNull Set<String> members) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$anyZismember, (String)"$this$anyZismember");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            Iterable $this$any$iv = members;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.zismember$keiko_redis($this$anyZismember, key, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final String firstFingerprint$keiko_redis(@NotNull JedisCommands $this$firstFingerprint, @NotNull String key, @NotNull Fingerprint fingerprint) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$firstFingerprint, (String)"$this$firstFingerprint");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Iterable $this$firstOrNull$iv = fingerprint.getAll();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!this.zismember$keiko_redis($this$firstFingerprint, key, it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final String firstFingerprint$keiko_redis(@NotNull JedisClusterCommands $this$firstFingerprint, @NotNull String key, @NotNull Fingerprint fingerprint) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$firstFingerprint, (String)"$this$firstFingerprint");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Iterable $this$firstOrNull$iv = fingerprint.getAll();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!this.zismember$keiko_redis($this$firstFingerprint, key, it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Deprecated(message="Hashes the attributes property, which is mutable")
    @NotNull
    public final String hashV1$keiko_redis(@NotNull Message $this$hashV1) {
        Intrinsics.checkNotNullParameter((Object)$this$hashV1, (String)"$this$hashV1");
        String string = Hashing.murmur3_128().hashString((CharSequence)$this$hashV1.toString(), Charset.defaultCharset()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Hashing\n      .murmur3_1\u2026rset())\n      .toString()");
        return string;
    }

    @NotNull
    public final String hashV2$keiko_redis(@NotNull Message $this$hashV2) {
        Intrinsics.checkNotNullParameter((Object)$this$hashV2, (String)"$this$hashV2");
        Object object = this.hashObjectMapper.convertValue((Object)$this$hashV2, Map.class);
        boolean bl = false;
        boolean bl2 = false;
        Map $this$apply = (Map)object;
        boolean bl3 = false;
        Map map = $this$apply;
        String string = "attributes";
        boolean bl4 = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        TypeIntrinsics.asMutableMap((Object)map2).remove(string);
        bl = false;
        bl2 = false;
        Map it = (Map)object;
        boolean bl5 = false;
        String string2 = Hashing.murmur3_128().hashString((CharSequence)("v2:" + this.hashObjectMapper.writeValueAsString((Object)it)), StandardCharsets.UTF_8).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hashObjectMapper.convert\u2026      .toString()\n      }");
        return string2;
    }

    @NotNull
    public final Fingerprint fingerprint$keiko_redis(@NotNull Message $this$fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$fingerprint, (String)"$this$fingerprint");
        String string = this.hashV2$keiko_redis($this$fingerprint);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        return new Fingerprint(it, SetsKt.setOf((Object[])new String[]{it, this.hashV1$keiko_redis($this$fingerprint)}));
    }

    @NotNull
    public TemporalAmount getAckTimeout() {
        return this.ackTimeout;
    }

    @NotNull
    public List<Function2<Queue, Message, Unit>> getDeadMessageHandlers() {
        return this.deadMessageHandlers;
    }

    public boolean getCanPollMany() {
        return this.canPollMany;
    }

    @NotNull
    public EventPublisher getPublisher() {
        return this.publisher;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractRedisQueue(@NotNull Clock clock, int lockTtlSeconds, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull TemporalAmount ackTimeout, @NotNull List<? extends Function2<? super Queue, ? super Message, Unit>> deadMessageHandlers, boolean canPollMany, @NotNull EventPublisher publisher) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)ackTimeout, (String)"ackTimeout");
        Intrinsics.checkNotNullParameter(deadMessageHandlers, (String)"deadMessageHandlers");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.clock = clock;
        this.lockTtlSeconds = lockTtlSeconds;
        this.mapper = mapper;
        this.serializationMigrator = serializationMigrator;
        this.ackTimeout = ackTimeout;
        this.deadMessageHandlers = deadMessageHandlers;
        this.canPollMany = canPollMany;
        this.publisher = publisher;
        ObjectMapper objectMapper = new ObjectMapper().copy();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper objectMapper2 = objectMapper;
        AbstractRedisQueue abstractRedisQueue = this;
        boolean bl3 = false;
        $this$apply.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        Unit unit = Unit.INSTANCE;
        abstractRedisQueue.hashObjectMapper = objectMapper;
    }

    public /* synthetic */ AbstractRedisQueue(Clock clock, int n, ObjectMapper objectMapper, Optional optional, TemporalAmount temporalAmount, List list, boolean bl, EventPublisher eventPublisher, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        if ((n2 & 0x10) != 0) {
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMinutes(1)");
            temporalAmount = duration;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        this(clock, n, objectMapper, optional, temporalAmount, list, bl, eventPublisher);
    }

    public void clear() {
        MonitorableQueue.DefaultImpls.clear((MonitorableQueue)this);
    }

    public void fire(@NotNull QueueEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MonitorableQueue.DefaultImpls.fire((MonitorableQueue)this, (QueueEvent)event);
    }

    public void push(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MonitorableQueue.DefaultImpls.push((MonitorableQueue)this, (Message)message);
    }

    public void reschedule(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MonitorableQueue.DefaultImpls.reschedule((MonitorableQueue)this, (Message)message);
    }

    public void retry() {
        MonitorableQueue.DefaultImpls.retry((MonitorableQueue)this);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue$Fingerprint;", "", "latest", "", "all", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getAll", "()Ljava/util/Set;", "getLatest", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "keiko-redis"})
    public static final class Fingerprint {
        @NotNull
        private final String latest;
        @NotNull
        private final Set<String> all;

        @NotNull
        public final String getLatest() {
            return this.latest;
        }

        @NotNull
        public final Set<String> getAll() {
            return this.all;
        }

        public Fingerprint(@NotNull String latest, @NotNull Set<String> all) {
            Intrinsics.checkNotNullParameter((Object)latest, (String)"latest");
            Intrinsics.checkNotNullParameter(all, (String)"all");
            this.latest = latest;
            this.all = all;
        }

        public /* synthetic */ Fingerprint(String string, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            this(string, set);
        }

        @NotNull
        public final String component1() {
            return this.latest;
        }

        @NotNull
        public final Set<String> component2() {
            return this.all;
        }

        @NotNull
        public final Fingerprint copy(@NotNull String latest, @NotNull Set<String> all) {
            Intrinsics.checkNotNullParameter((Object)latest, (String)"latest");
            Intrinsics.checkNotNullParameter(all, (String)"all");
            return new Fingerprint(latest, all);
        }

        public static /* synthetic */ Fingerprint copy$default(Fingerprint fingerprint, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = fingerprint.latest;
            }
            if ((n & 2) != 0) {
                set = fingerprint.all;
            }
            return fingerprint.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "Fingerprint(latest=" + this.latest + ", all=" + this.all + ")";
        }

        public int hashCode() {
            String string = this.latest;
            Set<String> set = this.all;
            return (string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Fingerprint)) break block3;
                    Fingerprint fingerprint = (Fingerprint)object;
                    if (!Intrinsics.areEqual((Object)this.latest, (Object)fingerprint.latest) || !Intrinsics.areEqual(this.all, fingerprint.all)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

