/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.redis;

import arrow.core.Partials;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.KotlinOpen;
import com.netflix.spinnaker.q.AttemptsAttribute;
import com.netflix.spinnaker.q.Attribute;
import com.netflix.spinnaker.q.MaxAttemptsAttribute;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.metrics.LockFailed;
import com.netflix.spinnaker.q.metrics.MessageAcknowledged;
import com.netflix.spinnaker.q.metrics.MessageDead;
import com.netflix.spinnaker.q.metrics.MessageDuplicate;
import com.netflix.spinnaker.q.metrics.MessageNotFound;
import com.netflix.spinnaker.q.metrics.MessageProcessing;
import com.netflix.spinnaker.q.metrics.MessagePushed;
import com.netflix.spinnaker.q.metrics.MessageRescheduled;
import com.netflix.spinnaker.q.metrics.MessageRetried;
import com.netflix.spinnaker.q.metrics.QueueEvent;
import com.netflix.spinnaker.q.metrics.QueuePolled;
import com.netflix.spinnaker.q.metrics.QueueState;
import com.netflix.spinnaker.q.metrics.RetryPolled;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.AbstractRedisQueue;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.util.JedisClusterCRC16;

@KotlinOpen
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0013j\u0002`\u00170\u0012\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0003H\u0002J\u0006\u0010:\u001a\u00020\u0016J\u001c\u0010;\u001a\u00020\u00192\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190=H\u0016J\u0018\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0010H\u0016J(\u0010A\u001a\u00020\u00162\u001e\u0010B\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160C\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J4\u0010A\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\t2\"\u0010B\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160C\u0012\u0004\u0012\u00020\u00160\u0013j\u0002`EH\u0016J\u0018\u0010F\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0010H\u0016J\b\u0010G\u001a\u00020HH\u0016J\u0018\u0010I\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0010H\u0016J\b\u0010J\u001a\u00020\u0016H\u0017JG\u0010K\u001a&\u0012\f\u0012\n N*\u0004\u0018\u00010M0M N*\u0012\u0012\f\u0012\n N*\u0004\u0018\u00010M0M\u0018\u00010\u00120L*\u00020\u00052\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\u00160=\u00a2\u0006\u0002\bQJ#\u0010R\u001a\u00020\u0016*\u00020\u00052\u0006\u0010?\u001a\u00020\u00152\b\b\u0002\u0010@\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bSJ7\u0010T\u001a\u00020\u0016*\u00020\u00052\u0006\u00109\u001a\u00020\u00032\b\u0010U\u001a\u0004\u0018\u00010\u00032\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160=H\u0000\u00a2\u0006\u0002\bVJ'\u0010W\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020Y\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010X*\u00020\u0005H\u0000\u00a2\u0006\u0002\bZJ-\u0010[\u001a\u00020\u0016*\u00020\u00052\u0006\u00109\u001a\u00020\u00032\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160=H\u0000\u00a2\u0006\u0002\b\\J\u0019\u0010]\u001a\u00020\u0016*\u00020\u00052\u0006\u00109\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b^J\u0019\u0010_\u001a\u00020\u0016*\u00020\u00052\u0006\u00109\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b`R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0013j\u0002`\u00170\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010!R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010!\"\u0004\b4\u00105R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010!\u00a8\u0006a"}, d2={"Lcom/netflix/spinnaker/q/redis/RedisClusterQueue;", "Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue;", "queueName", "", "jedisCluster", "Lredis/clients/jedis/JedisCluster;", "clock", "Ljava/time/Clock;", "lockTtlSeconds", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "ackTimeout", "Ljava/time/temporal/TemporalAmount;", "deadMessageHandlers", "", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Queue;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "canPollMany", "", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "(Ljava/lang/String;Lredis/clients/jedis/JedisCluster;Ljava/time/Clock;ILcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/Optional;Ljava/time/temporal/TemporalAmount;Ljava/util/List;ZLcom/netflix/spinnaker/q/metrics/EventPublisher;)V", "getAckTimeout", "()Ljava/time/temporal/TemporalAmount;", "attemptsKey", "getAttemptsKey$keiko_redis", "()Ljava/lang/String;", "getCanPollMany", "()Z", "getDeadMessageHandlers", "()Ljava/util/List;", "locksKey", "getLocksKey$keiko_redis", "log", "Lorg/slf4j/Logger;", "getLog$keiko_redis", "()Lorg/slf4j/Logger;", "messagesKey", "getMessagesKey$keiko_redis", "getPublisher", "()Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "queueKey", "getQueueKey$keiko_redis", "readMessageWithLockScriptSha", "getReadMessageWithLockScriptSha", "setReadMessageWithLockScriptSha", "(Ljava/lang/String;)V", "unackedKey", "getUnackedKey$keiko_redis", "ackMessage", "fingerprint", "cacheScript", "containsMessage", "predicate", "Lkotlin/Function1;", "ensure", "message", "delay", "poll", "callback", "Lkotlin/Function0;", "maxMessages", "Lcom/netflix/spinnaker/q/QueueCallback;", "push", "readState", "Lcom/netflix/spinnaker/q/metrics/QueueState;", "reschedule", "retry", "multi", "", "", "kotlin.jvm.PlatformType", "block", "Lredis/clients/jedis/Transaction;", "Lkotlin/ExtensionFunctionType;", "queueMessage", "queueMessage$keiko_redis", "readMessage", "json", "readMessage$keiko_redis", "readMessageWithLock", "Lkotlin/Triple;", "Ljava/time/Instant;", "readMessageWithLock$keiko_redis", "readMessageWithoutLock", "readMessageWithoutLock$keiko_redis", "removeMessage", "removeMessage$keiko_redis", "requeueMessage", "requeueMessage$keiko_redis", "keiko-redis"})
public final class RedisClusterQueue
extends AbstractRedisQueue {
    @NotNull
    private final String queueName;
    @NotNull
    private final JedisCluster jedisCluster;
    @NotNull
    private final Clock clock;
    private final int lockTtlSeconds;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Optional<SerializationMigrator> serializationMigrator;
    @NotNull
    private final TemporalAmount ackTimeout;
    @NotNull
    private final List<Function2<Queue, Message, Unit>> deadMessageHandlers;
    private final boolean canPollMany;
    @NotNull
    private final EventPublisher publisher;
    @NotNull
    private final Logger log;
    @NotNull
    private final String queueKey;
    @NotNull
    private final String unackedKey;
    @NotNull
    private final String messagesKey;
    @NotNull
    private final String locksKey;
    @NotNull
    private final String attemptsKey;
    public String readMessageWithLockScriptSha;

    public RedisClusterQueue(@NotNull String queueName, @NotNull JedisCluster jedisCluster, @NotNull Clock clock, int lockTtlSeconds, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull TemporalAmount ackTimeout, @NotNull List<? extends Function2<? super Queue, ? super Message, Unit>> deadMessageHandlers, boolean canPollMany, @NotNull EventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter((Object)jedisCluster, (String)"jedisCluster");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)ackTimeout, (String)"ackTimeout");
        Intrinsics.checkNotNullParameter(deadMessageHandlers, (String)"deadMessageHandlers");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        super(clock, lockTtlSeconds, mapper, serializationMigrator, ackTimeout, deadMessageHandlers, canPollMany, publisher);
        this.queueName = queueName;
        this.jedisCluster = jedisCluster;
        this.clock = clock;
        this.lockTtlSeconds = lockTtlSeconds;
        this.mapper = mapper;
        this.serializationMigrator = serializationMigrator;
        this.ackTimeout = ackTimeout;
        this.deadMessageHandlers = deadMessageHandlers;
        this.canPollMany = canPollMany;
        this.publisher = publisher;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
        this.queueKey = "{" + this.queueName + "}.queue";
        this.unackedKey = "{" + this.queueName + "}.unacked";
        this.messagesKey = "{" + this.queueName + "}.messages";
        this.locksKey = "{" + this.queueName + "}.locks";
        this.attemptsKey = "{" + this.queueName + "}.attempts";
        this.cacheScript();
        this.log.info("Configured " + this.getClass() + " queue: " + this.queueName);
    }

    public /* synthetic */ RedisClusterQueue(String string, JedisCluster jedisCluster, Clock clock, int n, ObjectMapper objectMapper, Optional optional, TemporalAmount temporalAmount, List list, boolean bl, EventPublisher eventPublisher, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        if ((n2 & 0x40) != 0) {
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
            temporalAmount = duration;
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(string, jedisCluster, clock, n, objectMapper, optional, temporalAmount, list, bl, eventPublisher);
    }

    @Override
    @NotNull
    public TemporalAmount getAckTimeout() {
        return this.ackTimeout;
    }

    @Override
    @NotNull
    public List<Function2<Queue, Message, Unit>> getDeadMessageHandlers() {
        return this.deadMessageHandlers;
    }

    @Override
    public boolean getCanPollMany() {
        return this.canPollMany;
    }

    @Override
    @NotNull
    public EventPublisher getPublisher() {
        return this.publisher;
    }

    @Override
    @NotNull
    public final Logger getLog$keiko_redis() {
        return this.log;
    }

    @Override
    @NotNull
    public String getQueueKey$keiko_redis() {
        return this.queueKey;
    }

    @Override
    @NotNull
    public String getUnackedKey$keiko_redis() {
        return this.unackedKey;
    }

    @Override
    @NotNull
    public String getMessagesKey$keiko_redis() {
        return this.messagesKey;
    }

    @Override
    @NotNull
    public String getLocksKey$keiko_redis() {
        return this.locksKey;
    }

    @Override
    @NotNull
    public String getAttemptsKey$keiko_redis() {
        return this.attemptsKey;
    }

    @Override
    @NotNull
    public String getReadMessageWithLockScriptSha() {
        String string = this.readMessageWithLockScriptSha;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"readMessageWithLockScriptSha");
        return null;
    }

    @Override
    public void setReadMessageWithLockScriptSha(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.readMessageWithLockScriptSha = string;
    }

    @Override
    public final void cacheScript() {
        String string = this.jedisCluster.scriptLoad("\n  local queueKey = KEYS[1]\n  local unackKey = KEYS[2]\n  local lockKey = KEYS[3]\n  local messagesKey = KEYS[4]\n  local maxScore = ARGV[1]\n  local peekFingerprintCount = ARGV[2]\n  local lockTtlSeconds = ARGV[3]\n  local unackDefaultScore = ARGV[4]\n  local unackBaseScore = ARGV[5]\n\n  local not_empty = function(x)\n    return (type(x) == \"table\") and (not x.err) and (#x ~= 0)\n  end\n\n  local acquire_lock = function(fingerprints, locksKey, lockTtlSeconds)\n    if not_empty(fingerprints) then\n      local i=1\n      while (i <= #fingerprints) do\n        redis.call(\"ECHO\", \"attempting lock on \" .. fingerprints[i])\n        if redis.call(\"SET\", locksKey .. \":\" .. fingerprints[i], \"\\uD83D\\uDD12\", \"EX\", lockTtlSeconds, \"NX\") then\n          redis.call(\"ECHO\", \"acquired lock on \" .. fingerprints[i])\n          return fingerprints[i], fingerprints[i+1]\n        end\n        i=i+2\n      end\n    end\n    return nil, nil\n  end\n\n  -- acquire a lock on a fingerprint\n  local fingerprints = redis.call(\"ZRANGEBYSCORE\", queueKey, 0.0, maxScore, \"WITHSCORES\", \"LIMIT\", 0, peekFingerprintCount)\n  local fingerprint, fingerprintScore = acquire_lock(fingerprints, lockKey, lockTtlSeconds)\n\n  -- no lock could be acquired\n  if fingerprint == nil then\n    if #fingerprints == 0 then\n      return \"NoReadyMessages\"\n    end\n    return \"AcquireLockFailed\"\n  end\n\n  \n  local java_scientific = function(x)\n    return string.format(\"%.12E\", x):gsub(\"\\+\", \"\")\n  end\n\n  -- get the message, move the fingerprint to the unacked queue and return\n  local message = redis.call(\"HGET\", messagesKey, fingerprint)\n\n  -- check for an ack timeout override on the message\n  local unackScore = unackDefaultScore\n  if type(message) == \"string\" and message ~= nil then\n    local ackTimeoutOverride = tonumber(cjson.decode(message)[\"ackTimeoutMs\"])\n    if ackTimeoutOverride ~= nil and unackBaseScore ~= nil then\n      unackScore = unackBaseScore + ackTimeoutOverride\n    end\n  end\n\n  unackScore = java_scientific(unackScore)\n\n  redis.call(\"ZREM\", queueKey, fingerprint)\n  redis.call(\"ZADD\", unackKey, unackScore, fingerprint)\n\n\n  return {fingerprint, fingerprintScore, message}\n", this.getQueueKey$keiko_redis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jedisCluster.scriptLoad(\u2026_WITH_LOCK_SRC, queueKey)");
        this.setReadMessageWithLockScriptSha(string);
    }

    public void poll(@NotNull Function2<? super Message, ? super Function0<Unit>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Triple<String, Instant, String> triple = this.readMessageWithLock$keiko_redis(this.jedisCluster);
        if (triple != null) {
            Triple<String, Instant, String> triple2 = triple;
            boolean bl = false;
            boolean bl2 = false;
            Triple<String, Instant, String> $dstr$fingerprint$scheduledTime$json = triple2;
            boolean bl3 = false;
            String fingerprint = (String)$dstr$fingerprint$scheduledTime$json.component1();
            Instant scheduledTime = (Instant)$dstr$fingerprint$scheduledTime$json.component2();
            String json = (String)$dstr$fingerprint$scheduledTime$json.component3();
            Function0 ack2 = Partials.partially1((Function1)((Function1)new Function1<String, Unit>((Object)this){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    RedisClusterQueue.access$ackMessage((RedisClusterQueue)this.receiver, p0);
                }
            }), (Object)fingerprint);
            this.readMessage$keiko_redis(this.jedisCluster, fingerprint, json, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(this, fingerprint, scheduledTime, callback, (Function0<Unit>)ack2){
                final /* synthetic */ RedisClusterQueue this$0;
                final /* synthetic */ String $fingerprint;
                final /* synthetic */ Instant $scheduledTime;
                final /* synthetic */ Function2<Message, Function0<Unit>, Unit> $callback;
                final /* synthetic */ Function0<Unit> $ack;
                {
                    this.this$0 = $receiver;
                    this.$fingerprint = $fingerprint;
                    this.$scheduledTime = $scheduledTime;
                    this.$callback = $callback;
                    this.$ack = $ack;
                    super(1);
                }

                public final void invoke(@NotNull Message message) {
                    int n;
                    Object object;
                    int maxAttempts;
                    Object v1;
                    int attempts;
                    block5: {
                        int n2;
                        AttemptsAttribute attemptsAttribute;
                        Object v0;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            Message this_$iv = message;
                            boolean $i$f$getAttribute = false;
                            Iterable iterable = this_$iv.getAttributes();
                            boolean bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl2 = false;
                            for (Object object2 : iterable2) {
                                Attribute it$iv = (Attribute)object2;
                                boolean bl3 = false;
                                if (!(it$iv instanceof AttemptsAttribute)) continue;
                                v0 = object2;
                                break block4;
                            }
                            v0 = null;
                        }
                        attempts = (attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0))) == null ? 0 : (n2 = attemptsAttribute.getAttempts());
                        Message this_$iv = message;
                        boolean $i$f$getAttribute = false;
                        Iterable iterable = this_$iv.getAttributes();
                        boolean bl = false;
                        Iterable iterable3 = iterable;
                        boolean bl4 = false;
                        for (E e : iterable3) {
                            Attribute it$iv = (Attribute)e;
                            boolean bl5 = false;
                            if (!(it$iv instanceof MaxAttemptsAttribute)) continue;
                            v1 = e;
                            break block5;
                        }
                        v1 = null;
                    }
                    int n3 = maxAttempts = (object = (MaxAttemptsAttribute)((Attribute)((MaxAttemptsAttribute)v1))) == null ? 0 : (n = object.getMaxAttempts());
                    if (maxAttempts > 0 && attempts > maxAttempts) {
                        this.this$0.getLog$keiko_redis().warn("Message " + this.$fingerprint + " with payload " + message + " exceeded " + maxAttempts + " retries");
                        this.this$0.handleDeadMessage$keiko_redis(message);
                        this.this$0.removeMessage$keiko_redis(RedisClusterQueue.access$getJedisCluster$p(this.this$0), this.$fingerprint);
                        this.this$0.fire((QueueEvent)MessageDead.INSTANCE);
                    } else {
                        object = RedisClusterQueue.access$getClock$p(this.this$0).instant();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clock.instant()");
                        this.this$0.fire((QueueEvent)new MessageProcessing(message, this.$scheduledTime, (Instant)object));
                        this.$callback.invoke((Object)message, this.$ack);
                    }
                }
            }));
        }
        this.fire((QueueEvent)QueuePolled.INSTANCE);
    }

    public void poll(int maxMessages, @NotNull Function2<? super Message, ? super Function0<Unit>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.poll(callback);
    }

    public void push(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        String string = this.firstFingerprint$keiko_redis((JedisClusterCommands)this.jedisCluster, this.getQueueKey$keiko_redis(), this.fingerprint$keiko_redis(message));
        boolean bl = false;
        boolean bl2 = false;
        String fingerprint = string;
        boolean bl3 = false;
        if (fingerprint != null) {
            this.getLog$keiko_redis().info("Re-prioritizing message as an identical one is already on the queue: " + fingerprint + ", message: " + message);
            this.jedisCluster.zadd(this.getQueueKey$keiko_redis(), this.score$keiko_redis(delay), fingerprint, ZAddParams.zAddParams().xx());
            this.fire((QueueEvent)new MessageDuplicate(message));
        } else {
            this.queueMessage$keiko_redis(this.jedisCluster, message, delay);
            this.fire((QueueEvent)new MessagePushed(message));
        }
    }

    public void reschedule(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        String fingerprint = this.fingerprint$keiko_redis(message).getLatest();
        this.log.debug("Re-scheduling message: " + message + ", fingerprint: " + fingerprint + " to deliver in " + delay);
        Long l = this.jedisCluster.zadd(this.getQueueKey$keiko_redis(), this.score$keiko_redis(delay), fingerprint, ZAddParams.zAddParams().xx());
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"jedisCluster.zadd(queueK\u2026print, zAddParams().xx())");
        long status = ((Number)l).longValue();
        if ((int)status == 1) {
            this.fire((QueueEvent)new MessageRescheduled(message));
        } else {
            this.fire((QueueEvent)new MessageNotFound(message));
        }
    }

    public void ensure(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        AbstractRedisQueue.Fingerprint fingerprint = this.fingerprint$keiko_redis(message);
        if (!this.anyZismember$keiko_redis((JedisClusterCommands)this.jedisCluster, this.getQueueKey$keiko_redis(), fingerprint.getAll()) && !this.anyZismember$keiko_redis((JedisClusterCommands)this.jedisCluster, this.getUnackedKey$keiko_redis(), fingerprint.getAll())) {
            this.log.debug("Pushing ensured message onto queue as it does not exist in queue or unacked sets");
            this.push(message, delay);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Scheduled(fixedDelayString="${queue.retry.frequency.ms:10000}")
    public void retry() {
        Set set = this.jedisCluster.zrangeByScore(this.getUnackedKey$keiko_redis(), 0.0, AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null));
        boolean bl = false;
        boolean bl2 = false;
        Set fingerprints = set;
        boolean bl3 = false;
        if (fingerprints.size() > 0) {
            void $this$mapTo$iv$iv;
            List $this$map$iv;
            Intrinsics.checkNotNullExpressionValue((Object)fingerprints, (String)"fingerprints");
            Iterable iterable = fingerprints;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String string2 = this.getLocksKey$keiko_redis() + ":" + (String)it;
                collection.add(string2);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            boolean bl5 = false;
            List it = $this$map$iv;
            boolean bl6 = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            this.jedisCluster.del(Arrays.copyOf(stringArray2, stringArray2.length));
        }
        Intrinsics.checkNotNullExpressionValue((Object)fingerprints, (String)"fingerprints");
        Iterable $this$forEach$iv = fingerprints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fingerprint = (String)element$iv;
            boolean bl7 = false;
            AbstractRedisQueue abstractRedisQueue = this;
            JedisClusterCommands jedisClusterCommands = (JedisClusterCommands)this.jedisCluster;
            String string = this.getAttemptsKey$keiko_redis();
            Intrinsics.checkNotNullExpressionValue((Object)fingerprint, (String)"fingerprint");
            int attempts = AbstractRedisQueue.hgetInt$keiko_redis$default(abstractRedisQueue, jedisClusterCommands, string, fingerprint, 0, 4, null);
            this.readMessageWithoutLock$keiko_redis(this.jedisCluster, fingerprint, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(attempts, this, fingerprint){
                final /* synthetic */ int $attempts;
                final /* synthetic */ RedisClusterQueue this$0;
                final /* synthetic */ String $fingerprint;
                {
                    this.$attempts = $attempts;
                    this.this$0 = $receiver;
                    this.$fingerprint = $fingerprint;
                    super(1);
                }

                public final void invoke(@NotNull Message message) {
                    int n;
                    Object object;
                    int maxAttempts;
                    Object v0;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        Message this_$iv = message;
                        boolean $i$f$getAttribute = false;
                        Iterable iterable = this_$iv.getAttributes();
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (T t : iterable2) {
                            Attribute it$iv = (Attribute)t;
                            boolean bl3 = false;
                            if (!(it$iv instanceof MaxAttemptsAttribute)) continue;
                            v0 = t;
                            break block5;
                        }
                        v0 = null;
                    }
                    int n2 = maxAttempts = (object = (MaxAttemptsAttribute)((Attribute)((MaxAttemptsAttribute)v0))) == null ? 0 : (n = object.getMaxAttempts());
                    if (maxAttempts == 0 && this.$attempts >= Queue.Companion.getMaxRetries() - 1) {
                        this.this$0.getLog$keiko_redis().warn("Message " + this.$fingerprint + " with payload " + message + " exceeded max retries");
                        this.this$0.handleDeadMessage$keiko_redis(message);
                        JedisCluster jedisCluster = RedisClusterQueue.access$getJedisCluster$p(this.this$0);
                        object = this.$fingerprint;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fingerprint");
                        this.this$0.removeMessage$keiko_redis(jedisCluster, (String)object);
                        this.this$0.fire((QueueEvent)MessageDead.INSTANCE);
                    } else {
                        JedisClusterCommands jedisClusterCommands = (JedisClusterCommands)RedisClusterQueue.access$getJedisCluster$p(this.this$0);
                        String string = this.this$0.getQueueKey$keiko_redis();
                        object = this.$fingerprint;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fingerprint");
                        if (this.this$0.zismember$keiko_redis(jedisClusterCommands, string, (String)object)) {
                            this.this$0.multi(RedisClusterQueue.access$getJedisCluster$p(this.this$0), (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this.this$0, this.$fingerprint){
                                final /* synthetic */ RedisClusterQueue this$0;
                                final /* synthetic */ String $fingerprint;
                                {
                                    this.this$0 = $receiver;
                                    this.$fingerprint = $fingerprint;
                                    super(1);
                                }

                                public final void invoke(@NotNull Transaction $this$multi) {
                                    Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                                    String[] stringArray = new String[]{this.$fingerprint};
                                    $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                                    $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null), this.$fingerprint);
                                    $this$multi.hincrBy(this.this$0.getAttemptsKey$keiko_redis(), this.$fingerprint, 1L);
                                }
                            }));
                            this.this$0.getLog$keiko_redis().info("Not retrying message " + this.$fingerprint + " because an identical message is already on the queue");
                            this.this$0.fire((QueueEvent)new MessageDuplicate(message));
                        } else {
                            this.this$0.getLog$keiko_redis().warn("Retrying message " + this.$fingerprint + " after " + this.$attempts + " attempts");
                            RedisClusterQueue.access$getJedisCluster$p(this.this$0).hincrBy(this.this$0.getAttemptsKey$keiko_redis(), this.$fingerprint, 1L);
                            JedisCluster jedisCluster = RedisClusterQueue.access$getJedisCluster$p(this.this$0);
                            object = this.$fingerprint;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fingerprint");
                            this.this$0.requeueMessage$keiko_redis(jedisCluster, (String)object);
                            this.this$0.fire((QueueEvent)MessageRetried.INSTANCE);
                        }
                    }
                }
            }));
        }
        set = Unit.INSTANCE;
        bl = false;
        bl2 = false;
        Set it = set;
        boolean bl8 = false;
        this.fire((QueueEvent)RetryPolled.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public QueueState readState() {
        boolean $i$a$-map-RedisClusterQueue$readState$32;
        void $this$mapTo$iv$iv;
        List list = this.multi(this.jedisCluster, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this){
            final /* synthetic */ RedisClusterQueue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                $this$multi.zcard(this.this$0.getQueueKey$keiko_redis());
                $this$multi.zcount(this.this$0.getQueueKey$keiko_redis(), 0.0, AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null));
                $this$multi.zcard(this.this$0.getUnackedKey$keiko_redis());
                $this$multi.hlen(this.this$0.getMessagesKey$keiko_redis());
            }
        }));
        Intrinsics.checkNotNullExpressionValue(list, (String)"override fun readState()\u2026essing)\n        )\n      }");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv22;
            Object t = item$iv$iv22 = object.next();
            Collection collection = destination$iv$iv;
            $i$a$-map-RedisClusterQueue$readState$32 = false;
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            Integer n = (int)((Long)it).longValue();
            collection.add(n);
        }
        list = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List $dstr$queued$ready$processing$messages = list;
        boolean bl3 = false;
        object = $dstr$queued$ready$processing$messages;
        boolean item$iv$iv22 = false;
        int queued = ((Number)object.get(0)).intValue();
        List item$iv$iv22 = $dstr$queued$ready$processing$messages;
        $i$a$-map-RedisClusterQueue$readState$32 = false;
        int ready = ((Number)item$iv$iv22.get(1)).intValue();
        List $i$a$-map-RedisClusterQueue$readState$32 = $dstr$queued$ready$processing$messages;
        boolean bl4 = false;
        int processing = ((Number)$i$a$-map-RedisClusterQueue$readState$32.get(2)).intValue();
        List list2 = $dstr$queued$ready$processing$messages;
        boolean bl5 = false;
        int messages = ((Number)list2.get(3)).intValue();
        return new QueueState(queued, ready, processing, messages - (queued + processing), 0, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsMessage(@NotNull Function1<? super Message, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean found = false;
        Object cursor = null;
        cursor = "0";
        while (!found) {
            boolean bl;
            boolean bl2;
            Object object;
            ScanResult $this$containsMessage_u24lambda_u2d10;
            block5: {
                void $this$any$iv;
                Collection<Message> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                ScanResult scanResult = this.jedisCluster.hscan(this.getMessagesKey$keiko_redis(), (String)cursor);
                boolean bl3 = false;
                boolean bl4 = false;
                $this$containsMessage_u24lambda_u2d10 = scanResult;
                boolean bl5 = false;
                object = $this$containsMessage_u24lambda_u2d10.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result");
                object = (Iterable)object;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$readValue$iv;
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    AbstractRedisQueue abstractRedisQueue = this;
                    ObjectMapper objectMapper = this.mapper;
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                    String content$iv = (String)v;
                    boolean $i$f$readValue$keiko_redis = false;
                    Message message = (Message)$this$readValue$iv.readValue(content$iv, Message.class);
                    collection.add(message);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            found = bl = bl2;
            object = $this$containsMessage_u24lambda_u2d10.getCursor();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCursor()");
            cursor = object;
            if (!Intrinsics.areEqual((Object)cursor, (Object)"0")) continue;
            break;
        }
        return found;
    }

    /*
     * WARNING - void declaration
     */
    public final void queueMessage$keiko_redis(@NotNull JedisCluster $this$queueMessage, @NotNull Message message, @NotNull TemporalAmount delay) {
        void attribute$iv;
        void this_$iv;
        AttemptsAttribute attemptsAttribute;
        Object v0;
        String fingerprint;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$queueMessage, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
            fingerprint = this.fingerprint$keiko_redis(message).getLatest();
            Message message2 = message;
            Message this_$iv2 = message;
            boolean $i$f$getAttribute = false;
            Iterable iterable = this_$iv2.getAttributes();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Attribute it$iv = (Attribute)t;
                boolean bl3 = false;
                if (!(it$iv instanceof AttemptsAttribute)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        attemptsAttribute = (Attribute)((attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0))) == null ? new AttemptsAttribute(0, 1, null) : attemptsAttribute);
        boolean $i$f$setAttribute = false;
        this_$iv.getAttributes().removeIf(new Predicate(){

            public final boolean test(@NotNull Attribute it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof AttemptsAttribute;
            }
        });
        this_$iv.getAttributes().add(attribute$iv);
        this.multi($this$queueMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint, message, delay){
            final /* synthetic */ RedisClusterQueue this$0;
            final /* synthetic */ String $fingerprint;
            final /* synthetic */ Message $message;
            final /* synthetic */ TemporalAmount $delay;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                this.$message = $message;
                this.$delay = $delay;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                $this$multi.hset(this.this$0.getMessagesKey$keiko_redis(), this.$fingerprint, RedisClusterQueue.access$getMapper$p(this.this$0).writeValueAsString((Object)this.$message));
                $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), this.this$0.score$keiko_redis(this.$delay), this.$fingerprint);
            }
        }));
    }

    public static /* synthetic */ void queueMessage$keiko_redis$default(RedisClusterQueue redisClusterQueue, JedisCluster jedisCluster, Message message, TemporalAmount temporalAmount, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            temporalAmount = duration;
        }
        redisClusterQueue.queueMessage$keiko_redis(jedisCluster, message, temporalAmount);
    }

    public final void requeueMessage$keiko_redis(@NotNull JedisCluster $this$requeueMessage, @NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$requeueMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.multi($this$requeueMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
            final /* synthetic */ RedisClusterQueue this$0;
            final /* synthetic */ String $fingerprint;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                String[] stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null), this.$fingerprint);
            }
        }));
    }

    public final void removeMessage$keiko_redis(@NotNull JedisCluster $this$removeMessage, @NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$removeMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.multi($this$removeMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
            final /* synthetic */ RedisClusterQueue this$0;
            final /* synthetic */ String $fingerprint;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                String[] stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getQueueKey$keiko_redis(), stringArray);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.hdel(this.this$0.getMessagesKey$keiko_redis(), stringArray);
                $this$multi.del(this.this$0.getLocksKey$keiko_redis() + ":" + this.$fingerprint);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.hdel(this.this$0.getAttemptsKey$keiko_redis(), stringArray);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void readMessageWithoutLock$keiko_redis(@NotNull JedisCluster $this$readMessageWithoutLock, @NotNull String fingerprint, @NotNull Function1<? super Message, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessageWithoutLock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            void $this$readValue$iv;
            String string = $this$readMessageWithoutLock.hget(this.getMessagesKey$keiko_redis(), fingerprint);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            AbstractRedisQueue abstractRedisQueue = this;
            ObjectMapper objectMapper = this.mapper;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String content$iv = this.runSerializationMigration$keiko_redis(it);
            boolean $i$f$readValue$keiko_redis = false;
            Message message = (Message)$this$readValue$iv.readValue(content$iv, Message.class);
            block.invoke((Object)message);
        }
        catch (IOException e) {
            this.log.error("Failed to read unacked message " + fingerprint + ", requeuing...", (Throwable)e);
            $this$readMessageWithoutLock.hincrBy(this.getAttemptsKey$keiko_redis(), fingerprint, 1L);
            this.requeueMessage$keiko_redis($this$readMessageWithoutLock, fingerprint);
        }
        catch (JsonParseException e) {
            this.log.error("Payload for unacked message " + fingerprint + " is missing or corrupt", (Throwable)e);
            this.removeMessage$keiko_redis($this$readMessageWithoutLock, fingerprint);
        }
    }

    @Nullable
    public final Triple<String, Instant, String> readMessageWithLock$keiko_redis(@NotNull JedisCluster $this$readMessageWithLock) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessageWithLock, (String)"<this>");
        try {
            Object object = new String[]{this.getQueueKey$keiko_redis(), this.getUnackedKey$keiko_redis(), this.getLocksKey$keiko_redis(), this.getMessagesKey$keiko_redis()};
            List list = CollectionsKt.listOf((Object[])object);
            object = new String[5];
            object[0] = String.valueOf(AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null));
            object[1] = "10";
            object[2] = String.valueOf(this.lockTtlSeconds);
            Object[] objectArray = new Object[]{this.score$keiko_redis(this.getAckTimeout())};
            object[3] = String.format(Locale.US, "%f", objectArray);
            objectArray = new Object[]{AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null)};
            object[4] = String.format(Locale.US, "%f", objectArray);
            Object response = $this$readMessageWithLock.evalsha(this.getReadMessageWithLockScriptSha(), list, CollectionsKt.listOf((Object[])object));
            if (response instanceof List) {
                object = String.valueOf(((List)response).get(1));
                boolean bl = false;
                return new Triple((Object)String.valueOf(((List)response).get(0)), (Object)Instant.ofEpochMilli(Long.parseLong((String)object)), (Object)((object = ((List)response).get(2)) == null ? null : object.toString()));
            }
            if (Intrinsics.areEqual((Object)response, (Object)"ReadLockFailed")) {
                this.fire((QueueEvent)LockFailed.INSTANCE);
            }
        }
        catch (JedisDataException e) {
            String string = e.getMessage();
            if (StringsKt.startsWith$default((String)(string == null ? "" : string), (String)"NOSCRIPT", (boolean)false, (int)2, null)) {
                this.cacheScript();
                return this.readMessageWithLock$keiko_redis($this$readMessageWithLock);
            }
            throw e;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void readMessage$keiko_redis(@NotNull JedisCluster $this$readMessage, @NotNull String fingerprint, @Nullable String json, @NotNull Function1<? super Message, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (json == null) {
            this.log.error("Payload for message " + fingerprint + " is missing");
            this.removeMessage$keiko_redis($this$readMessage, fingerprint);
        } else {
            try {
                AttemptsAttribute attemptsAttribute;
                Object v0;
                Message $this$readMessage_u24lambda_u2d13;
                Object object;
                block5: {
                    void $this$readValue$iv;
                    object = this;
                    ObjectMapper objectMapper = this.mapper;
                    String content$iv = this.runSerializationMigration$keiko_redis(json);
                    boolean $i$f$readValue$keiko_redis = false;
                    object = $this$readValue$iv.readValue(content$iv, Message.class);
                    boolean bl = false;
                    boolean bl2 = false;
                    $this$readMessage_u24lambda_u2d13 = (Message)object;
                    boolean bl3 = false;
                    Message this_$iv = $this$readMessage_u24lambda_u2d13;
                    boolean $i$f$getAttribute = false;
                    Iterable iterable = this_$iv.getAttributes();
                    boolean bl4 = false;
                    Iterable iterable2 = iterable;
                    boolean bl5 = false;
                    for (Object t : iterable2) {
                        Attribute it$iv = (Attribute)t;
                        boolean bl6 = false;
                        if (!(it$iv instanceof AttemptsAttribute)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                attemptsAttribute = (attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0))) == null ? new AttemptsAttribute(0, 1, null) : attemptsAttribute;
                boolean this_$iv = false;
                boolean bl = false;
                AttemptsAttribute $this$readMessage_u24lambda_u2d13_u24lambda_u2d12 = attemptsAttribute;
                boolean bl7 = false;
                AttemptsAttribute currentAttempts = $this$readMessage_u24lambda_u2d13_u24lambda_u2d12.copy($this$readMessage_u24lambda_u2d13_u24lambda_u2d12.getAttempts() + 1);
                Message this_$iv2 = $this$readMessage_u24lambda_u2d13;
                boolean $i$f$setAttribute = false;
                this_$iv2.getAttributes().removeIf(new Predicate(){

                    public final boolean test(@NotNull Attribute it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it instanceof AttemptsAttribute;
                    }
                });
                this_$iv2.getAttributes().add((Attribute)currentAttempts);
                Attribute cfr_ignored_0 = (Attribute)currentAttempts;
                Message message = (Message)object;
                $this$readMessage.hset(this.getMessagesKey$keiko_redis(), fingerprint, this.mapper.writeValueAsString((Object)message));
                block.invoke((Object)message);
            }
            catch (IOException e) {
                this.log.error("Failed to read message " + fingerprint + ", requeuing...", (Throwable)e);
                $this$readMessage.hincrBy(this.getAttemptsKey$keiko_redis(), fingerprint, 1L);
                this.requeueMessage$keiko_redis($this$readMessage, fingerprint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Object> multi(@NotNull JedisCluster $this$multi, @NotNull Function1<? super Transaction, Unit> block) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = (Closeable)$this$multi.getConnectionFromSlot(JedisClusterCRC16.getSlot((String)this.getQueueKey$keiko_redis()));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Jedis c = (Jedis)closeable;
            boolean bl3 = false;
            Transaction transaction = c.multi();
            boolean bl4 = false;
            boolean bl5 = false;
            Transaction tx = transaction;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"tx");
            block.invoke((Object)tx);
            list = tx.exec();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    private final void ackMessage(String fingerprint) {
        if (this.zismember$keiko_redis((JedisClusterCommands)this.jedisCluster, this.getQueueKey$keiko_redis(), fingerprint)) {
            this.multi(this.jedisCluster, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
                final /* synthetic */ RedisClusterQueue this$0;
                final /* synthetic */ String $fingerprint;
                {
                    this.this$0 = $receiver;
                    this.$fingerprint = $fingerprint;
                    super(1);
                }

                public final void invoke(@NotNull Transaction $this$multi) {
                    Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                    String[] stringArray = new String[]{this.$fingerprint};
                    $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                    $this$multi.del(this.this$0.getLocksKey$keiko_redis() + ":" + this.$fingerprint);
                }
            }));
        } else {
            this.removeMessage$keiko_redis(this.jedisCluster, fingerprint);
        }
        this.fire((QueueEvent)MessageAcknowledged.INSTANCE);
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(RedisClusterQueue $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ void access$ackMessage(RedisClusterQueue $this, String fingerprint) {
        $this.ackMessage(fingerprint);
    }

    public static final /* synthetic */ JedisCluster access$getJedisCluster$p(RedisClusterQueue $this) {
        return $this.jedisCluster;
    }

    public static final /* synthetic */ Clock access$getClock$p(RedisClusterQueue $this) {
        return $this.clock;
    }
}

