/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.redis;

import arrow.core.Partials;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.KotlinOpen;
import com.netflix.spinnaker.q.AttemptsAttribute;
import com.netflix.spinnaker.q.Attribute;
import com.netflix.spinnaker.q.MaxAttemptsAttribute;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.metrics.LockFailed;
import com.netflix.spinnaker.q.metrics.MessageAcknowledged;
import com.netflix.spinnaker.q.metrics.MessageDead;
import com.netflix.spinnaker.q.metrics.MessageDuplicate;
import com.netflix.spinnaker.q.metrics.MessageNotFound;
import com.netflix.spinnaker.q.metrics.MessageProcessing;
import com.netflix.spinnaker.q.metrics.MessagePushed;
import com.netflix.spinnaker.q.metrics.MessageRescheduled;
import com.netflix.spinnaker.q.metrics.MessageRetried;
import com.netflix.spinnaker.q.metrics.QueueEvent;
import com.netflix.spinnaker.q.metrics.QueuePolled;
import com.netflix.spinnaker.q.metrics.QueueState;
import com.netflix.spinnaker.q.metrics.RetryPolled;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.AbstractRedisQueue;
import com.netflix.spinnaker.q.redis.RedisQueue$queueMessage$;
import com.netflix.spinnaker.q.redis.RedisQueue$readMessage$lambda-23$;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.util.Pool;

@KotlinOpen
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\"\u0010\u0012\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014j\u0002`\u00180\u0013\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0010\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0003H\u0002J\u0006\u0010;\u001a\u00020\u0017J\b\u0010<\u001a\u00020\u0017H\u0016J\u001c\u0010=\u001a\u00020\u001a2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a0?H\u0016J\u0018\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u0011H\u0016J(\u0010C\u001a\u00020\u00172\u001e\u0010D\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170E\u0012\u0004\u0012\u00020\u00170\u0014H\u0016J4\u0010C\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\n2\"\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170E\u0012\u0004\u0012\u00020\u00170\u0014j\u0002`GH\u0016J\u0018\u0010H\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u0011H\u0016J\b\u0010I\u001a\u00020JH\u0016J\u0018\u0010K\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u0011H\u0016J\b\u0010L\u001a\u00020\u0017H\u0017J\b\u0010M\u001a\u00020\u0003H\u0016J#\u0010N\u001a\u00020\u0017*\u00020\u00062\u0006\u0010A\u001a\u00020\u00162\b\b\u0002\u0010B\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bOJ7\u0010P\u001a\u00020\u0017*\u00020\u00062\u0006\u0010:\u001a\u00020\u00032\b\u0010Q\u001a\u0004\u0018\u00010\u00032\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170?H\u0000\u00a2\u0006\u0002\bSJ'\u0010T\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020V\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010U*\u00020WH\u0000\u00a2\u0006\u0002\bXJ-\u0010Y\u001a\u00020\u0017*\u00020\u00062\u0006\u0010:\u001a\u00020\u00032\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170?H\u0000\u00a2\u0006\u0002\bZJ\u0019\u0010[\u001a\u00020\u0017*\u00020\u00062\u0006\u0010:\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\\J\u0019\u0010]\u001a\u00020\u0017*\u00020\u00062\u0006\u0010:\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b^R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0012\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014j\u0002`\u00180\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\"R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\"\"\u0004\b5\u00106R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\"\u00a8\u0006_"}, d2={"Lcom/netflix/spinnaker/q/redis/RedisQueue;", "Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue;", "queueName", "", "pool", "Lredis/clients/jedis/util/Pool;", "Lredis/clients/jedis/Jedis;", "clock", "Ljava/time/Clock;", "lockTtlSeconds", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "ackTimeout", "Ljava/time/temporal/TemporalAmount;", "deadMessageHandlers", "", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Queue;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "canPollMany", "", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "(Ljava/lang/String;Lredis/clients/jedis/util/Pool;Ljava/time/Clock;ILcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/Optional;Ljava/time/temporal/TemporalAmount;Ljava/util/List;ZLcom/netflix/spinnaker/q/metrics/EventPublisher;)V", "getAckTimeout", "()Ljava/time/temporal/TemporalAmount;", "attemptsKey", "getAttemptsKey$keiko_redis", "()Ljava/lang/String;", "getCanPollMany", "()Z", "getDeadMessageHandlers", "()Ljava/util/List;", "locksKey", "getLocksKey$keiko_redis", "log", "Lorg/slf4j/Logger;", "getLog$keiko_redis", "()Lorg/slf4j/Logger;", "messagesKey", "getMessagesKey$keiko_redis", "getPublisher", "()Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "queueKey", "getQueueKey$keiko_redis", "readMessageWithLockScriptSha", "getReadMessageWithLockScriptSha", "setReadMessageWithLockScriptSha", "(Ljava/lang/String;)V", "unackedKey", "getUnackedKey$keiko_redis", "ackMessage", "fingerprint", "cacheScript", "clear", "containsMessage", "predicate", "Lkotlin/Function1;", "ensure", "message", "delay", "poll", "callback", "Lkotlin/Function0;", "maxMessages", "Lcom/netflix/spinnaker/q/QueueCallback;", "push", "readState", "Lcom/netflix/spinnaker/q/metrics/QueueState;", "reschedule", "retry", "toString", "queueMessage", "queueMessage$keiko_redis", "readMessage", "json", "block", "readMessage$keiko_redis", "readMessageWithLock", "Lkotlin/Triple;", "Ljava/time/Instant;", "Lredis/clients/jedis/commands/ScriptingCommands;", "readMessageWithLock$keiko_redis", "readMessageWithoutLock", "readMessageWithoutLock$keiko_redis", "removeMessage", "removeMessage$keiko_redis", "requeueMessage", "requeueMessage$keiko_redis", "keiko-redis"})
public final class RedisQueue
extends AbstractRedisQueue {
    @NotNull
    private final String queueName;
    @NotNull
    private final Pool<Jedis> pool;
    @NotNull
    private final Clock clock;
    private final int lockTtlSeconds;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Optional<SerializationMigrator> serializationMigrator;
    @NotNull
    private final TemporalAmount ackTimeout;
    @NotNull
    private final List<Function2<Queue, Message, Unit>> deadMessageHandlers;
    private final boolean canPollMany;
    @NotNull
    private final EventPublisher publisher;
    @NotNull
    private final Logger log;
    @NotNull
    private final String queueKey;
    @NotNull
    private final String unackedKey;
    @NotNull
    private final String messagesKey;
    @NotNull
    private final String locksKey;
    @NotNull
    private final String attemptsKey;
    public String readMessageWithLockScriptSha;

    public RedisQueue(@NotNull String queueName, @NotNull Pool<Jedis> pool, @NotNull Clock clock, int lockTtlSeconds, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull TemporalAmount ackTimeout, @NotNull List<? extends Function2<? super Queue, ? super Message, Unit>> deadMessageHandlers, boolean canPollMany, @NotNull EventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)ackTimeout, (String)"ackTimeout");
        Intrinsics.checkNotNullParameter(deadMessageHandlers, (String)"deadMessageHandlers");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        super(clock, lockTtlSeconds, mapper, serializationMigrator, ackTimeout, deadMessageHandlers, canPollMany, publisher);
        this.queueName = queueName;
        this.pool = pool;
        this.clock = clock;
        this.lockTtlSeconds = lockTtlSeconds;
        this.mapper = mapper;
        this.serializationMigrator = serializationMigrator;
        this.ackTimeout = ackTimeout;
        this.deadMessageHandlers = deadMessageHandlers;
        this.canPollMany = canPollMany;
        this.publisher = publisher;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
        this.queueKey = this.queueName + ".queue";
        this.unackedKey = this.queueName + ".unacked";
        this.messagesKey = this.queueName + ".messages";
        this.locksKey = this.queueName + ".locks";
        this.attemptsKey = this.queueName + ".attempts";
        this.cacheScript();
        this.log.info("Configured " + this.getClass() + " queue: " + this.queueName);
    }

    public /* synthetic */ RedisQueue(String string, Pool pool, Clock clock, int n, ObjectMapper objectMapper, Optional optional, TemporalAmount temporalAmount, List list, boolean bl, EventPublisher eventPublisher, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        if ((n2 & 0x40) != 0) {
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
            temporalAmount = duration;
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(string, (Pool<Jedis>)pool, clock, n, objectMapper, optional, temporalAmount, list, bl, eventPublisher);
    }

    @Override
    @NotNull
    public TemporalAmount getAckTimeout() {
        return this.ackTimeout;
    }

    @Override
    @NotNull
    public List<Function2<Queue, Message, Unit>> getDeadMessageHandlers() {
        return this.deadMessageHandlers;
    }

    @Override
    public boolean getCanPollMany() {
        return this.canPollMany;
    }

    @Override
    @NotNull
    public EventPublisher getPublisher() {
        return this.publisher;
    }

    @Override
    @NotNull
    public final Logger getLog$keiko_redis() {
        return this.log;
    }

    @Override
    @NotNull
    public String getQueueKey$keiko_redis() {
        return this.queueKey;
    }

    @Override
    @NotNull
    public String getUnackedKey$keiko_redis() {
        return this.unackedKey;
    }

    @Override
    @NotNull
    public String getMessagesKey$keiko_redis() {
        return this.messagesKey;
    }

    @Override
    @NotNull
    public String getLocksKey$keiko_redis() {
        return this.locksKey;
    }

    @Override
    @NotNull
    public String getAttemptsKey$keiko_redis() {
        return this.attemptsKey;
    }

    @Override
    @NotNull
    public String getReadMessageWithLockScriptSha() {
        String string = this.readMessageWithLockScriptSha;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"readMessageWithLockScriptSha");
        return null;
    }

    @Override
    public void setReadMessageWithLockScriptSha(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.readMessageWithLockScriptSha = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cacheScript() {
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            String string = redis.scriptLoad("\n  local queueKey = KEYS[1]\n  local unackKey = KEYS[2]\n  local lockKey = KEYS[3]\n  local messagesKey = KEYS[4]\n  local maxScore = ARGV[1]\n  local peekFingerprintCount = ARGV[2]\n  local lockTtlSeconds = ARGV[3]\n  local unackDefaultScore = ARGV[4]\n  local unackBaseScore = ARGV[5]\n\n  local not_empty = function(x)\n    return (type(x) == \"table\") and (not x.err) and (#x ~= 0)\n  end\n\n  local acquire_lock = function(fingerprints, locksKey, lockTtlSeconds)\n    if not_empty(fingerprints) then\n      local i=1\n      while (i <= #fingerprints) do\n        redis.call(\"ECHO\", \"attempting lock on \" .. fingerprints[i])\n        if redis.call(\"SET\", locksKey .. \":\" .. fingerprints[i], \"\\uD83D\\uDD12\", \"EX\", lockTtlSeconds, \"NX\") then\n          redis.call(\"ECHO\", \"acquired lock on \" .. fingerprints[i])\n          return fingerprints[i], fingerprints[i+1]\n        end\n        i=i+2\n      end\n    end\n    return nil, nil\n  end\n\n  -- acquire a lock on a fingerprint\n  local fingerprints = redis.call(\"ZRANGEBYSCORE\", queueKey, 0.0, maxScore, \"WITHSCORES\", \"LIMIT\", 0, peekFingerprintCount)\n  local fingerprint, fingerprintScore = acquire_lock(fingerprints, lockKey, lockTtlSeconds)\n\n  -- no lock could be acquired\n  if fingerprint == nil then\n    if #fingerprints == 0 then\n      return \"NoReadyMessages\"\n    end\n    return \"AcquireLockFailed\"\n  end\n\n  \n  local java_scientific = function(x)\n    return string.format(\"%.12E\", x):gsub(\"\\+\", \"\")\n  end\n\n  -- get the message, move the fingerprint to the unacked queue and return\n  local message = redis.call(\"HGET\", messagesKey, fingerprint)\n\n  -- check for an ack timeout override on the message\n  local unackScore = unackDefaultScore\n  if type(message) == \"string\" and message ~= nil then\n    local ackTimeoutOverride = tonumber(cjson.decode(message)[\"ackTimeoutMs\"])\n    if ackTimeoutOverride ~= nil and unackBaseScore ~= nil then\n      unackScore = unackBaseScore + ackTimeoutOverride\n    end\n  end\n\n  unackScore = java_scientific(unackScore)\n\n  redis.call(\"ZREM\", queueKey, fingerprint)\n  redis.call(\"ZADD\", unackKey, unackScore, fingerprint)\n\n\n  return {fingerprint, fingerprintScore, message}\n");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"redis.scriptLoad(READ_MESSAGE_WITH_LOCK_SRC)");
            this.setReadMessageWithLockScriptSha(string);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(@NotNull Function2<? super Message, ? super Function0<Unit>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
            Triple<String, Instant, String> triple = this.readMessageWithLock$keiko_redis((ScriptingCommands)redis);
            if (triple != null) {
                Triple<String, Instant, String> triple2;
                Triple<String, Instant, String> triple3 = triple2 = triple;
                boolean bl2 = false;
                String fingerprint = (String)triple3.component1();
                Instant scheduledTime = (Instant)triple3.component2();
                String json = (String)triple3.component3();
                Function0 ack2 = Partials.partially1((Function1)((Function1)new Function1<String, Unit>((Object)this){

                    public final void invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        RedisQueue.access$ackMessage((RedisQueue)this.receiver, p0);
                    }
                }), (Object)fingerprint);
                this.readMessage$keiko_redis(redis, fingerprint, json, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(this, fingerprint, redis, scheduledTime, callback, (Function0<Unit>)ack2){
                    final /* synthetic */ RedisQueue this$0;
                    final /* synthetic */ String $fingerprint;
                    final /* synthetic */ Jedis $redis;
                    final /* synthetic */ Instant $scheduledTime;
                    final /* synthetic */ Function2<Message, Function0<Unit>, Unit> $callback;
                    final /* synthetic */ Function0<Unit> $ack;
                    {
                        this.this$0 = $receiver;
                        this.$fingerprint = $fingerprint;
                        this.$redis = $redis;
                        this.$scheduledTime = $scheduledTime;
                        this.$callback = $callback;
                        this.$ack = $ack;
                        super(1);
                    }

                    public final void invoke(@NotNull Message message) {
                        int maxAttempts;
                        Object v2;
                        int attempts;
                        block5: {
                            Object v0;
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                Message this_$iv = message;
                                boolean $i$f$getAttribute = false;
                                for (Object object : (Iterable)this_$iv.getAttributes()) {
                                    Attribute it$iv = (Attribute)object;
                                    boolean bl = false;
                                    if (!(it$iv instanceof AttemptsAttribute)) continue;
                                    v0 = object;
                                    break block4;
                                }
                                v0 = null;
                            }
                            AttemptsAttribute attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0));
                            attempts = attemptsAttribute != null ? attemptsAttribute.getAttempts() : 0;
                            Message this_$iv = message;
                            boolean $i$f$getAttribute = false;
                            for (E e : (Iterable)this_$iv.getAttributes()) {
                                Attribute it$iv = (Attribute)e;
                                boolean bl = false;
                                if (!(it$iv instanceof MaxAttemptsAttribute)) continue;
                                v2 = e;
                                break block5;
                            }
                            v2 = null;
                        }
                        MaxAttemptsAttribute maxAttemptsAttribute = (MaxAttemptsAttribute)((Attribute)((MaxAttemptsAttribute)v2));
                        int n = maxAttempts = maxAttemptsAttribute != null ? maxAttemptsAttribute.getMaxAttempts() : 0;
                        if (maxAttempts > 0 && attempts > maxAttempts) {
                            this.this$0.getLog$keiko_redis().warn("Message " + this.$fingerprint + " with payload " + message + " exceeded " + maxAttempts + " retries");
                            this.this$0.handleDeadMessage$keiko_redis(message);
                            Jedis jedis = this.$redis;
                            Intrinsics.checkNotNullExpressionValue((Object)jedis, (String)"redis");
                            this.this$0.removeMessage$keiko_redis(jedis, this.$fingerprint);
                            this.this$0.fire((QueueEvent)MessageDead.INSTANCE);
                        } else {
                            Instant instant = RedisQueue.access$getClock$p(this.this$0).instant();
                            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
                            this.this$0.fire((QueueEvent)new MessageProcessing(message, this.$scheduledTime, instant));
                            this.$callback.invoke((Object)message, this.$ack);
                        }
                    }
                }));
            }
            this.fire((QueueEvent)QueuePolled.INSTANCE);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void poll(int maxMessages, @NotNull Function2<? super Message, ? super Function0<Unit>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.poll(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            String string;
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
            String fingerprint = string = this.firstFingerprint$keiko_redis((JedisCommands)redis, this.getQueueKey$keiko_redis(), this.fingerprint$keiko_redis(message));
            boolean bl2 = false;
            if (fingerprint != null) {
                this.log.info("Re-prioritizing message as an identical one is already on the queue: " + fingerprint + ", message: " + message);
                redis.zadd(this.getQueueKey$keiko_redis(), this.score$keiko_redis(delay), fingerprint, ZAddParams.zAddParams().xx());
                this.fire((QueueEvent)new MessageDuplicate(message));
            } else {
                this.queueMessage$keiko_redis(redis, message, delay);
                this.fire((QueueEvent)new MessagePushed(message));
            }
            String string2 = string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            String fingerprint = this.fingerprint$keiko_redis(message).getLatest();
            this.log.debug("Re-scheduling message: " + message + ", fingerprint: " + fingerprint + " to deliver in " + delay);
            Long l = redis.zadd(this.getQueueKey$keiko_redis(), this.score$keiko_redis(delay), fingerprint, ZAddParams.zAddParams().xx());
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"redis.zadd(queueKey, sco\u2026print, zAddParams().xx())");
            long status = ((Number)l).longValue();
            if ((int)status == 1) {
                this.log.debug("Rescheduled message: " + message + ", fingerprint: " + fingerprint + " to deliver in " + delay);
                this.fire((QueueEvent)new MessageRescheduled(message));
            } else {
                this.log.warn("Failed to reschedule message: " + message + ", fingerprint: " + fingerprint + ", not found on queue");
                this.fire((QueueEvent)new MessageNotFound(message));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensure(@NotNull Message message, @NotNull TemporalAmount delay) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            AbstractRedisQueue.Fingerprint fingerprint = this.fingerprint$keiko_redis(message);
            Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
            if (!this.anyZismember$keiko_redis((JedisCommands)redis, this.getQueueKey$keiko_redis(), fingerprint.getAll()) && !this.anyZismember$keiko_redis((JedisCommands)redis, this.getUnackedKey$keiko_redis(), fingerprint.getAll())) {
                this.log.debug("Pushing ensured message onto queue as it does not exist in queue or unacked sets");
                this.push(message, delay);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Scheduled(fixedDelayString="${queue.retry.frequency.ms:10000}")
    public void retry() {
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Unit unit;
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Set fingerprints = redis.zrangeByScore(this.getUnackedKey$keiko_redis(), 0.0, AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null));
            boolean bl2 = false;
            if (fingerprints.size() > 0) {
                Object item$iv$iv2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)fingerprints, (String)"fingerprints");
                Iterable iterable = fingerprints;
                boolean $i$f$map = false;
                void var9_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.getLocksKey$keiko_redis() + ":" + (String)it);
                }
                List it = (List)destination$iv$iv;
                boolean bl4 = false;
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                item$iv$iv2 = stringArray;
                redis.del((String[])Arrays.copyOf(item$iv$iv2, ((T)item$iv$iv2).length));
            }
            Intrinsics.checkNotNullExpressionValue((Object)fingerprints, (String)"fingerprints");
            Iterable $this$forEach$iv = fingerprints;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fingerprint = (String)element$iv;
                boolean bl5 = false;
                AbstractRedisQueue abstractRedisQueue = this;
                Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
                JedisCommands jedisCommands = (JedisCommands)redis;
                String string = this.getAttemptsKey$keiko_redis();
                Intrinsics.checkNotNullExpressionValue((Object)fingerprint, (String)"fingerprint");
                int attempts = AbstractRedisQueue.hgetInt$keiko_redis$default(abstractRedisQueue, jedisCommands, string, fingerprint, 0, 4, null);
                this.readMessageWithoutLock$keiko_redis(redis, fingerprint, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(attempts, this, fingerprint, redis){
                    final /* synthetic */ int $attempts;
                    final /* synthetic */ RedisQueue this$0;
                    final /* synthetic */ String $fingerprint;
                    final /* synthetic */ Jedis $redis;
                    {
                        this.$attempts = $attempts;
                        this.this$0 = $receiver;
                        this.$fingerprint = $fingerprint;
                        this.$redis = $redis;
                        super(1);
                    }

                    public final void invoke(@NotNull Message message) {
                        int maxAttempts;
                        Object v0;
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            Message this_$iv = message;
                            boolean $i$f$getAttribute = false;
                            for (T t : (Iterable)this_$iv.getAttributes()) {
                                Attribute it$iv = (Attribute)t;
                                boolean bl = false;
                                if (!(it$iv instanceof MaxAttemptsAttribute)) continue;
                                v0 = t;
                                break block5;
                            }
                            v0 = null;
                        }
                        MaxAttemptsAttribute maxAttemptsAttribute = (MaxAttemptsAttribute)((Attribute)((MaxAttemptsAttribute)v0));
                        int n = maxAttempts = maxAttemptsAttribute != null ? maxAttemptsAttribute.getMaxAttempts() : 0;
                        if (maxAttempts == 0 && this.$attempts >= Queue.Companion.getMaxRetries() - 1) {
                            this.this$0.getLog$keiko_redis().warn("Message " + this.$fingerprint + " with payload " + message + " exceeded max retries");
                            this.this$0.handleDeadMessage$keiko_redis(message);
                            Jedis jedis = this.$redis;
                            Intrinsics.checkNotNullExpressionValue((Object)jedis, (String)"redis");
                            String string = this.$fingerprint;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fingerprint");
                            this.this$0.removeMessage$keiko_redis(jedis, string);
                            this.this$0.fire((QueueEvent)MessageDead.INSTANCE);
                        } else {
                            Jedis jedis = this.$redis;
                            Intrinsics.checkNotNullExpressionValue((Object)jedis, (String)"redis");
                            JedisCommands jedisCommands = (JedisCommands)jedis;
                            String string = this.this$0.getQueueKey$keiko_redis();
                            String string2 = this.$fingerprint;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fingerprint");
                            if (this.this$0.zismember$keiko_redis(jedisCommands, string, string2)) {
                                Jedis jedis2 = this.$redis;
                                Intrinsics.checkNotNullExpressionValue((Object)jedis2, (String)"redis");
                                this.this$0.multi$keiko_redis(jedis2, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this.this$0, this.$fingerprint){
                                    final /* synthetic */ RedisQueue this$0;
                                    final /* synthetic */ String $fingerprint;
                                    {
                                        this.this$0 = $receiver;
                                        this.$fingerprint = $fingerprint;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Transaction $this$multi) {
                                        Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                                        String[] stringArray = new String[]{this.$fingerprint};
                                        $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                                        $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null), this.$fingerprint);
                                        $this$multi.hincrBy(this.this$0.getAttemptsKey$keiko_redis(), this.$fingerprint, 1L);
                                    }
                                }));
                                this.this$0.getLog$keiko_redis().info("Not retrying message " + this.$fingerprint + " because an identical message is already on the queue");
                                this.this$0.fire((QueueEvent)new MessageDuplicate(message));
                            } else {
                                this.this$0.getLog$keiko_redis().warn("Retrying message " + this.$fingerprint + " after " + this.$attempts + " attempts");
                                this.$redis.hincrBy(this.this$0.getAttemptsKey$keiko_redis(), this.$fingerprint, 1L);
                                Jedis jedis3 = this.$redis;
                                Intrinsics.checkNotNullExpressionValue((Object)jedis3, (String)"redis");
                                String string3 = this.$fingerprint;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fingerprint");
                                this.this$0.requeueMessage$keiko_redis(jedis3, string3);
                                this.this$0.fire((QueueEvent)MessageRetried.INSTANCE);
                            }
                        }
                    }
                }));
            }
            Unit it = unit = Unit.INSTANCE;
            boolean bl6 = false;
            this.fire((QueueEvent)RetryPolled.INSTANCE);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Long l = redis.del(this.getMessagesKey$keiko_redis());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public QueueState readState() {
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
            List<Object> list = this.multi$keiko_redis(redis, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this){
                final /* synthetic */ RedisQueue this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Transaction $this$multi) {
                    Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                    $this$multi.zcard(this.this$0.getQueueKey$keiko_redis());
                    $this$multi.zcount(this.this$0.getQueueKey$keiko_redis(), 0.0, AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null));
                    $this$multi.zcard(this.this$0.getUnackedKey$keiko_redis());
                    $this$multi.hlen(this.this$0.getMessagesKey$keiko_redis());
                }
            }));
            Intrinsics.checkNotNullExpressionValue(list, (String)"override fun readState()\u2026        )\n        }\n    }");
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                collection.add((int)((Long)v1).longValue());
            }
            List list2 = (List)destination$iv$iv;
            boolean bl3 = false;
            int queued = ((Number)list2.get(0)).intValue();
            int ready = ((Number)list2.get(1)).intValue();
            int processing = ((Number)list2.get(2)).intValue();
            int messages = ((Number)list2.get(3)).intValue();
            QueueState queueState = new QueueState(queued, ready, processing, messages - (queued + processing), 0, 16, null);
            return queueState;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean containsMessage(@NotNull Function1<? super Message, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Ref.BooleanRef found = new Ref.BooleanRef();
            String cursor = null;
            cursor = "0";
            while (!found.element) {
                boolean bl2;
                boolean bl3;
                ScanResult $this$containsMessage_u24lambda_u2d19_u24lambda_u2d18;
                block10: {
                    void $this$any$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    ScanResult scanResult;
                    $this$containsMessage_u24lambda_u2d19_u24lambda_u2d18 = scanResult = redis.hscan(this.getMessagesKey$keiko_redis(), cursor);
                    boolean bl4 = false;
                    List list = $this$containsMessage_u24lambda_u2d19_u24lambda_u2d18.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result");
                    Iterable iterable = list;
                    Ref.BooleanRef booleanRef = found;
                    boolean $i$f$map = false;
                    Iterator iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void $this$readValue$iv;
                        void it;
                        Map.Entry entry = (Map.Entry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        AbstractRedisQueue abstractRedisQueue = this;
                        ObjectMapper objectMapper = this.mapper;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                        String content$iv = (String)v;
                        boolean $i$f$readValue$keiko_redis = false;
                        collection.add((Message)$this$readValue$iv.readValue(content$iv, Message.class));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                booleanRef.element = bl2 = bl3;
                Intrinsics.checkNotNullExpressionValue((Object)$this$containsMessage_u24lambda_u2d19_u24lambda_u2d18.getCursor(), (String)"getCursor()");
                if (!Intrinsics.areEqual((Object)cursor, (Object)"0")) continue;
            }
            boolean bl6 = found.element;
            return bl6;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "RedisQueue[" + this.queueName + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ackMessage(String fingerprint) {
        Closeable closeable = (Closeable)this.pool.getResource();
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"redis");
            if (this.zismember$keiko_redis((JedisCommands)redis, this.getQueueKey$keiko_redis(), fingerprint)) {
                this.multi$keiko_redis(redis, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
                    final /* synthetic */ RedisQueue this$0;
                    final /* synthetic */ String $fingerprint;
                    {
                        this.this$0 = $receiver;
                        this.$fingerprint = $fingerprint;
                        super(1);
                    }

                    public final void invoke(@NotNull Transaction $this$multi) {
                        Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                        String[] stringArray = new String[]{this.$fingerprint};
                        $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                        $this$multi.del(this.this$0.getLocksKey$keiko_redis() + ":" + this.$fingerprint);
                    }
                }));
            } else {
                this.removeMessage$keiko_redis(redis, fingerprint);
            }
            this.fire((QueueEvent)MessageAcknowledged.INSTANCE);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void queueMessage$keiko_redis(@NotNull Jedis $this$queueMessage, @NotNull Message message, @NotNull TemporalAmount delay) {
        void attribute$iv;
        void this_$iv;
        AttemptsAttribute attemptsAttribute;
        Object v0;
        String fingerprint;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$queueMessage, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
            fingerprint = this.fingerprint$keiko_redis(message).getLatest();
            Message message2 = message;
            Message this_$iv2 = message;
            boolean $i$f$getAttribute = false;
            for (Object t : (Iterable)this_$iv2.getAttributes()) {
                Attribute it$iv = (Attribute)t;
                boolean bl = false;
                if (!(it$iv instanceof AttemptsAttribute)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0))) == null) {
            attemptsAttribute = new AttemptsAttribute(0, 1, null);
        }
        Attribute attribute = (Attribute)attemptsAttribute;
        boolean $i$f$setAttribute = false;
        this_$iv.getAttributes().removeIf(queueMessage$$inlined$setAttribute$1.INSTANCE);
        this_$iv.getAttributes().add(attribute$iv);
        this.multi$keiko_redis($this$queueMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint, message, delay){
            final /* synthetic */ RedisQueue this$0;
            final /* synthetic */ String $fingerprint;
            final /* synthetic */ Message $message;
            final /* synthetic */ TemporalAmount $delay;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                this.$message = $message;
                this.$delay = $delay;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                $this$multi.hset(this.this$0.getMessagesKey$keiko_redis(), this.$fingerprint, RedisQueue.access$getMapper$p(this.this$0).writeValueAsString((Object)this.$message));
                $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), this.this$0.score$keiko_redis(this.$delay), this.$fingerprint);
            }
        }));
    }

    public static /* synthetic */ void queueMessage$keiko_redis$default(RedisQueue redisQueue, Jedis jedis, Message message, TemporalAmount temporalAmount, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            temporalAmount = duration;
        }
        redisQueue.queueMessage$keiko_redis(jedis, message, temporalAmount);
    }

    public final void requeueMessage$keiko_redis(@NotNull Jedis $this$requeueMessage, @NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$requeueMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.multi$keiko_redis($this$requeueMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
            final /* synthetic */ RedisQueue this$0;
            final /* synthetic */ String $fingerprint;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                String[] stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                $this$multi.zadd(this.this$0.getQueueKey$keiko_redis(), AbstractRedisQueue.score$keiko_redis$default(this.this$0, null, 1, null), this.$fingerprint);
            }
        }));
    }

    public final void removeMessage$keiko_redis(@NotNull Jedis $this$removeMessage, @NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$removeMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.multi$keiko_redis($this$removeMessage, (Function1<? super Transaction, Unit>)((Function1)new Function1<Transaction, Unit>(this, fingerprint){
            final /* synthetic */ RedisQueue this$0;
            final /* synthetic */ String $fingerprint;
            {
                this.this$0 = $receiver;
                this.$fingerprint = $fingerprint;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$multi) {
                Intrinsics.checkNotNullParameter((Object)$this$multi, (String)"$this$multi");
                String[] stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getQueueKey$keiko_redis(), stringArray);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.zrem(this.this$0.getUnackedKey$keiko_redis(), stringArray);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.hdel(this.this$0.getMessagesKey$keiko_redis(), stringArray);
                $this$multi.del(this.this$0.getLocksKey$keiko_redis() + ":" + this.$fingerprint);
                stringArray = new String[]{this.$fingerprint};
                $this$multi.hdel(this.this$0.getAttemptsKey$keiko_redis(), stringArray);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void readMessageWithoutLock$keiko_redis(@NotNull Jedis $this$readMessageWithoutLock, @NotNull String fingerprint, @NotNull Function1<? super Message, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessageWithoutLock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            void $this$readValue$iv;
            String it = $this$readMessageWithoutLock.hget(this.getMessagesKey$keiko_redis(), fingerprint);
            boolean bl = false;
            AbstractRedisQueue abstractRedisQueue = this;
            ObjectMapper objectMapper = this.mapper;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String content$iv = this.runSerializationMigration$keiko_redis(it);
            boolean $i$f$readValue$keiko_redis = false;
            Message message = (Message)$this$readValue$iv.readValue(content$iv, Message.class);
            block.invoke((Object)message);
        }
        catch (IOException e) {
            this.log.error("Failed to read unacked message " + fingerprint + ", requeuing...", (Throwable)e);
            $this$readMessageWithoutLock.hincrBy(this.getAttemptsKey$keiko_redis(), fingerprint, 1L);
            this.requeueMessage$keiko_redis($this$readMessageWithoutLock, fingerprint);
        }
        catch (JsonParseException e) {
            this.log.error("Payload for unacked message " + fingerprint + " is missing or corrupt", (Throwable)e);
            this.removeMessage$keiko_redis($this$readMessageWithoutLock, fingerprint);
        }
    }

    @Nullable
    public final Triple<String, Instant, String> readMessageWithLock$keiko_redis(@NotNull ScriptingCommands $this$readMessageWithLock) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessageWithLock, (String)"<this>");
        try {
            Object[] objectArray = new String[]{this.getQueueKey$keiko_redis(), this.getUnackedKey$keiko_redis(), this.getLocksKey$keiko_redis(), this.getMessagesKey$keiko_redis()};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new String[5];
            objectArray[0] = String.valueOf(AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null));
            objectArray[1] = "10";
            objectArray[2] = String.valueOf(this.lockTtlSeconds);
            Object[] objectArray2 = new Object[]{this.score$keiko_redis(this.getAckTimeout())};
            objectArray[3] = String.format(Locale.US, "%f", objectArray2);
            objectArray2 = new Object[]{AbstractRedisQueue.score$keiko_redis$default(this, null, 1, null)};
            objectArray[4] = String.format(Locale.US, "%f", objectArray2);
            Object response = $this$readMessageWithLock.evalsha(this.getReadMessageWithLockScriptSha(), list, CollectionsKt.listOf((Object[])objectArray));
            if (response instanceof List) {
                Object e = ((List)response).get(2);
                return new Triple((Object)String.valueOf(((List)response).get(0)), (Object)Instant.ofEpochMilli(Long.parseLong(String.valueOf(((List)response).get(1)))), (Object)(e != null ? e.toString() : null));
            }
            if (Intrinsics.areEqual((Object)response, (Object)"ReadLockFailed")) {
                this.fire((QueueEvent)LockFailed.INSTANCE);
            }
        }
        catch (JedisDataException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            if (StringsKt.startsWith$default((String)string, (String)"NOSCRIPT", (boolean)false, (int)2, null)) {
                this.cacheScript();
                return this.readMessageWithLock$keiko_redis($this$readMessageWithLock);
            }
            throw e;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void readMessage$keiko_redis(@NotNull Jedis $this$readMessage, @NotNull String fingerprint, @Nullable String json, @NotNull Function1<? super Message, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$readMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (json == null) {
            this.log.error("Payload for message " + fingerprint + " is missing");
            this.removeMessage$keiko_redis($this$readMessage, fingerprint);
        } else {
            try {
                AttemptsAttribute attemptsAttribute;
                Object v0;
                Message $this$readMessage_u24lambda_u2d23;
                Object object;
                block6: {
                    void $this$readValue$iv;
                    object = this;
                    ObjectMapper objectMapper = this.mapper;
                    String content$iv = this.runSerializationMigration$keiko_redis(json);
                    boolean $i$f$readValue$keiko_redis = false;
                    object = $this$readValue$iv.readValue(content$iv, Message.class);
                    $this$readMessage_u24lambda_u2d23 = (Message)object;
                    boolean bl = false;
                    Message this_$iv = $this$readMessage_u24lambda_u2d23;
                    boolean $i$f$getAttribute = false;
                    for (Object t : (Iterable)this_$iv.getAttributes()) {
                        Attribute it$iv = (Attribute)t;
                        boolean bl2 = false;
                        if (!(it$iv instanceof AttemptsAttribute)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                if ((attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v0))) == null) {
                    attemptsAttribute = new AttemptsAttribute(0, 1, null);
                }
                AttemptsAttribute $this$readMessage_u24lambda_u2d23_u24lambda_u2d22 = attemptsAttribute;
                boolean bl = false;
                AttemptsAttribute currentAttempts = $this$readMessage_u24lambda_u2d23_u24lambda_u2d22.copy($this$readMessage_u24lambda_u2d23_u24lambda_u2d22.getAttempts() + 1);
                Message this_$iv = $this$readMessage_u24lambda_u2d23;
                boolean $i$f$setAttribute = false;
                this_$iv.getAttributes().removeIf(readMessage$lambda-23$$inlined$setAttribute$1.INSTANCE);
                this_$iv.getAttributes().add((Attribute)currentAttempts);
                Attribute cfr_ignored_0 = (Attribute)currentAttempts;
                Message message = (Message)object;
                $this$readMessage.hset(this.getMessagesKey$keiko_redis(), fingerprint, this.mapper.writeValueAsString((Object)message));
                block.invoke((Object)message);
            }
            catch (IOException e) {
                this.log.error("Failed to read message " + fingerprint + ", requeuing...", (Throwable)e);
                $this$readMessage.hincrBy(this.getAttemptsKey$keiko_redis(), fingerprint, 1L);
                this.requeueMessage$keiko_redis($this$readMessage, fingerprint);
            }
        }
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(RedisQueue $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ void access$ackMessage(RedisQueue $this, String fingerprint) {
        $this.ackMessage(fingerprint);
    }

    public static final /* synthetic */ Clock access$getClock$p(RedisQueue $this) {
        return $this.clock;
    }
}

