/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.ObjectMapperSubtypeProperties;
import com.netflix.spinnaker.config.QueueProperties;
import com.netflix.spinnaker.q.Activator;
import com.netflix.spinnaker.q.EnabledActivator;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.MessageHandler;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.QueueExecutor;
import com.netflix.spinnaker.q.QueueProcessor;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.metrics.MonitorableQueue;
import com.netflix.spinnaker.q.metrics.NoopEventPublisher;
import com.netflix.spinnaker.q.metrics.QueueMetricsPublisher;
import com.netflix.spinnaker.q.metrics.QueueMonitor;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={QueueProperties.class, ObjectMapperSubtypeProperties.class})
@ComponentScan(basePackages={"com.netflix.spinnaker.q"})
@EnableScheduling
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0017Jj\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u001c\u0010!\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"j\u0002`%H\u0017J\b\u0010&\u001a\u00020\u0011H\u0017\u00a8\u0006'"}, d2={"Lcom/netflix/spinnaker/config/QueueConfiguration;", "", "()V", "enabledActivator", "Lcom/netflix/spinnaker/q/EnabledActivator;", "queueProperties", "Lcom/netflix/spinnaker/config/QueueProperties;", "messageHandlerPool", "Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "queueEventPublisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "queueExecutor", "Lcom/netflix/spinnaker/q/QueueExecutor;", "queueMetricsPublisher", "registry", "Lcom/netflix/spectator/api/Registry;", "clock", "Ljava/time/Clock;", "queueMonitor", "Lcom/netflix/spinnaker/q/metrics/QueueMonitor;", "queue", "Lcom/netflix/spinnaker/q/metrics/MonitorableQueue;", "queueProcessor", "Lcom/netflix/spinnaker/q/QueueProcessor;", "Lcom/netflix/spinnaker/q/Queue;", "executor", "handlers", "", "Lcom/netflix/spinnaker/q/MessageHandler;", "activators", "", "Lcom/netflix/spinnaker/q/Activator;", "publisher", "deadMessageHandler", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "systemClock", "keiko-spring"})
public class QueueConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Clock.class})
    @NotNull
    public Clock systemClock() {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone()");
        return clock;
    }

    @Bean
    @NotNull
    public ThreadPoolTaskExecutor messageHandlerPool(@NotNull QueueProperties queueProperties) {
        Intrinsics.checkNotNullParameter((Object)queueProperties, (String)"queueProperties");
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        boolean bl = false;
        boolean bl2 = false;
        ThreadPoolTaskExecutor $this$messageHandlerPool_u24lambda_u2d0 = threadPoolTaskExecutor;
        boolean bl3 = false;
        $this$messageHandlerPool_u24lambda_u2d0.setThreadNamePrefix(queueProperties.getHandlerThreadNamePrefix());
        $this$messageHandlerPool_u24lambda_u2d0.setCorePoolSize(queueProperties.getHandlerCorePoolSize());
        $this$messageHandlerPool_u24lambda_u2d0.setMaxPoolSize(queueProperties.getHandlerMaxPoolSize());
        $this$messageHandlerPool_u24lambda_u2d0.setQueueCapacity(0);
        return threadPoolTaskExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(value={QueueExecutor.class})
    @NotNull
    public QueueExecutor<ThreadPoolTaskExecutor> queueExecutor(@NotNull ThreadPoolTaskExecutor messageHandlerPool) {
        Intrinsics.checkNotNullParameter((Object)messageHandlerPool, (String)"messageHandlerPool");
        return (QueueExecutor)new QueueExecutor<ThreadPoolTaskExecutor>(messageHandlerPool){
            final /* synthetic */ ThreadPoolTaskExecutor $messageHandlerPool;
            {
                this.$messageHandlerPool = $messageHandlerPool;
                super((Executor)$messageHandlerPool);
            }

            public boolean hasCapacity() {
                ThreadPoolExecutor threadPoolExecutor = ((ThreadPoolTaskExecutor)this.getExecutor()).getThreadPoolExecutor();
                boolean bl = false;
                boolean bl2 = false;
                ThreadPoolExecutor $this$hasCapacity_u24lambda_u2d0 = threadPoolExecutor;
                boolean bl3 = false;
                return $this$hasCapacity_u24lambda_u2d0.getActiveCount() < $this$hasCapacity_u24lambda_u2d0.getMaximumPoolSize();
            }

            public int availableCapacity() {
                ThreadPoolExecutor threadPoolExecutor = ((ThreadPoolTaskExecutor)this.getExecutor()).getThreadPoolExecutor();
                boolean bl = false;
                boolean bl2 = false;
                ThreadPoolExecutor $this$availableCapacity_u24lambda_u2d1 = threadPoolExecutor;
                boolean bl3 = false;
                return $this$availableCapacity_u24lambda_u2d1.getMaximumPoolSize() - $this$availableCapacity_u24lambda_u2d1.getActiveCount();
            }
        };
    }

    @Bean
    @NotNull
    public QueueProcessor queueProcessor(@NotNull Queue queue, @NotNull QueueExecutor<?> executor, @NotNull Collection<? extends MessageHandler<?>> handlers, @NotNull List<? extends Activator> activators, @NotNull EventPublisher publisher, @NotNull QueueProperties queueProperties, @NotNull Function2<? super Queue, ? super Message, Unit> deadMessageHandler) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter(activators, (String)"activators");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)queueProperties, (String)"queueProperties");
        Intrinsics.checkNotNullParameter(deadMessageHandler, (String)"deadMessageHandler");
        boolean bl = queueProperties.getFillExecutorEachCycle();
        Duration duration = Duration.ofSeconds(queueProperties.getRequeueDelaySeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(queueProperties.requeueDelaySeconds)");
        Duration duration2 = duration;
        duration = Duration.ofSeconds(queueProperties.getRequeueMaxJitterSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(queueProperties.requeueMaxJitterSeconds)");
        return new QueueProcessor(queue, executor, handlers, activators, publisher, deadMessageHandler, bl, duration2, duration);
    }

    @Bean
    @NotNull
    public EnabledActivator enabledActivator(@NotNull QueueProperties queueProperties) {
        Intrinsics.checkNotNullParameter((Object)queueProperties, (String)"queueProperties");
        return new EnabledActivator(queueProperties.getEnabled());
    }

    @Bean
    @ConditionalOnProperty(value={"queue.metrics.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public QueueMonitor queueMonitor(@NotNull Registry registry, @NotNull Clock clock, @NotNull MonitorableQueue queue) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        return new QueueMonitor(registry, clock, queue);
    }

    @Bean
    @ConditionalOnProperty(value={"queue.metrics.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public EventPublisher queueMetricsPublisher(@NotNull Registry registry, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return (EventPublisher)new QueueMetricsPublisher(registry, clock);
    }

    @Bean
    @ConditionalOnMissingBean(value={EventPublisher.class})
    @NotNull
    public EventPublisher queueEventPublisher() {
        return (EventPublisher)new NoopEventPublisher();
    }
}

