/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.netflix.spinnaker.config.ObjectMapperSubtypeProperties;
import com.netflix.spinnaker.exception.InvalidSubtypeConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/config/SpringObjectMapperConfigurer;", "", "properties", "Lcom/netflix/spinnaker/config/ObjectMapperSubtypeProperties;", "(Lcom/netflix/spinnaker/config/ObjectMapperSubtypeProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "findSubtypes", "", "Lcom/fasterxml/jackson/databind/jsontype/NamedType;", "clazz", "Ljava/lang/Class;", "pkg", "", "(Ljava/lang/Class;Ljava/lang/String;)[Lcom/fasterxml/jackson/databind/jsontype/NamedType;", "getRootTypeClass", "name", "registerSubtypes", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rootType", "subtypePackages", "", "keiko-spring"})
public final class SpringObjectMapperConfigurer {
    @NotNull
    private final ObjectMapperSubtypeProperties properties;
    private final Logger log;

    public SpringObjectMapperConfigurer(@NotNull ObjectMapperSubtypeProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public final void registerSubtypes(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.registerSubtypes(mapper, this.properties.getMessageRootType(), this.properties.getMessagePackages());
        this.registerSubtypes(mapper, this.properties.getAttributeRootType(), this.properties.getAttributePackages());
        Iterable $this$forEach$iv = this.properties.getExtraSubtypes().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.registerSubtypes(mapper, (String)it.getKey(), (List)it.getValue());
        }
    }

    private final void registerSubtypes(ObjectMapper mapper, String rootType, List<String> subtypePackages) {
        Class<?> clazz = this.getRootTypeClass(rootType);
        boolean bl = false;
        boolean bl2 = false;
        Class<?> cls = clazz;
        boolean bl3 = false;
        Iterable $this$forEach$iv = subtypePackages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            NamedType[] namedTypeArray = this.findSubtypes(cls, it);
            mapper.registerSubtypes(Arrays.copyOf(namedTypeArray, namedTypeArray.length));
        }
    }

    private final Class<?> getRootTypeClass(String name) {
        Class clazz = ClassUtils.resolveClassName((String)name, (ClassLoader)ClassUtils.getDefaultClassLoader());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"resolveClassName(name, C\u2026.getDefaultClassLoader())");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final NamedType[] findSubtypes(Class<?> clazz, String pkg) {
        void $this$mapTo$iv$iv;
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        boolean bl = false;
        boolean bl2 = false;
        ClassPathScanningCandidateComponentProvider $this$findSubtypes_u24lambda_u2d3 = classPathScanningCandidateComponentProvider;
        boolean bl3 = false;
        $this$findSubtypes_u24lambda_u2d3.addIncludeFilter((TypeFilter)new AssignableTypeFilter(clazz));
        Set set = classPathScanningCandidateComponentProvider.findCandidateComponents(pkg);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ClassPathScanningCandida\u2026dCandidateComponents(pkg)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void it;
            BeanDefinition beanDefinition = (BeanDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            boolean bl5 = it.getBeanClassName() != null;
            boolean bl6 = false;
            boolean bl7 = false;
            bl7 = false;
            boolean bl8 = false;
            if (!bl5) {
                boolean bl9 = false;
                String string2 = "Check failed.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Class cls = ClassUtils.resolveClassName((String)it.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            Object[] objectArray = cls.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"cls.annotations");
            objectArray = objectArray;
            boolean $i$f$filterIsInstance = false;
            void var18_29 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JsonTypeName)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            JsonTypeName jsonTypeName = (JsonTypeName)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            String string3 = string = jsonTypeName == null ? null : jsonTypeName.value();
            if (string == null) {
                throw new InvalidSubtypeConfigurationException("Subtype " + cls.getSimpleName() + " does not have a JsonTypeName");
            }
            String serializationName = string;
            this.log.info("Registering subtype of " + clazz.getSimpleName() + ": " + serializationName);
            NamedType namedType = new NamedType(cls, serializationName);
            collection.add(namedType);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        NamedType[] namedTypeArray = thisCollection$iv.toArray(new NamedType[0]);
        if (namedTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return namedTypeArray;
    }
}

