/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.q.discovery;

import com.netflix.spinnaker.kork.discovery.DiscoveryStatusChangeEvent;
import com.netflix.spinnaker.kork.discovery.InstanceStatus;
import com.netflix.spinnaker.kork.discovery.RemoteStatusChangedEvent;
import com.netflix.spinnaker.q.Activator;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/q/discovery/DiscoveryActivator;", "Lcom/netflix/spinnaker/q/Activator;", "Lorg/springframework/context/ApplicationListener;", "Lcom/netflix/spinnaker/kork/discovery/RemoteStatusChangedEvent;", "()V", "_enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enabled", "", "getEnabled", "()Z", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onApplicationEvent", "", "event", "keiko-spring"})
public class DiscoveryActivator
implements Activator,
ApplicationListener<RemoteStatusChangedEvent> {
    @NotNull
    private final AtomicBoolean _enabled = new AtomicBoolean();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean getEnabled() {
        return this._enabled.get();
    }

    public void onApplicationEvent(@NotNull RemoteStatusChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DiscoveryStatusChangeEvent e = event.getSource();
        boolean bl = false;
        if (e.getStatus() == InstanceStatus.UP) {
            this.log.info("Instance is " + e.getStatus() + "... " + this.getClass().getSimpleName() + " starting");
            this._enabled.set(true);
        } else if (e.getPreviousStatus() == InstanceStatus.UP) {
            this.log.info("Instance is " + e.getStatus() + "... " + this.getClass().getSimpleName() + " stopping");
            this._enabled.set(false);
        }
    }

    public void ifEnabled(@NotNull Function0<Unit> block) {
        Activator.DefaultImpls.ifEnabled((Activator)this, block);
    }
}

