/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline.models;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface PipelineExecution {
    @Nonnull
    public ExecutionType getType();

    public String getId();

    public void setId(String var1);

    public String getApplication();

    public void setApplication(String var1);

    public String getName();

    public void setName(String var1);

    public Long getBuildTime();

    public void setBuildTime(Long var1);

    public boolean isCanceled();

    public void setCanceled(boolean var1);

    public String getCanceledBy();

    public void setCanceledBy(String var1);

    public String getCancellationReason();

    public void setCancellationReason(String var1);

    public boolean isLimitConcurrent();

    public void setLimitConcurrent(boolean var1);

    public boolean isKeepWaitingPipelines();

    public void setKeepWaitingPipelines(boolean var1);

    public Map<String, Object> getContext();

    public List<StageExecution> getStages();

    public Long getStartTime();

    public void setStartTime(Long var1);

    public Long getEndTime();

    public void setEndTime(Long var1);

    public Long getStartTimeExpiry();

    public void setStartTimeExpiry(Long var1);

    public ExecutionStatus getStatus();

    public void setStatus(ExecutionStatus var1);

    public AuthenticationDetails getAuthentication();

    public void setAuthentication(AuthenticationDetails var1);

    public PausedDetails getPaused();

    public void setPaused(PausedDetails var1);

    public String getOrigin();

    public void setOrigin(String var1);

    public Trigger getTrigger();

    public void setTrigger(Trigger var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getPipelineConfigId();

    public void setPipelineConfigId(String var1);

    public PipelineSource getSource();

    public void setSource(PipelineSource var1);

    public List<Map<String, Object>> getNotifications();

    public void setNotifications(List<Map<String, Object>> var1);

    public String getSpelEvaluator();

    public void setSpelEvaluator(String var1);

    public Map<String, Object> getTemplateVariables();

    public void setTemplateVariables(Map<String, Object> var1);

    public String getPartition();

    public void setPartition(String var1);

    public StageExecution namedStage(String var1);

    public StageExecution stageById(String var1);

    public StageExecution stageByRef(String var1);

    public void updateStatus(ExecutionStatus var1);

    public static class PipelineSource {
        private String id;
        private String type;
        private String version;

        @Nonnull
        public String getId() {
            return this.id;
        }

        public void setId(@Nonnull String id) {
            this.id = id;
        }

        @Nonnull
        public String getType() {
            return this.type;
        }

        public void setType(@Nonnull String type) {
            this.type = type;
        }

        @Nonnull
        public String getVersion() {
            return this.version;
        }

        public void setVersion(@Nonnull String version) {
            this.version = version;
        }
    }

    public static class PausedDetails {
        String pausedBy;
        String resumedBy;
        Long pauseTime;
        Long resumeTime;

        @Nullable
        public String getPausedBy() {
            return this.pausedBy;
        }

        public void setPausedBy(@Nullable String pausedBy) {
            this.pausedBy = pausedBy;
        }

        @Nullable
        public String getResumedBy() {
            return this.resumedBy;
        }

        public void setResumedBy(@Nullable String resumedBy) {
            this.resumedBy = resumedBy;
        }

        @Nullable
        public Long getPauseTime() {
            return this.pauseTime;
        }

        public void setPauseTime(@Nullable Long pauseTime) {
            this.pauseTime = pauseTime;
        }

        @Nullable
        public Long getResumeTime() {
            return this.resumeTime;
        }

        public void setResumeTime(@Nullable Long resumeTime) {
            this.resumeTime = resumeTime;
        }

        public boolean isPaused() {
            return this.pauseTime != null && this.resumeTime == null;
        }

        public long getPausedMs() {
            return this.pauseTime != null && this.resumeTime != null ? this.resumeTime - this.pauseTime : 0L;
        }
    }

    public static class AuthenticationDetails {
        private String user;
        private Collection<String> allowedAccounts = Collections.emptySet();

        @Nullable
        public String getUser() {
            return this.user;
        }

        public void setUser(@Nullable String user) {
            this.user = user;
        }

        public Collection<String> getAllowedAccounts() {
            return this.allowedAccounts;
        }

        public void setAllowedAccounts(Collection<String> allowedAccounts) {
            this.allowedAccounts = Set.copyOf(allowedAccounts);
        }

        public AuthenticationDetails() {
            this(null, Collections.emptySet());
        }

        public AuthenticationDetails(String user, String ... allowedAccounts) {
            this(user, Set.of(allowedAccounts));
        }

        public AuthenticationDetails(String user, Collection<String> allowedAccounts) {
            this.user = user;
            this.allowedAccounts = allowedAccounts == null ? Collections.emptySet() : Set.copyOf(allowedAccounts);
        }
    }
}

