/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.orca.api.annotations.Immutable;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

@Beta
public final class TaskResult {
    public static final TaskResult SUCCEEDED = TaskResult.ofStatus(ExecutionStatus.SUCCEEDED);
    public static final TaskResult RUNNING = TaskResult.ofStatus(ExecutionStatus.RUNNING);
    public static final TaskResult TERMINAL = TaskResult.ofStatus(ExecutionStatus.TERMINAL);
    @NonNull
    private final ExecutionStatus status;
    @Immutable
    private final Map<String, ?> context;
    @Immutable
    private final Map<String, ?> outputs;

    public static TaskResult ofStatus(ExecutionStatus status) {
        return TaskResult.builder(status).build();
    }

    public static TaskResultBuilder builder(ExecutionStatus status) {
        return new TaskResultBuilder().status(status);
    }

    TaskResult(@NonNull ExecutionStatus status, Map<String, ?> context, Map<String, ?> outputs) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
        this.context = context;
        this.outputs = outputs;
    }

    @NonNull
    public ExecutionStatus getStatus() {
        return this.status;
    }

    public Map<String, ?> getContext() {
        return this.context;
    }

    public Map<String, ?> getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskResult)) {
            return false;
        }
        TaskResult other = (TaskResult)o;
        ExecutionStatus this$status = this.getStatus();
        ExecutionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, ?> this$context = this.getContext();
        Map<String, ?> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        Map<String, ?> this$outputs = this.getOutputs();
        Map<String, ?> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, ?> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        Map<String, ?> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    public String toString() {
        return "TaskResult(status=" + this.getStatus() + ", context=" + this.getContext() + ", outputs=" + this.getOutputs() + ")";
    }

    public static class TaskResultBuilder {
        private ExecutionStatus status;
        private ArrayList<String> context$key;
        private ArrayList<Object> context$value;
        private ArrayList<String> outputs$key;
        private ArrayList<Object> outputs$value;

        TaskResultBuilder() {
        }

        public TaskResultBuilder status(@NonNull ExecutionStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
            return this;
        }

        public TaskResultBuilder context(String contextKey, Object contextValue) {
            if (this.context$key == null) {
                this.context$key = new ArrayList();
                this.context$value = new ArrayList();
            }
            this.context$key.add(contextKey);
            this.context$value.add(contextValue);
            return this;
        }

        public TaskResultBuilder context(Map<? extends String, ?> context) {
            if (context == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (this.context$key == null) {
                this.context$key = new ArrayList();
                this.context$value = new ArrayList();
            }
            for (Map.Entry<String, ?> $lombokEntry : context.entrySet()) {
                this.context$key.add($lombokEntry.getKey());
                this.context$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TaskResultBuilder clearContext() {
            if (this.context$key != null) {
                this.context$key.clear();
                this.context$value.clear();
            }
            return this;
        }

        public TaskResultBuilder output(String outputKey, Object outputValue) {
            if (this.outputs$key == null) {
                this.outputs$key = new ArrayList();
                this.outputs$value = new ArrayList();
            }
            this.outputs$key.add(outputKey);
            this.outputs$value.add(outputValue);
            return this;
        }

        public TaskResultBuilder outputs(Map<? extends String, ?> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs$key == null) {
                this.outputs$key = new ArrayList();
                this.outputs$value = new ArrayList();
            }
            for (Map.Entry<String, ?> $lombokEntry : outputs.entrySet()) {
                this.outputs$key.add($lombokEntry.getKey());
                this.outputs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TaskResultBuilder clearOutputs() {
            if (this.outputs$key != null) {
                this.outputs$key.clear();
                this.outputs$value.clear();
            }
            return this;
        }

        public TaskResult build() {
            Map<Object, Object> outputs;
            Map<Object, Object> context;
            switch (this.context$key == null ? 0 : this.context$key.size()) {
                case 0: {
                    context = Collections.emptyMap();
                    break;
                }
                case 1: {
                    context = Collections.singletonMap(this.context$key.get(0), this.context$value.get(0));
                    break;
                }
                default: {
                    context = new LinkedHashMap(this.context$key.size() < 0x40000000 ? 1 + this.context$key.size() + (this.context$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.context$key.size(); ++$i) {
                        context.put(this.context$key.get($i), this.context$value.get($i));
                    }
                    context = Collections.unmodifiableMap(context);
                }
            }
            switch (this.outputs$key == null ? 0 : this.outputs$key.size()) {
                case 0: {
                    outputs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    outputs = Collections.singletonMap(this.outputs$key.get(0), this.outputs$value.get(0));
                    break;
                }
                default: {
                    outputs = new LinkedHashMap(this.outputs$key.size() < 0x40000000 ? 1 + this.outputs$key.size() + (this.outputs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.outputs$key.size(); ++$i) {
                        outputs.put(this.outputs$key.get($i), this.outputs$value.get($i));
                    }
                    outputs = Collections.unmodifiableMap(outputs);
                }
            }
            return new TaskResult(this.status, context, outputs);
        }

        public String toString() {
            return "TaskResult.TaskResultBuilder(status=" + this.status + ", context$key=" + this.context$key + ", context$value=" + this.context$value + ", outputs$key=" + this.outputs$key + ", outputs$value=" + this.outputs$value + ")";
        }
    }
}

