/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline.models;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

@Beta
public interface StageExecution {
    @Nonnull
    public String getId();

    public void setId(@Nonnull String var1);

    @Nullable
    public String getRefId();

    public void setRefId(@Nullable String var1);

    @Nonnull
    public String getType();

    public void setType(@Nonnull String var1);

    @Nonnull
    public String getName();

    public void setName(@Nonnull String var1);

    @Nonnull
    public PipelineExecution getExecution();

    public void setExecution(@Nonnull PipelineExecution var1);

    @Nullable
    public Long getStartTime();

    public void setStartTime(@Nullable Long var1);

    @Nullable
    public Long getEndTime();

    public void setEndTime(@Nullable Long var1);

    @Nullable
    public Long getStartTimeExpiry();

    public void setStartTimeExpiry(@Nullable Long var1);

    @Nonnull
    public ExecutionStatus getStatus();

    public void setStatus(@Nonnull ExecutionStatus var1);

    @Nonnull
    public Map<String, Object> getContext();

    public void setContext(@Nonnull Map<String, Object> var1);

    @Nonnull
    public Map<String, Object> getOutputs();

    public void setOutputs(@Nonnull Map<String, Object> var1);

    @Nonnull
    public List<TaskExecution> getTasks();

    public void setTasks(@Nonnull List<TaskExecution> var1);

    @Nullable
    public SyntheticStageOwner getSyntheticStageOwner();

    public void setSyntheticStageOwner(@Nullable SyntheticStageOwner var1);

    @Nullable
    public String getParentStageId();

    public void setParentStageId(@Nullable String var1);

    @Nonnull
    public Collection<String> getRequisiteStageRefIds();

    public void setRequisiteStageRefIds(@Nonnull Collection<String> var1);

    @Nullable
    public Long getScheduledTime();

    public void setScheduledTime(@Nullable Long var1);

    @Nullable
    public LastModifiedDetails getLastModified();

    public void setLastModified(@Nullable LastModifiedDetails var1);

    @Nullable
    public Map<String, String> getAdditionalMetricTags();

    public void setAdditionalMetricTags(Map<String, String> var1);

    public TaskExecution taskById(@Nonnull String var1);

    @Nonnull
    public List<StageExecution> ancestors();

    @Nonnull
    public List<StageExecution> directAncestors();

    @Nullable
    public StageExecution findAncestor(@Nonnull Predicate<StageExecution> var1);

    @Nonnull
    public List<StageExecution> allDownstreamStages();

    @Nonnull
    public List<StageExecution> directChildren();

    @Nonnull
    public <O> O mapTo(@Nonnull Class<O> var1);

    @Nonnull
    public <O> O mapTo(@Nullable String var1, @Nonnull Class<O> var2);

    @Nonnull
    public <O> O decodeBase64(@Nullable String var1, @Nonnull Class<O> var2);

    public void resolveStrategyParams();

    @Nullable
    public StageExecution getParent();

    @Nonnull
    public StageExecution getTopLevelStage();

    @Nonnull
    public Optional<StageExecution> getParentWithTimeout();

    @Nonnull
    public Optional<Long> getTimeout();

    public boolean getAllowSiblingStagesToContinueOnFailure();

    public void setAllowSiblingStagesToContinueOnFailure(boolean var1);

    public boolean getContinuePipelineOnFailure();

    public void setContinuePipelineOnFailure(boolean var1);

    public boolean isJoin();

    public boolean isManualJudgmentType();

    public boolean withPropagateAuthentication();

    public void appendErrorMessage(String var1);

    @Nonnull
    public List<StageExecution> downstreamStages();

    public static class LastModifiedDetails {
        @NonNull
        private String user;
        @NonNull
        private Collection<String> allowedAccounts = Collections.emptySet();
        @NonNull
        private Long lastModifiedTime;

        @Nonnull
        public Collection<String> getAllowedAccounts() {
            return Set.copyOf(this.allowedAccounts);
        }

        public void setAllowedAccounts(@Nonnull Collection<String> allowedAccounts) {
            this.allowedAccounts = Set.copyOf(allowedAccounts);
        }

        @NonNull
        public String getUser() {
            return this.user;
        }

        @NonNull
        public Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setUser(@NonNull String user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        public void setLastModifiedTime(@NonNull Long lastModifiedTime) {
            if (lastModifiedTime == null) {
                throw new NullPointerException("lastModifiedTime is marked non-null but is null");
            }
            this.lastModifiedTime = lastModifiedTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LastModifiedDetails)) {
                return false;
            }
            LastModifiedDetails other = (LastModifiedDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastModifiedTime = this.getLastModifiedTime();
            Long other$lastModifiedTime = other.getLastModifiedTime();
            if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            Collection<String> this$allowedAccounts = this.getAllowedAccounts();
            Collection<String> other$allowedAccounts = other.getAllowedAccounts();
            return !(this$allowedAccounts == null ? other$allowedAccounts != null : !((Object)this$allowedAccounts).equals(other$allowedAccounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LastModifiedDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastModifiedTime = this.getLastModifiedTime();
            result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            Collection<String> $allowedAccounts = this.getAllowedAccounts();
            result = result * 59 + ($allowedAccounts == null ? 43 : ((Object)$allowedAccounts).hashCode());
            return result;
        }

        public String toString() {
            return "StageExecution.LastModifiedDetails(user=" + this.getUser() + ", allowedAccounts=" + this.getAllowedAccounts() + ", lastModifiedTime=" + this.getLastModifiedTime() + ")";
        }
    }
}

