/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline.graph;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

@Beta
public interface StageDefinitionBuilder
extends SpinnakerExtensionPoint {
    @Nonnull
    default public TaskNode.TaskGraph buildTaskGraph(@Nonnull StageExecution stage) {
        TaskNode.Builder graphBuilder = TaskNode.Builder(TaskNode.GraphType.FULL);
        this.taskGraph(stage, graphBuilder);
        return graphBuilder.build();
    }

    default public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
    }

    default public void beforeStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
    }

    default public void afterStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
    }

    default public void onFailureStages(@Nonnull StageExecution stage, @Nonnull StageGraphBuilder graph) {
    }

    @Nonnull
    default public String getType() {
        return StageDefinitionBuilder.getType(this.getExtensionClass());
    }

    default public void prepareStageForRestart(@Nonnull StageExecution stage) {
    }

    public static String getType(Class<? extends StageDefinitionBuilder> clazz) {
        String className = clazz.getSimpleName();
        if (className.equals("")) {
            throw new IllegalStateException("StageDefinitionBuilder.getType() cannot be called on an anonymous type");
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1).replaceFirst("StageDefinitionBuilder$", "").replaceFirst("Stage$", "");
    }

    default public boolean canManuallySkip(StageExecution stage) {
        return false;
    }

    default public Collection<String> aliases() {
        if (this.getClass().isAnnotationPresent(Aliases.class)) {
            return Arrays.asList(this.getClass().getAnnotation(Aliases.class).value());
        }
        return Collections.emptyList();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Aliases {
        public String[] value() default {};
    }
}

