/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline.graph;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

@Beta
public interface TaskNode {
    public static TaskGraph build(GraphType type, Consumer<Builder> closure) {
        Builder builder = new Builder(type);
        closure.accept(builder);
        return builder.build();
    }

    public static TaskGraph emptyGraph(GraphType type) {
        return TaskNode.build(type, builder -> {});
    }

    public static TaskGraph singleton(GraphType type, String name, Class<? extends Task> implementingClass) {
        return TaskNode.build(type, builder -> builder.withTask(name, implementingClass));
    }

    public static TaskDefinition task(String name, Class<? extends Task> implementingClass) {
        return new TaskDefinition(name, implementingClass);
    }

    public static Builder Builder(GraphType type) {
        return new Builder(type);
    }

    public static class TaskDefinition
    implements TaskNode,
    DefinedTask {
        private final String name;
        private final Class<? extends Task> implementingClass;

        public TaskDefinition(@Nonnull String name, @Nonnull Class<? extends Task> implementingClass) {
            this.name = name;
            this.implementingClass = implementingClass;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public Class<? extends Task> getImplementingClass() {
            return this.implementingClass;
        }

        @Override
        @Nonnull
        public String getImplementingClassName() {
            return this.getImplementingClass().getCanonicalName();
        }
    }

    public static interface DefinedTask {
        @Nonnull
        public String getName();

        @Nonnull
        public String getImplementingClassName();
    }

    public static class TaskGraph
    implements TaskNode,
    Iterable<TaskNode> {
        private final GraphType type;
        private final List<TaskNode> graph;

        @VisibleForTesting
        public TaskGraph(GraphType type, List<TaskNode> graph) {
            this.type = type;
            this.graph = graph;
        }

        @Override
        public Iterator<TaskNode> iterator() {
            return this.graph.iterator();
        }

        public ListIterator<TaskNode> listIterator() {
            return this.graph.listIterator();
        }

        public boolean isEmpty() {
            return this.graph.isEmpty();
        }

        public GraphType getType() {
            return this.type;
        }
    }

    public static class Builder {
        private final GraphType type;
        private final List<TaskNode> graph = new ArrayList<TaskNode>();

        public Builder(GraphType type) {
            this.type = type;
        }

        public Builder withTask(String name, Class<? extends Task> implementingClass) {
            this.graph.add(new TaskDefinition(name, implementingClass));
            return this;
        }

        public Builder withTask(TaskNode task) {
            this.graph.add(task);
            return this;
        }

        public Builder withLoop(Consumer<Builder> subGraph) {
            Builder subGraphBuilder = new Builder(GraphType.LOOP);
            subGraph.accept(subGraphBuilder);
            this.graph.add(subGraphBuilder.build());
            return this;
        }

        TaskGraph build() {
            return new TaskGraph(this.type, this.graph);
        }
    }

    public static enum GraphType {
        FULL,
        LOOP,
        HEAD,
        TAIL;

    }
}

