/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public enum ExecutionStatus implements CharSequence
{
    NOT_STARTED(false, false),
    RUNNING(false, false),
    PAUSED(false, false),
    SUSPENDED(false, false),
    SUCCEEDED(true, false),
    FAILED_CONTINUE(true, false),
    TERMINAL(true, true),
    CANCELED(true, true),
    REDIRECT(false, false),
    STOPPED(true, true),
    SKIPPED(true, false),
    BUFFERED(false, false);

    public static final Collection<ExecutionStatus> COMPLETED;
    private static final Collection<ExecutionStatus> SUCCESSFUL;
    private static final Collection<ExecutionStatus> FAILURE;
    private final boolean complete;
    private final boolean halt;

    public final boolean isComplete() {
        return this.complete;
    }

    public final boolean isSkipped() {
        return SKIPPED.equals(this);
    }

    public final boolean isHalt() {
        return this.halt;
    }

    private ExecutionStatus(boolean complete, boolean halt) {
        this.complete = complete;
        this.halt = halt;
    }

    public boolean isSuccessful() {
        return SUCCESSFUL.contains(this);
    }

    public boolean isFailure() {
        return FAILURE.contains(this);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    static {
        COMPLETED = Collections.unmodifiableList(Arrays.asList(CANCELED, SUCCEEDED, STOPPED, SKIPPED, TERMINAL, FAILED_CONTINUE));
        SUCCESSFUL = Collections.unmodifiableList(Arrays.asList(SUCCEEDED, STOPPED, SKIPPED));
        FAILURE = Collections.unmodifiableList(Arrays.asList(TERMINAL, STOPPED, FAILED_CONTINUE));
    }
}

