/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.preconfigured.jobs;

import com.netflix.spinnaker.orca.api.preconfigured.jobs.PreconfiguredJobStageProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TitusPreconfiguredJobProperties
extends PreconfiguredJobStageProperties {
    private Cluster cluster = new Cluster();

    public TitusPreconfiguredJobProperties(String label, String type) {
        super(label, type, "titus");
    }

    @Override
    public List<String> getOverridableFields() {
        ArrayList<String> overrideableFields = new ArrayList<String>(Arrays.asList("cluster"));
        overrideableFields.addAll(super.getOverridableFields());
        return overrideableFields;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.cluster.isValid();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public String toString() {
        return "TitusPreconfiguredJobProperties(cluster=" + this.getCluster() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TitusPreconfiguredJobProperties)) {
            return false;
        }
        TitusPreconfiguredJobProperties other = (TitusPreconfiguredJobProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cluster this$cluster = this.getCluster();
        Cluster other$cluster = other.getCluster();
        return !(this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TitusPreconfiguredJobProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cluster $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        return result;
    }

    public TitusPreconfiguredJobProperties() {
    }

    public TitusPreconfiguredJobProperties(Cluster cluster) {
        this.cluster = cluster;
    }

    public class Cluster {
        String imageId;
        String application;
        String stack;
        String region;
        Integer runtimeLimitSecs = 3600;
        Integer retries = 2;
        Map<String, String> env;
        private Resources resources = new Resources();
        private Capacity capacity = new Capacity();

        boolean isValid() {
            return this.imageId != null && !this.imageId.isEmpty() && this.application != null && !this.application.isEmpty() && this.region != null && !this.region.isEmpty();
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getApplication() {
            return this.application;
        }

        public String getStack() {
            return this.stack;
        }

        public String getRegion() {
            return this.region;
        }

        public Integer getRuntimeLimitSecs() {
            return this.runtimeLimitSecs;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public Resources getResources() {
            return this.resources;
        }

        public Capacity getCapacity() {
            return this.capacity;
        }

        public void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public void setStack(String stack) {
            this.stack = stack;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setRuntimeLimitSecs(Integer runtimeLimitSecs) {
            this.runtimeLimitSecs = runtimeLimitSecs;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public void setEnv(Map<String, String> env) {
            this.env = env;
        }

        public void setResources(Resources resources) {
            this.resources = resources;
        }

        public void setCapacity(Capacity capacity) {
            this.capacity = capacity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cluster)) {
                return false;
            }
            Cluster other = (Cluster)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$runtimeLimitSecs = this.getRuntimeLimitSecs();
            Integer other$runtimeLimitSecs = other.getRuntimeLimitSecs();
            if (this$runtimeLimitSecs == null ? other$runtimeLimitSecs != null : !((Object)this$runtimeLimitSecs).equals(other$runtimeLimitSecs)) {
                return false;
            }
            Integer this$retries = this.getRetries();
            Integer other$retries = other.getRetries();
            if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
                return false;
            }
            String this$imageId = this.getImageId();
            String other$imageId = other.getImageId();
            if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$stack = this.getStack();
            String other$stack = other.getStack();
            if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            Map<String, String> this$env = this.getEnv();
            Map<String, String> other$env = other.getEnv();
            if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
                return false;
            }
            Resources this$resources = this.getResources();
            Resources other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            Capacity this$capacity = this.getCapacity();
            Capacity other$capacity = other.getCapacity();
            return !(this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cluster;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $runtimeLimitSecs = this.getRuntimeLimitSecs();
            result = result * 59 + ($runtimeLimitSecs == null ? 43 : ((Object)$runtimeLimitSecs).hashCode());
            Integer $retries = this.getRetries();
            result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
            String $imageId = this.getImageId();
            result = result * 59 + ($imageId == null ? 43 : $imageId.hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $stack = this.getStack();
            result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            Map<String, String> $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
            Resources $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            Capacity $capacity = this.getCapacity();
            result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
            return result;
        }

        public String toString() {
            return "TitusPreconfiguredJobProperties.Cluster(imageId=" + this.getImageId() + ", application=" + this.getApplication() + ", stack=" + this.getStack() + ", region=" + this.getRegion() + ", runtimeLimitSecs=" + this.getRuntimeLimitSecs() + ", retries=" + this.getRetries() + ", env=" + this.getEnv() + ", resources=" + this.getResources() + ", capacity=" + this.getCapacity() + ")";
        }

        public class Capacity {
            private Integer desired = 1;
            private Integer max = 1;
            private Integer min = 1;

            public Integer getDesired() {
                return this.desired;
            }

            public Integer getMax() {
                return this.max;
            }

            public Integer getMin() {
                return this.min;
            }

            public void setDesired(Integer desired) {
                this.desired = desired;
            }

            public void setMax(Integer max) {
                this.max = max;
            }

            public void setMin(Integer min) {
                this.min = min;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Capacity)) {
                    return false;
                }
                Capacity other = (Capacity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$desired = this.getDesired();
                Integer other$desired = other.getDesired();
                if (this$desired == null ? other$desired != null : !((Object)this$desired).equals(other$desired)) {
                    return false;
                }
                Integer this$max = this.getMax();
                Integer other$max = other.getMax();
                if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                    return false;
                }
                Integer this$min = this.getMin();
                Integer other$min = other.getMin();
                return !(this$min == null ? other$min != null : !((Object)this$min).equals(other$min));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Capacity;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $desired = this.getDesired();
                result = result * 59 + ($desired == null ? 43 : ((Object)$desired).hashCode());
                Integer $max = this.getMax();
                result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                Integer $min = this.getMin();
                result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
                return result;
            }

            public String toString() {
                return "TitusPreconfiguredJobProperties.Cluster.Capacity(desired=" + this.getDesired() + ", max=" + this.getMax() + ", min=" + this.getMin() + ")";
            }
        }

        public class Resources {
            private Integer cpu = 1;
            private Integer disk = 10000;
            Integer gpu = 0;
            Integer memory = 512;
            Integer networkMbps = 128;

            public Integer getCpu() {
                return this.cpu;
            }

            public Integer getDisk() {
                return this.disk;
            }

            public Integer getGpu() {
                return this.gpu;
            }

            public Integer getMemory() {
                return this.memory;
            }

            public Integer getNetworkMbps() {
                return this.networkMbps;
            }

            public void setCpu(Integer cpu) {
                this.cpu = cpu;
            }

            public void setDisk(Integer disk) {
                this.disk = disk;
            }

            public void setGpu(Integer gpu) {
                this.gpu = gpu;
            }

            public void setMemory(Integer memory) {
                this.memory = memory;
            }

            public void setNetworkMbps(Integer networkMbps) {
                this.networkMbps = networkMbps;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resources)) {
                    return false;
                }
                Resources other = (Resources)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$cpu = this.getCpu();
                Integer other$cpu = other.getCpu();
                if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
                    return false;
                }
                Integer this$disk = this.getDisk();
                Integer other$disk = other.getDisk();
                if (this$disk == null ? other$disk != null : !((Object)this$disk).equals(other$disk)) {
                    return false;
                }
                Integer this$gpu = this.getGpu();
                Integer other$gpu = other.getGpu();
                if (this$gpu == null ? other$gpu != null : !((Object)this$gpu).equals(other$gpu)) {
                    return false;
                }
                Integer this$memory = this.getMemory();
                Integer other$memory = other.getMemory();
                if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
                    return false;
                }
                Integer this$networkMbps = this.getNetworkMbps();
                Integer other$networkMbps = other.getNetworkMbps();
                return !(this$networkMbps == null ? other$networkMbps != null : !((Object)this$networkMbps).equals(other$networkMbps));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Resources;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $cpu = this.getCpu();
                result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
                Integer $disk = this.getDisk();
                result = result * 59 + ($disk == null ? 43 : ((Object)$disk).hashCode());
                Integer $gpu = this.getGpu();
                result = result * 59 + ($gpu == null ? 43 : ((Object)$gpu).hashCode());
                Integer $memory = this.getMemory();
                result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
                Integer $networkMbps = this.getNetworkMbps();
                result = result * 59 + ($networkMbps == null ? 43 : ((Object)$networkMbps).hashCode());
                return result;
            }

            public String toString() {
                return "TitusPreconfiguredJobProperties.Cluster.Resources(cpu=" + this.getCpu() + ", disk=" + this.getDisk() + ", gpu=" + this.getGpu() + ", memory=" + this.getMemory() + ", networkMbps=" + this.getNetworkMbps() + ")";
            }
        }
    }
}

