/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.pipeline;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface Task
extends SpinnakerExtensionPoint {
    @Nonnull
    public TaskResult execute(@Nonnull StageExecution var1);

    @Nullable
    default public TaskResult onTimeout(@Nonnull StageExecution stage) {
        return null;
    }

    @Deprecated
    default public void onCancel(@Nonnull StageExecution stage) {
    }

    @Nullable
    default public TaskResult onCancelWithResult(@Nonnull StageExecution stage) {
        this.onCancel(stage);
        return null;
    }

    default public Collection<String> aliases() {
        if (this.getClass().isAnnotationPresent(Aliases.class)) {
            return Arrays.asList(this.getClass().getAnnotation(Aliases.class).value());
        }
        return Collections.emptyList();
    }

    default public Map<String, Object> filterContextOutputs(Map<String, Object> outputs, Collection<String> keysToFilter) {
        return outputs.entrySet().stream().filter(map -> !keysToFilter.contains(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Aliases {
        public String[] value() default {};
    }
}

