/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.preconfigured.jobs;

import com.netflix.spinnaker.orca.api.preconfigured.jobs.PreconfiguredJobStageParameter;
import java.util.Arrays;
import java.util.List;

public abstract class PreconfiguredJobStageProperties {
    private boolean enabled = true;
    private String label;
    private String description;
    private String type;
    private List<PreconfiguredJobStageParameter> parameters;
    private boolean waitForCompletion = true;
    private String cloudProvider;
    private String credentials;
    private String region;
    private String propertyFile;
    private PreconfiguredJobUIType uiType = PreconfiguredJobUIType.BASIC;
    private boolean producesArtifacts = false;

    PreconfiguredJobStageProperties(String label, String type, String cloudProvider) {
        this.label = label;
        this.type = type;
        this.cloudProvider = cloudProvider;
    }

    public List<String> getOverridableFields() {
        return Arrays.asList("cloudProvider", "credentials", "region", "propertyFile", "waitForCompletion");
    }

    public boolean isValid() {
        return this.label != null && !this.label.isEmpty() && this.cloudProvider != null && !this.cloudProvider.isEmpty() && this.type != null && !this.type.isEmpty();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public List<PreconfiguredJobStageParameter> getParameters() {
        return this.parameters;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public String getCloudProvider() {
        return this.cloudProvider;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public PreconfiguredJobUIType getUiType() {
        return this.uiType;
    }

    public boolean isProducesArtifacts() {
        return this.producesArtifacts;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParameters(List<PreconfiguredJobStageParameter> parameters) {
        this.parameters = parameters;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public void setCloudProvider(String cloudProvider) {
        this.cloudProvider = cloudProvider;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setUiType(PreconfiguredJobUIType uiType) {
        this.uiType = uiType;
    }

    public void setProducesArtifacts(boolean producesArtifacts) {
        this.producesArtifacts = producesArtifacts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreconfiguredJobStageProperties)) {
            return false;
        }
        PreconfiguredJobStageProperties other = (PreconfiguredJobStageProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isWaitForCompletion() != other.isWaitForCompletion()) {
            return false;
        }
        if (this.isProducesArtifacts() != other.isProducesArtifacts()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<PreconfiguredJobStageParameter> this$parameters = this.getParameters();
        List<PreconfiguredJobStageParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$cloudProvider = this.getCloudProvider();
        String other$cloudProvider = other.getCloudProvider();
        if (this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider)) {
            return false;
        }
        String this$credentials = this.getCredentials();
        String other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$propertyFile = this.getPropertyFile();
        String other$propertyFile = other.getPropertyFile();
        if (this$propertyFile == null ? other$propertyFile != null : !this$propertyFile.equals(other$propertyFile)) {
            return false;
        }
        PreconfiguredJobUIType this$uiType = this.getUiType();
        PreconfiguredJobUIType other$uiType = other.getUiType();
        return !(this$uiType == null ? other$uiType != null : !((Object)((Object)this$uiType)).equals((Object)other$uiType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreconfiguredJobStageProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isWaitForCompletion() ? 79 : 97);
        result = result * 59 + (this.isProducesArtifacts() ? 79 : 97);
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<PreconfiguredJobStageParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $cloudProvider = this.getCloudProvider();
        result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
        String $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $propertyFile = this.getPropertyFile();
        result = result * 59 + ($propertyFile == null ? 43 : $propertyFile.hashCode());
        PreconfiguredJobUIType $uiType = this.getUiType();
        result = result * 59 + ($uiType == null ? 43 : ((Object)((Object)$uiType)).hashCode());
        return result;
    }

    public String toString() {
        return "PreconfiguredJobStageProperties(enabled=" + this.isEnabled() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", parameters=" + String.valueOf(this.getParameters()) + ", waitForCompletion=" + this.isWaitForCompletion() + ", cloudProvider=" + this.getCloudProvider() + ", credentials=" + this.getCredentials() + ", region=" + this.getRegion() + ", propertyFile=" + this.getPropertyFile() + ", uiType=" + String.valueOf((Object)this.getUiType()) + ", producesArtifacts=" + this.isProducesArtifacts() + ")";
    }

    public PreconfiguredJobStageProperties() {
    }

    public static enum PreconfiguredJobUIType {
        BASIC,
        CUSTOM;

    }
}

