/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.api.operations;

import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OperationsInput {
    @Nullable
    private String cloudProvider;
    @Nonnull
    private Collection<? extends Map<String, Map>> operations;
    @Nonnull
    private StageExecution stageExecution;
    @Nullable
    private String contextKey;

    public boolean hasCloudProvider() {
        return this.cloudProvider != null && !this.cloudProvider.isEmpty();
    }

    public static OperationsInput of(String cloudProvider, Collection<? extends Map<String, Map>> operations, StageExecution stageExecution) {
        return OperationsInput.builder().cloudProvider(cloudProvider).operations(operations).stageExecution(stageExecution).build();
    }

    public static OperationsInput of(Collection<? extends Map<String, Map>> operations, StageExecution stageExecution) {
        return OperationsInput.of(null, operations, stageExecution);
    }

    public static OperationsInputBuilder builder() {
        return new OperationsInputBuilder();
    }

    public OperationsInputBuilder toBuilder() {
        return new OperationsInputBuilder().cloudProvider(this.cloudProvider).operations(this.operations).stageExecution(this.stageExecution).contextKey(this.contextKey);
    }

    @Nullable
    public String getCloudProvider() {
        return this.cloudProvider;
    }

    @Nonnull
    public Collection<? extends Map<String, Map>> getOperations() {
        return this.operations;
    }

    @Nonnull
    public StageExecution getStageExecution() {
        return this.stageExecution;
    }

    @Nullable
    public String getContextKey() {
        return this.contextKey;
    }

    public void setCloudProvider(@Nullable String cloudProvider) {
        this.cloudProvider = cloudProvider;
    }

    public void setOperations(@Nonnull Collection<? extends Map<String, Map>> operations) {
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.operations = operations;
    }

    public void setStageExecution(@Nonnull StageExecution stageExecution) {
        if (stageExecution == null) {
            throw new NullPointerException("stageExecution is marked non-null but is null");
        }
        this.stageExecution = stageExecution;
    }

    public void setContextKey(@Nullable String contextKey) {
        this.contextKey = contextKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationsInput)) {
            return false;
        }
        OperationsInput other = (OperationsInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cloudProvider = this.getCloudProvider();
        String other$cloudProvider = other.getCloudProvider();
        if (this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider)) {
            return false;
        }
        Collection<? extends Map<String, Map>> this$operations = this.getOperations();
        Collection<? extends Map<String, Map>> other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        StageExecution this$stageExecution = this.getStageExecution();
        StageExecution other$stageExecution = other.getStageExecution();
        if (this$stageExecution == null ? other$stageExecution != null : !this$stageExecution.equals(other$stageExecution)) {
            return false;
        }
        String this$contextKey = this.getContextKey();
        String other$contextKey = other.getContextKey();
        return !(this$contextKey == null ? other$contextKey != null : !this$contextKey.equals(other$contextKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationsInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cloudProvider = this.getCloudProvider();
        result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
        Collection<? extends Map<String, Map>> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        StageExecution $stageExecution = this.getStageExecution();
        result = result * 59 + ($stageExecution == null ? 43 : $stageExecution.hashCode());
        String $contextKey = this.getContextKey();
        result = result * 59 + ($contextKey == null ? 43 : $contextKey.hashCode());
        return result;
    }

    public String toString() {
        return "OperationsInput(cloudProvider=" + this.getCloudProvider() + ", operations=" + String.valueOf(this.getOperations()) + ", stageExecution=" + String.valueOf(this.getStageExecution()) + ", contextKey=" + this.getContextKey() + ")";
    }

    public OperationsInput(@Nullable String cloudProvider, @Nonnull Collection<? extends Map<String, Map>> operations, @Nonnull StageExecution stageExecution, @Nullable String contextKey) {
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        if (stageExecution == null) {
            throw new NullPointerException("stageExecution is marked non-null but is null");
        }
        this.cloudProvider = cloudProvider;
        this.operations = operations;
        this.stageExecution = stageExecution;
        this.contextKey = contextKey;
    }

    public static class OperationsInputBuilder {
        private String cloudProvider;
        private Collection<? extends Map<String, Map>> operations;
        private StageExecution stageExecution;
        private String contextKey;

        OperationsInputBuilder() {
        }

        public OperationsInputBuilder cloudProvider(@Nullable String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        public OperationsInputBuilder operations(@Nonnull Collection<? extends Map<String, Map>> operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            this.operations = operations;
            return this;
        }

        public OperationsInputBuilder stageExecution(@Nonnull StageExecution stageExecution) {
            if (stageExecution == null) {
                throw new NullPointerException("stageExecution is marked non-null but is null");
            }
            this.stageExecution = stageExecution;
            return this;
        }

        public OperationsInputBuilder contextKey(@Nullable String contextKey) {
            this.contextKey = contextKey;
            return this;
        }

        public OperationsInput build() {
            return new OperationsInput(this.cloudProvider, this.operations, this.stageExecution, this.contextKey);
        }

        public String toString() {
            return "OperationsInput.OperationsInputBuilder(cloudProvider=" + this.cloudProvider + ", operations=" + String.valueOf(this.operations) + ", stageExecution=" + String.valueOf(this.stageExecution) + ", contextKey=" + this.contextKey + ")";
        }
    }
}

