/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.applications.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.applications.utils.ApplicationNameValidator;
import com.netflix.spinnaker.orca.applications.utils.NameConstraint;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.Application;
import com.netflix.spinnaker.orca.front50.tasks.AbstractFront50Task;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class UpsertApplicationTask
extends AbstractFront50Task
implements ApplicationNameValidator,
ApplicationNameValidator.Trait.FieldHelper {
    private static final transient Logger log;
    private Map<String, NameConstraint> com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidator__cloudProviderNameConstraints;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ long $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public UpsertApplicationTask(@Nullable Front50Service front50Service, ObjectMapper mapper, DynamicConfigService configService) {
        super(front50Service, mapper, configService);
        ApplicationNameValidator.Trait.Helper.$init$(this);
    }

    public long getBackoffPeriod() {
        return DefaultTypeTransformation.longUnbox((Object)this.getConfigService().getConfig(Long.class, "tasks.upsert-application.backoff-ms", (Object)$const$0));
    }

    public long getTimeout() {
        return DefaultTypeTransformation.longUnbox((Object)this.getConfigService().getConfig(Long.class, "tasks.upsert-application.timeout-ms", (Object)$const$1));
    }

    public TaskResult performRequest(Application application) {
        Application application2;
        LinkedHashMap outputs = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)outputs, (String)"previousState");
        List<String> validationErrors = this.validate(application);
        if (DefaultTypeTransformation.booleanUnbox(validationErrors)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{validationErrors}, new String[]{"Invalid application name, errors: ", ""})));
        }
        Application existingApplication = this.fetchApplication(application.name);
        if (DefaultTypeTransformation.booleanUnbox((Object)existingApplication)) {
            Object v0;
            Application application3 = existingApplication;
            ScriptBytecodeAdapter.setProperty((Object)application3, null, (Object)outputs, (String)"previousState");
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{application.name}, new String[]{"Updating application (name: ", ")"})));
                v0 = null;
            } else {
                v0 = null;
            }
            this.getFront50Service().update(application.name, application);
        } else {
            Object v1;
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{application.name}, new String[]{"Creating application (name: ", ")"})));
                v1 = null;
            } else {
                v1 = null;
            }
            this.getFront50Service().create(application);
            Application.Permission permission = application.getPermission();
            if ((permission != null ? permission.getPermissions() : null) == null) {
                application.setPermissions(Permissions.EMPTY);
            }
        }
        Application.Permission permission = application.getPermission();
        if ((permission != null ? permission.getPermissions() : null) != null) {
            this.getFront50Service().updatePermission(application.name, application.getPermission());
        }
        Application application4 = DefaultTypeTransformation.booleanUnbox((Object)(application2 = application)) ? application2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)application4, null, (Object)outputs, (String)"newState");
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context((Map)outputs).outputs((Map)outputs).build();
    }

    public String getNotificationType() {
        return "upsertapplication";
    }

    @Override
    @Traits.TraitBridge(traitClass=ApplicationNameValidator.class, desc="(Ljava/util/Map;)V")
    public void setCloudProviderNameConstraints(Map<String, NameConstraint> value) {
        ApplicationNameValidator.Trait.Helper.setCloudProviderNameConstraints(this, value);
    }

    public /* synthetic */ void com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidatortrait$super$setCloudProviderNameConstraints(Map<String, NameConstraint> value) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setCloudProviderNameConstraints", (Object)new Object[]{value});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(AbstractFront50Task.class, (GroovyObject)this, (String)"setCloudProviderNameConstraints", (Object[])new Object[]{value});
        }
    }

    @Override
    @Traits.TraitBridge(traitClass=ApplicationNameValidator.class, desc="()Ljava/util/Map;")
    public Map<String, NameConstraint> getCloudProviderNameConstraints() {
        return ApplicationNameValidator.Trait.Helper.getCloudProviderNameConstraints(this);
    }

    public /* synthetic */ Map<String, NameConstraint> com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidatortrait$super$getCloudProviderNameConstraints() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getCloudProviderNameConstraints", (Object)new Object[0]), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(AbstractFront50Task.class, (GroovyObject)this, (String)"getCloudProviderNameConstraints"), Map.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=ApplicationNameValidator.class, desc="(Lcom/netflix/spinnaker/orca/front50/model/Application;)Ljava/util/List;")
    public List<String> validate(Application application) {
        return ApplicationNameValidator.Trait.Helper.validate(this, application);
    }

    public /* synthetic */ List<String> com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidatortrait$super$validate(Application application) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"validate", (Object)new Object[]{application}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(AbstractFront50Task.class, (GroovyObject)this, (String)"validate", (Object[])new Object[]{application}), List.class);
    }

    static {
        Logger logger;
        UpsertApplicationTask.__$swapInit();
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.applications.tasks.UpsertApplicationTask");
        ApplicationNameValidator.Trait.Helper.$static$init$(UpsertApplicationTask.class);
    }

    @Override
    public Map<String, NameConstraint> com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidator__cloudProviderNameConstraints$get() {
        return this.com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidator__cloudProviderNameConstraints;
    }

    @Override
    public Map<String, NameConstraint> com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidator__cloudProviderNameConstraints$set(Map<String, NameConstraint> val) {
        Map<String, NameConstraint> map = val;
        this.com_netflix_spinnaker_orca_applications_utils_ApplicationNameValidator__cloudProviderNameConstraints = map;
        return map;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertApplicationTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        long l2;
        $const$0 = l2 = 10000L;
        $const$1 = l = 3600000L;
    }
}

