/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery;

import com.netflix.spinnaker.kork.web.selector.v2.SelectableService;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.config.BakeryConfigurationProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class BakerySelector {
    private static final String SELECT_BAKERY = "selectBakery";
    private SelectableService<BakeryService> selectableService;
    private final BakeryService defaultService;
    private final Map<String, Object> defaultConfig;
    private final boolean selectBakery;

    public BakerySelector(BakeryService defaultBakeryService, BakeryConfigurationProperties bakeryConfigurationProperties, Function<String, BakeryService> getBakeryServiceByUrlFx) {
        this.defaultService = defaultBakeryService;
        this.defaultConfig = this.getDefaultConfig(bakeryConfigurationProperties);
        this.selectableService = this.getSelectableService(bakeryConfigurationProperties.getBaseUrls(), getBakeryServiceByUrlFx);
        this.selectBakery = bakeryConfigurationProperties.isSelectorEnabled();
    }

    public SelectableService.SelectedService<BakeryService> select(StageExecution stage) {
        if (!this.shouldSelect(stage)) {
            return new SelectableService.SelectedService((Object)this.defaultService, this.defaultConfig, null);
        }
        String application = stage.getExecution().getApplication();
        String user = Optional.ofNullable(stage.getExecution().getAuthentication()).map(PipelineExecution.AuthenticationDetails::getUser).orElse("unknown");
        ArrayList<SelectableService.Parameter> parameters = new ArrayList<SelectableService.Parameter>();
        stage.getContext().forEach((key, value) -> {
            Optional<String> paramName = SelectableFields.contextFields.stream().filter(f -> f.equals(key)).findFirst();
            paramName.ifPresent(name -> parameters.add(new SelectableService.Parameter().withName(name).withValues(Collections.singletonList(value))));
        });
        parameters.add(new SelectableService.Parameter().withName("authenticatedUser").withValues(Collections.singletonList(user)));
        parameters.add(new SelectableService.Parameter().withName("application").withValues(Collections.singletonList(application)));
        return this.selectableService.byParameters(parameters);
    }

    private Map<String, Object> getDefaultConfig(BakeryConfigurationProperties properties) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("roscoApisEnabled", properties.isRoscoApisEnabled());
        config.put("allowMissingPackageInstallation", properties.isAllowMissingPackageInstallation());
        config.put("extractBuildDetails", properties.isExtractBuildDetails());
        return config;
    }

    private SelectableService<BakeryService> getSelectableService(List<SelectableService.BaseUrl> baseUrls, Function<String, BakeryService> getBakeryServiceByUrlFx) {
        if (baseUrls == null) {
            return null;
        }
        return new SelectableService(baseUrls, (Object)this.defaultService, this.defaultConfig, getBakeryServiceByUrlFx);
    }

    private boolean shouldSelect(StageExecution stage) {
        if (this.selectableService == null || this.selectableService.getServices().size() < 2) {
            return false;
        }
        if (this.selectBakery) {
            return true;
        }
        return stage.getContext().getOrDefault(SELECT_BAKERY, false);
    }

    static interface ConfigFields {
        public static final String roscoApisEnabled = "roscoApisEnabled";
        public static final String allowMissingPackageInstallation = "allowMissingPackageInstallation";
        public static final String extractBuildDetails = "extractBuildDetails";
    }

    static interface SelectableFields {
        public static final String authenticatedUser = "authenticatedUser";
        public static final String application = "application";
        public static final List<String> contextFields = Arrays.asList("cloudProvider", "region", "baseOs", "cloudProviderType");
    }
}

