/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.netflix.spinnaker.orca.bakery.BakerySelector;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.config.BakeryConfigurationProperties;
import com.netflix.spinnaker.orca.config.OrcaConfiguration;
import com.netflix.spinnaker.orca.retrofit.RetrofitConfiguration;
import com.netflix.spinnaker.orca.retrofit.logging.RetrofitSlf4jLog;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import retrofit.Endpoints;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Configuration
@Import(value={OrcaConfiguration.class, RetrofitConfiguration.class})
@ComponentScan(value={"com.netflix.spinnaker.orca.bakery.pipeline", "com.netflix.spinnaker.orca.bakery.tasks"})
@ConditionalOnExpression(value="${bakery.enabled:true}")
@EnableConfigurationProperties(value={BakeryConfigurationProperties.class})
public class BakeryConfiguration
implements GroovyObject {
    @Autowired
    private Client retrofitClient;
    @Autowired
    private RestAdapter.LogLevel retrofitLogLevel;
    @Autowired
    private RequestInterceptor spinnakerRequestInterceptor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public BakeryConfiguration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Bean
    public BakeryService bakery(@Value(value="${bakery.base-url}") String bakeryBaseUrl) {
        return this.buildService(bakeryBaseUrl);
    }

    public static ObjectMapper bakeryConfiguredObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy()).setDateFormat((DateFormat)new SimpleDateFormat("YYYYMMDDHHmm")).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }

    public BakeryService buildService(String url) {
        return (BakeryService)ScriptBytecodeAdapter.castToType((Object)new RestAdapter.Builder().setEndpoint(Endpoints.newFixedEndpoint((String)url)).setRequestInterceptor(this.spinnakerRequestInterceptor).setConverter((Converter)new JacksonConverter(BakeryConfiguration.bakeryConfiguredObjectMapper())).setClient(this.retrofitClient).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new RetrofitSlf4jLog(BakeryService.class)).build().create(BakeryService.class), BakeryService.class);
    }

    @Bean
    public BakerySelector bakerySelector(BakeryService bakery, BakeryConfigurationProperties bakeryConfigurationProperties) {
        public final class _bakerySelector_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _bakerySelector_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object url) {
                return ((BakeryConfiguration)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BakeryConfiguration.class)).buildService((String)ScriptBytecodeAdapter.asType((Object)url, String.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bakerySelector_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return new BakerySelector(bakery, bakeryConfigurationProperties, (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _bakerySelector_closure1(this, this)), Function.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BakeryConfiguration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public Client getRetrofitClient() {
        return this.retrofitClient;
    }

    @Generated
    public void setRetrofitClient(Client client) {
        this.retrofitClient = client;
    }

    @Generated
    public RestAdapter.LogLevel getRetrofitLogLevel() {
        return this.retrofitLogLevel;
    }

    @Generated
    public void setRetrofitLogLevel(RestAdapter.LogLevel logLevel) {
        this.retrofitLogLevel = logLevel;
    }

    @Generated
    public RequestInterceptor getSpinnakerRequestInterceptor() {
        return this.spinnakerRequestInterceptor;
    }

    @Generated
    public void setSpinnakerRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.spinnakerRequestInterceptor = requestInterceptor;
    }
}

