/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.pipeline;

import com.google.common.base.Joiner;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.exceptions.ConstraintViolationException;
import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.bakery.tasks.CompletedBakeTask;
import com.netflix.spinnaker.orca.bakery.tasks.CreateBakeTask;
import com.netflix.spinnaker.orca.bakery.tasks.MonitorBakeTask;
import com.netflix.spinnaker.orca.pipeline.StageExecutionFactory;
import com.netflix.spinnaker.orca.pipeline.tasks.ToggleablePauseTask;
import com.netflix.spinnaker.orca.pipeline.tasks.artifacts.BindProducedArtifactsTask;
import com.netflix.spinnaker.orca.pipeline.util.RegionCollector;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BakeStage
implements StageDefinitionBuilder,
GroovyObject {
    public static final String PIPELINE_CONFIG_TYPE = "bake";
    public static final String BAKE_PAUSE_TOGGLE = "stages.bake-stage.pause";
    private RegionCollector regionCollector;
    private Clock clock;
    private DynamicConfigService dynamicConfigService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public BakeStage(RegionCollector regionCollector, DynamicConfigService dynamicConfigService, Clock clock) {
        DynamicConfigService dynamicConfigService2;
        Clock clock2;
        RegionCollector regionCollector2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.regionCollector = regionCollector2 = regionCollector;
        this.clock = clock2 = clock;
        this.dynamicConfigService = dynamicConfigService2 = dynamicConfigService;
    }

    @Generated
    public BakeStage(RegionCollector regionCollector, DynamicConfigService dynamicConfigService) {
        this(regionCollector, dynamicConfigService, Clock.systemUTC());
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        if (this.isTopLevelStage(stage)) {
            builder.withTask("completeParallel", CompleteParallelBakeTask.class);
        } else {
            if (this.dynamicConfigService.isEnabled(BAKE_PAUSE_TOGGLE, false)) {
                Object v0;
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stage.getName()}, new String[]{"Baking is currently paused. Adding pause task to ", " stage."})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                stage.getContext().put("pauseToggleKey", BAKE_PAUSE_TOGGLE);
                builder.withTask("delayBake", ToggleablePauseTask.class);
            }
            builder.withTask("createBake", CreateBakeTask.class).withTask("monitorBake", MonitorBakeTask.class).withTask("completedBake", CompletedBakeTask.class).withTask("bindProducedArtifacts", BindProducedArtifactsTask.class);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void beforeStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
        void var2_2;
        Reference parent2 = new Reference((Object)parent);
        Reference graph2 = new Reference((Object)var2_2);
        if (this.isTopLevelStage((StageExecution)parent2.get())) {
            public final class _beforeStages_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference parent;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _beforeStages_closure1(Object _outerInstance, Object _thisObject, Reference parent) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.parent = reference = parent;
                }

                public Object doCall(Object context) {
                    return StageExecutionFactory.newStage((PipelineExecution)((StageExecution)this.parent.get()).getExecution(), (String)((StageDefinitionBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StageDefinitionBuilder.class)).getType(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{context.get("region")}, new String[]{"Bake in ", ""})), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)context, Map.class)), (StageExecution)((StageExecution)ScriptBytecodeAdapter.castToType((Object)this.parent.get(), StageExecution.class)), (SyntheticStageOwner)SyntheticStageOwner.STAGE_BEFORE);
                }

                @Generated
                public StageExecution getParent() {
                    return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.parent.get(), StageExecution.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _beforeStages_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _beforeStages_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference graph;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _beforeStages_closure2(Object _outerInstance, Object _thisObject, Reference graph) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.graph = reference = graph;
                }

                public Object doCall(StageExecution s) {
                    ((StageGraphBuilder)this.graph.get()).add(s);
                    return null;
                }

                public Object call(StageExecution s) {
                    return this.doCall(s);
                }

                @Generated
                public StageGraphBuilder getGraph() {
                    return (StageGraphBuilder)ScriptBytecodeAdapter.castToType((Object)this.graph.get(), StageGraphBuilder.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _beforeStages_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.collect(this.parallelContexts((StageExecution)parent2.get()), (Closure)new _beforeStages_closure1(this, this, parent2)).forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _beforeStages_closure2(this, this, graph2)), Consumer.class));
        }
    }

    private boolean isTopLevelStage(StageExecution stage) {
        return stage.getParentStageId() == null;
    }

    public Collection<Map<String, Object>> parallelContexts(StageExecution stage) {
        Reference stage2 = new Reference((Object)stage);
        CallSite[] callSiteArray = BakeStage.$getCallSiteArray();
        Set deployRegions = (Set)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)((StageExecution)stage2.get())))) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty((Object)((StageExecution)stage2.get())))}) : ScriptBytecodeAdapter.createList((Object[])new Object[0])), Set.class);
        Set set = (Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty((Object)((StageExecution)stage2.get()))), Set.class);
        callSiteArray[4].call((Object)deployRegions, (Object)(DefaultTypeTransformation.booleanUnbox((Object)set) ? set : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
        Boolean skipRegionDetection = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].callGetProperty(Boolean.class), (Object)callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)((StageExecution)stage2.get()))));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call((Object)deployRegions, (Object)"global")) && !DefaultTypeTransformation.booleanUnbox((Object)skipRegionDetection)) {
                callSiteArray[11].call((Object)deployRegions, callSiteArray[12].call((Object)this.regionCollector, (Object)((StageExecution)stage2.get())));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)deployRegions, (Object)"global")) && !DefaultTypeTransformation.booleanUnbox((Object)skipRegionDetection)) {
            callSiteArray[14].call((Object)deployRegions, callSiteArray[15].call((Object)this.regionCollector, (Object)((StageExecution)stage2.get())));
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)log)) ? callSiteArray[17].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[18].callGetProperty(callSiteArray[19].callGetProperty((Object)((StageExecution)stage2.get()))), callSiteArray[20].call((Object)deployRegions, (Object)", ")}, new String[]{"Preparing package `", "` for bake in ", ""})) : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty((Object)((StageExecution)stage2.get()))))) {
            Object object2 = callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call((Object)this.clock), callSiteArray[26].callGetProperty(ZoneOffset.class)), (Object)"yyyyMMddHHmmss");
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[27].callGetProperty((Object)((StageExecution)stage2.get())), (String)"amiSuffix");
        }
        public final class _parallelContexts_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stage;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parallelContexts_closure3(Object _outerInstance, Object _thisObject, Reference stage) {
                Reference reference;
                CallSite[] callSiteArray = _parallelContexts_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.stage = reference = stage;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _parallelContexts_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty(this.stage.get()), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"regions", callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(this.stage.get())), "skipRegionDetection", callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(this.stage.get()))})), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", ScriptBytecodeAdapter.getField(_parallelContexts_closure3.class, BakeStage.class, (String)"PIPELINE_CONFIG_TYPE"), "region", it, "name", (String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(new Object[]{it}, new String[]{"Bake in ", ""}), String.class)}));
            }

            @Generated
            public StageExecution getStage() {
                CallSite[] callSiteArray = _parallelContexts_closure3.$getCallSiteArray();
                return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _parallelContexts_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parallelContexts_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "plus";
                stringArray[1] = "minus";
                stringArray[2] = "context";
                stringArray[3] = "regions";
                stringArray[4] = "context";
                stringArray[5] = "skipRegionDetection";
                stringArray[6] = "context";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _parallelContexts_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parallelContexts_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parallelContexts_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)deployRegions, (Object)new _parallelContexts_closure3(this, this, stage2)), Collection.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BakeStage.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BakeStage.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BakeStage.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BakeStage.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Logger pfaccess$0(BakeStage $that) {
        return log;
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.bakery.pipeline.BakeStage");
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "region";
        stringArray[1] = "context";
        stringArray[2] = "region";
        stringArray[3] = "context";
        stringArray[4] = "addAll";
        stringArray[5] = "regions";
        stringArray[6] = "context";
        stringArray[7] = "TRUE";
        stringArray[8] = "skipRegionDetection";
        stringArray[9] = "context";
        stringArray[10] = "contains";
        stringArray[11] = "addAll";
        stringArray[12] = "getRegionsFromChildStages";
        stringArray[13] = "contains";
        stringArray[14] = "addAll";
        stringArray[15] = "getRegionsFromChildStages";
        stringArray[16] = "isInfoEnabled";
        stringArray[17] = "info";
        stringArray[18] = "package";
        stringArray[19] = "context";
        stringArray[20] = "join";
        stringArray[21] = "amiSuffix";
        stringArray[22] = "context";
        stringArray[23] = "format";
        stringArray[24] = "atZone";
        stringArray[25] = "instant";
        stringArray[26] = "UTC";
        stringArray[27] = "context";
        stringArray[28] = "collect";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[29];
        BakeStage.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BakeStage.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BakeStage.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    @Component
    public static class CompleteParallelBakeTask
    implements Task,
    GroovyObject {
        public static final List<String> DEPLOYMENT_DETAILS_CONTEXT_FIELDS;
        private DynamicConfigService dynamicConfigService;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Autowired
        public CompleteParallelBakeTask(DynamicConfigService dynamicConfigService) {
            DynamicConfigService dynamicConfigService2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.dynamicConfigService = dynamicConfigService2 = dynamicConfigService;
        }

        @Nonnull
        public TaskResult execute(@Nonnull StageExecution stage) {
            Reference stage2 = new Reference((Object)stage);
            public final class _execute_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference stage;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _execute_closure1(Object _outerInstance, Object _thisObject, Reference stage) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.stage = reference = stage;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((StageExecution)it).getType(), (Object)ScriptBytecodeAdapter.getField(_execute_closure1.class, BakeStage.class, (String)"PIPELINE_CONFIG_TYPE")) && ScriptBytecodeAdapter.compareEqual((Object)((StageExecution)this.stage.get()).getId(), (Object)((StageExecution)it).getParentStageId());
                }

                @Generated
                public StageExecution getStage() {
                    return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List relatedBakeStages = DefaultGroovyMethods.findAll((List)((StageExecution)stage2.get()).getExecution().getStages(), (Closure)new _execute_closure1(this, this, stage2));
            public final class _execute_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _execute_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return DefaultTypeTransformation.booleanUnbox(((StageExecution)it).getContext().get("ami")) || DefaultTypeTransformation.booleanUnbox(((StageExecution)it).getContext().get("imageId"));
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _execute_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _execute_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _execute_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(StageExecution bakeStage) {
                    Reference bakeStage2 = new Reference((Object)bakeStage);
                    Reference deploymentDetails = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                    public final class _closure6
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference bakeStage;
                        private /* synthetic */ Reference deploymentDetails;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure6(Object _outerInstance, Object _thisObject, Reference bakeStage, Reference deploymentDetails) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.bakeStage = reference2 = bakeStage;
                            this.deploymentDetails = reference = deploymentDetails;
                        }

                        public Object doCall(Object it) {
                            if (((StageExecution)this.bakeStage.get()).getContext().containsKey(it)) {
                                return ((HashMap)this.deploymentDetails.get()).put(it, ((StageExecution)this.bakeStage.get()).getContext().get(it));
                            }
                            return null;
                        }

                        @Generated
                        public StageExecution getBakeStage() {
                            return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.bakeStage.get(), StageExecution.class);
                        }

                        @Generated
                        public Object getDeploymentDetails() {
                            return this.deploymentDetails.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.each((List)((List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(_execute_closure3.class, CompleteParallelBakeTask.class, (String)"DEPLOYMENT_DETAILS_CONTEXT_FIELDS"), List.class)), (Closure)new _closure6((Object)this, this.getThisObject(), bakeStage2, deploymentDetails));
                    return deploymentDetails.get();
                }

                public Object call(StageExecution bakeStage) {
                    Reference bakeStage2 = new Reference((Object)bakeStage);
                    return this.doCall((StageExecution)bakeStage2.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _execute_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            LinkedHashMap globalContext = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deploymentDetails", DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll((List)relatedBakeStages, (Closure)new _execute_closure2(this, this)), (Closure)new _execute_closure3(this, this))}), LinkedHashMap.class);
            if (this.failOnImageNameMismatchEnabled()) {
                public final class _execute_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference stage;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure4(Object _outerInstance, Object _thisObject, Reference stage) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.stage = reference = stage;
                    }

                    public Object doCall(Object childStage) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((StageExecution)childStage).getParentStageId(), (Object)((StageExecution)this.stage.get()).getId()) && DefaultTypeTransformation.booleanUnbox(((StageExecution)childStage).getContext().get("imageName"));
                    }

                    @Generated
                    public StageExecution getStage() {
                        return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _execute_closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure5(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object childStage) {
                        return ((StageExecution)childStage).getContext().get("imageName");
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                List distinctImageNames = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.findAll((List)relatedBakeStages, (Closure)new _execute_closure4(this, this, stage2)).stream().map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _execute_closure5(this, this)), Function.class)).distinct().collect(Collectors.toList()), List.class);
                if (distinctImageNames.size() > 1) {
                    throw (Throwable)new ConstraintViolationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Joiner.on((String)", ").join((Iterable)distinctImageNames)}, new String[]{"Image names found in different regions do not match: ", ". "}).plus("Re-run the bake to protect against deployment failures.")));
                }
            }
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).outputs((Map)globalContext).build();
        }

        private boolean failOnImageNameMismatchEnabled() {
            boolean bl = this.dynamicConfigService.isEnabled("stages.bake.failOnImageNameMismatch", false);
            try {
                return bl;
            }
            catch (Exception e) {
                ((Logger)ScriptBytecodeAdapter.getField(CompleteParallelBakeTask.class, BakeStage.class, (String)"log")).error("Unable to retrieve config value for stages.bake.failOnImageNameMismatch. Assuming false.", (Throwable)e);
                boolean bl2 = false;
                return bl2;
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CompleteParallelBakeTask.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CompleteParallelBakeTask.class, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CompleteParallelBakeTask.class, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CompleteParallelBakeTask.class, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CompleteParallelBakeTask.class, BakeStage.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        static {
            List list;
            DEPLOYMENT_DETAILS_CONTEXT_FIELDS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"ami", "amiName", "imageId", "imageName", "amiSuffix", "baseLabel", "baseOs", "refId", "storeType", "vmType", "region", "package", "cloudProviderType", "cloudProvider", "baseAmiId"});
        }

        @Generated
        public DynamicConfigService getDynamicConfigService() {
            return this.dynamicConfigService;
        }

        @Generated
        public void setDynamicConfigService(DynamicConfigService dynamicConfigService) {
            this.dynamicConfigService = dynamicConfigService;
        }
    }
}

