/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.tasks.manifests;

import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.artifacts.model.ExpectedArtifact;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.api.manifests.BakeManifestRequest;
import com.netflix.spinnaker.orca.bakery.api.manifests.helm.HelmBakeManifestRequest;
import com.netflix.spinnaker.orca.bakery.api.manifests.kustomize.KustomizeBakeManifestRequest;
import com.netflix.spinnaker.orca.bakery.tasks.manifests.BakeManifestContext;
import com.netflix.spinnaker.orca.pipeline.util.ArtifactUtils;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateBakeManifestTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(CreateBakeManifestTask.class);
    @Nullable
    private final BakeryService bakery;
    private final ArtifactUtils artifactUtils;
    private final ContextParameterProcessor contextParameterProcessor;

    public long getBackoffPeriod() {
        return 30000L;
    }

    public long getTimeout() {
        return 300000L;
    }

    @Autowired
    public CreateBakeManifestTask(ArtifactUtils artifactUtils, ContextParameterProcessor contextParameterProcessor, Optional<BakeryService> bakery) {
        this.artifactUtils = artifactUtils;
        this.contextParameterProcessor = contextParameterProcessor;
        this.bakery = bakery.orElse(null);
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        BakeManifestRequest request;
        if (this.bakery == null) {
            throw new IllegalStateException("A BakeryService must be configured in order to run a Bake Manifest task.");
        }
        BakeManifestContext context = (BakeManifestContext)stage.mapTo(BakeManifestContext.class);
        List<InputArtifact> inputArtifacts = context.getInputArtifacts();
        if (inputArtifacts.isEmpty()) {
            throw new IllegalArgumentException("At least one input artifact to bake must be supplied");
        }
        List<Artifact> resolvedInputArtifacts = inputArtifacts.stream().map(p -> {
            Artifact a = this.artifactUtils.getBoundArtifactForStage(stage, p.getId(), p.getArtifact());
            if (a == null) {
                throw new IllegalArgumentException(String.format("Input artifact (id: %s, account: %s) could not be found in execution (id: %s).", p.getId(), p.getAccount(), stage.getExecution().getId()));
            }
            return ArtifactUtils.withAccount((Artifact)a, (String)p.getAccount());
        }).collect(Collectors.toList());
        List<ExpectedArtifact> expectedArtifacts = context.getExpectedArtifacts();
        if (expectedArtifacts.size() != 1) {
            throw new IllegalArgumentException("The Bake (Manifest) stage produces one embedded base64 artifact.  Please ensure that your Bake (Manifest) stage config's `Produces Artifacts` section (`expectedArtifacts` field) contains exactly one artifact.");
        }
        String outputArtifactName = expectedArtifacts.get(0).getMatchArtifact().getName();
        Map overrides = context.getOverrides();
        Boolean evaluateOverrideExpressions = context.getEvaluateOverrideExpressions();
        if (evaluateOverrideExpressions != null && evaluateOverrideExpressions.booleanValue()) {
            overrides = this.contextParameterProcessor.process(overrides, (Map)this.contextParameterProcessor.buildExecutionContext(stage), true);
        }
        switch (context.getTemplateRenderer().toUpperCase()) {
            case "HELM3": 
            case "HELM2": {
                request = new HelmBakeManifestRequest(context, resolvedInputArtifacts, outputArtifactName, overrides);
                break;
            }
            case "KUSTOMIZE": 
            case "KUSTOMIZE4": {
                Artifact inputArtifact = (Artifact)resolvedInputArtifacts.get(0);
                request = new KustomizeBakeManifestRequest(context, inputArtifact, outputArtifactName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid template renderer " + context.getTemplateRenderer());
            }
        }
        Artifact result = this.bakery.bakeManifest(request.getTemplateRenderer(), request);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("artifacts", Collections.singleton(result));
        outputs.put("cloudProvider", "kubernetes");
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).outputs(outputs).build();
    }

    static class InputArtifact {
        String id;
        String account;
        Artifact artifact;

        public String getId() {
            return this.id;
        }

        public String getAccount() {
            return this.account;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputArtifact)) {
                return false;
            }
            InputArtifact other = (InputArtifact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            Artifact this$artifact = this.getArtifact();
            Artifact other$artifact = other.getArtifact();
            return !(this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputArtifact;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            Artifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
            return result;
        }

        public String toString() {
            return "CreateBakeManifestTask.InputArtifact(id=" + this.getId() + ", account=" + this.getAccount() + ", artifact=" + this.getArtifact() + ")";
        }
    }
}

