/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.tasks.manifests.cf;

import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.artifacts.model.ExpectedArtifact;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.api.manifests.cf.BakeCloudFoundryManifestRequest;
import com.netflix.spinnaker.orca.bakery.tasks.manifests.cf.BakeCloudFoundryManifestContext;
import com.netflix.spinnaker.orca.pipeline.util.ArtifactUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BakeCloudFoundryManifestTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(BakeCloudFoundryManifestTask.class);
    @Nullable
    private final BakeryService bakery;
    private final ArtifactUtils artifactUtils;

    @Autowired
    public BakeCloudFoundryManifestTask(ArtifactUtils artifactUtils, Optional<BakeryService> bakery) {
        this.artifactUtils = artifactUtils;
        this.bakery = bakery.orElse(null);
    }

    public long getBackoffPeriod() {
        return 30000L;
    }

    public long getTimeout() {
        return 300000L;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        if (this.bakery == null) {
            throw new IllegalStateException("A BakeryService must be configured in order to run a Bake Manifest task.");
        }
        BakeCloudFoundryManifestContext context = (BakeCloudFoundryManifestContext)stage.mapTo(BakeCloudFoundryManifestContext.class);
        if (context.getInputArtifacts() == null || context.getInputArtifacts().size() < 2) {
            throw new IllegalArgumentException("There must be one manifest template and at least one variables artifact supplied");
        }
        List resolvedInputArtifacts = context.getInputArtifacts().stream().map(p -> {
            Artifact a = this.artifactUtils.getBoundArtifactForStage(stage, p.getId(), p.getArtifact());
            if (a == null) {
                throw new IllegalArgumentException(String.format("Input artifact (id: %s, account: %s) could not be found in execution (id: %s).", p.getId(), p.getAccount(), stage.getExecution().getId()));
            }
            return ArtifactUtils.withAccount((Artifact)a, (String)p.getAccount());
        }).collect(Collectors.toList());
        if (context.getExpectedArtifacts() == null || context.getExpectedArtifacts().size() > 1) {
            throw new IllegalArgumentException("The CreateCloudFoundryManifest stage produces one embedded base64 artifact.  Please ensure that your stage config's `Produces Artifacts` section (`expectedArtifacts` field) contains exactly one artifact.");
        }
        ExpectedArtifact expectedArtifacts = context.getExpectedArtifacts().get(0);
        String outputArtifactName = expectedArtifacts.getMatchArtifact().getName();
        if (context.getOutputName() == null || !context.getOutputName().equals(outputArtifactName)) {
            throw new IllegalArgumentException("The name of the output manifest is required and it must match the artifact name in the Produces Artifact section.");
        }
        BakeCloudFoundryManifestRequest request = new BakeCloudFoundryManifestRequest(context, (Artifact)resolvedInputArtifacts.get(0), resolvedInputArtifacts.subList(1, resolvedInputArtifacts.size()), outputArtifactName);
        Artifact result = this.bakery.bakeManifest(request.getTemplateRenderer(), request);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("artifacts", Collections.singleton(result));
        outputs.put("cloudProvider", "cloudfoundry");
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).outputs(outputs).build();
    }

    static class InputArtifact {
        String id;
        String account;
        Artifact artifact;

        public String getId() {
            return this.id;
        }

        public String getAccount() {
            return this.account;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputArtifact)) {
                return false;
            }
            InputArtifact other = (InputArtifact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            Artifact this$artifact = this.getArtifact();
            Artifact other$artifact = other.getArtifact();
            return !(this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputArtifact;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            Artifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
            return result;
        }

        public String toString() {
            return "BakeCloudFoundryManifestTask.InputArtifact(id=" + this.getId() + ", account=" + this.getAccount() + ", artifact=" + this.getArtifact() + ")";
        }
    }
}

