/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.pipeline;

import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.api.DeleteBakesRequest;
import com.netflix.spinnaker.orca.notifications.scheduling.PipelineDependencyCleanupOperator;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${bakery-pipeline-dependency-cleanup.enabled:false}")
public class BakeryPipelineDependencyCleanupOperator
implements PipelineDependencyCleanupOperator {
    private final BakeryService bakeryService;

    public void cleanup(List<String> pipelineExecutionIds) {
        DeleteBakesRequest deleteBakesRequest = new DeleteBakesRequest();
        deleteBakesRequest.setPipelineExecutionIds(pipelineExecutionIds);
        this.bakeryService.createDeleteBakesRequest(deleteBakesRequest);
    }

    public BakeryPipelineDependencyCleanupOperator(BakeryService bakeryService) {
        this.bakeryService = bakeryService;
    }
}

