/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.web.selector.v2.SelectableService;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.bakery.BakerySelector;
import com.netflix.spinnaker.orca.bakery.api.BakeRequest;
import com.netflix.spinnaker.orca.bakery.api.BakeStatus;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.Application;
import com.netflix.spinnaker.orca.pipeline.util.ArtifactUtils;
import com.netflix.spinnaker.orca.pipeline.util.OperatingSystem;
import com.netflix.spinnaker.orca.pipeline.util.PackageInfo;
import com.netflix.spinnaker.orca.pipeline.util.PackageType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Component
public class CreateBakeTask
implements RetryableTask,
GroovyObject {
    private long backoffPeriod;
    private long timeout;
    @Autowired
    private ArtifactUtils artifactUtils;
    @Autowired(required=false)
    private BakerySelector bakerySelector;
    @Autowired
    private ObjectMapper mapper;
    @Autowired(required=false)
    private Front50Service front50Service;
    private RetrySupport retrySupport;
    private final Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public CreateBakeTask() {
        MetaClass metaClass;
        Logger logger;
        RetrySupport retrySupport;
        int n = 30000;
        this.backoffPeriod = n;
        int n2 = 300000;
        this.timeout = n2;
        this.retrySupport = retrySupport = new RetrySupport();
        this.log = logger = LoggerFactory.getLogger(this.getClass());
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TaskResult execute(StageExecution stage) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.bakerySelector)) {
            throw (Throwable)new UnsupportedOperationException("You have not enabled baking for this orca instance. Set bakery.enabled: true");
        }
        SelectableService.SelectedService<BakeryService> bakery = this.bakerySelector.select(stage);
        try {
            if (this.front50Service != null) {
                Reference appName = new Reference((Object)stage.getExecution().getApplication());
                public final class _execute_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference appName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure1(Object _outerInstance, Object _thisObject, Reference appName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.appName = reference = appName;
                    }

                    public Object doCall(Object it) {
                        return ((CreateBakeTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), CreateBakeTask.class)).getFront50Service().get(ShortTypeHandling.castToString((Object)this.appName.get()));
                    }

                    @Generated
                    public String getAppName() {
                        return ShortTypeHandling.castToString((Object)this.appName.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Application application = (Application)ScriptBytecodeAdapter.castToType((Object)this.retrySupport.retry((Supplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _execute_closure1(this, this, appName)), Supplier.class), 5, (long)2000, false), Application.class);
                String user = application.email;
                if (user != null && ScriptBytecodeAdapter.compareNotEqual((Object)user, (Object)"")) {
                    String string = user;
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)stage.getContext(), (String)"user");
                }
            }
        }
        catch (RetrofitError e) {
            if (!e.getMessage().contains("404")) {
                this.log.warn("Error retrieving application {} from front50, ignoring.", (Object)stage.getExecution().getApplication(), (Object)e);
            }
        }
        BakeRequest bake = this.bakeFromContext(stage, bakery);
        String rebake = ShortTypeHandling.castToString((Object)(CreateBakeTask.shouldRebake(stage) ? "1" : null));
        if (stage.getContext().get("amiSuffix") != null && bake.getAmiSuffix() != null && ScriptBytecodeAdapter.compareNotEqual((Object)bake.getAmiSuffix(), stage.getContext().get("amiSuffix"))) {
            this.log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bake.getAmiSuffix(), stage.getContext().get("amiSuffix")}, new String[]{"Bake request amiSuffix ", " differs from stage context amiSuffix ", ", resolving..."})));
            Object v = stage.getContext().get("amiSuffix");
            bake.setAmiSuffix(ShortTypeHandling.castToString(v));
        }
        BakeStatus bakeStatus = ((BakeryService)bakery.getService()).createBake((String)ScriptBytecodeAdapter.asType(stage.getContext().get("region"), String.class), bake, rebake);
        String string = bake.getPackageName();
        Map stageOutputs = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"status", bakeStatus, "bakePackageName", DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", "previouslyBaked", ScriptBytecodeAdapter.compareEqual((Object)((Object)bakeStatus.getState()), (Object)((Object)BakeStatus.State.COMPLETED))});
        if (DefaultTypeTransformation.booleanUnbox((Object)bake.getBuildInfoUrl())) {
            String string2 = bake.getBuildInfoUrl();
            ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)stageOutputs, (String)"buildInfoUrl");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)bake.getBuildHost())) {
            DefaultGroovyMethods.leftShift((Map)stageOutputs, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"buildHost", bake.getBuildHost(), "job", bake.getJob(), "buildNumber", bake.getBuildNumber()}));
            if (DefaultTypeTransformation.booleanUnbox((Object)bake.getCommitHash())) {
                String string3 = bake.getCommitHash();
                ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)stageOutputs, (String)"commitHash");
            }
        }
        TaskResult taskResult = TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(stageOutputs).build();
        try {
            return taskResult;
        }
        catch (RetrofitError e) {
            Response response = e.getResponse();
            if (!(DefaultTypeTransformation.booleanUnbox(response != null ? Integer.valueOf(response.getStatus()) : null) && e.getResponse().getStatus() == 404)) throw (Throwable)e;
            try {
                Map exceptionResult = (Map)ScriptBytecodeAdapter.castToType((Object)this.mapper.readValue(IOGroovyMethods.getText((InputStream)e.getResponse().getBody().in()), Map.class), Map.class);
                Object v = exceptionResult.get("messages");
                List exceptionMessages = (List)ScriptBytecodeAdapter.asType(DefaultTypeTransformation.booleanUnbox(v) ? v : ScriptBytecodeAdapter.createList((Object[])new Object[0]), List.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)exceptionMessages)) {
                    throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)exceptionMessages, (int)0)));
                }
            }
            catch (IOException ignored) {
            }
            TaskResult taskResult2 = TaskResult.ofStatus((ExecutionStatus)ExecutionStatus.RUNNING);
            return taskResult2;
        }
    }

    private static boolean shouldRebake(StageExecution stage) {
        if (ScriptBytecodeAdapter.compareEqual(stage.getContext().get("rebake"), (Object)true)) {
            return true;
        }
        Trigger trigger = stage.getExecution().getTrigger();
        return DefaultTypeTransformation.booleanUnbox(trigger != null ? Boolean.valueOf(trigger.isRebake()) : null);
    }

    private BakeRequest bakeFromContext(StageExecution stage, SelectableService.SelectedService<BakeryService> bakery) {
        PackageType packageType;
        Reference stage2 = new Reference((Object)stage);
        PackageType packageType2 = null;
        packageType2 = packageType = ((StageExecution)stage2.get()).getContext().get("baseOs") != null ? CreateBakeTask.getBaseOsPackageType(bakery, (StageExecution)stage2.get()) : CreateBakeTask.getCustomPackageType((StageExecution)stage2.get());
        PackageType packageType3 = packageType2;
        ScriptBytecodeAdapter.setProperty((Object)packageType3, null, (Object)((StageExecution)stage2.get()).getContext(), (String)"packageType");
        List artifacts = this.artifactUtils.getAllArtifacts(((StageExecution)stage2.get()).getExecution());
        PackageInfo packageInfo = new PackageInfo((StageExecution)stage2.get(), artifacts, packageType2.getPackageType(), packageType2.getVersionDelimiter(), DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.asType(bakery.getConfig().get("extractBuildDetails"), Boolean.class))), false, this.mapper);
        Map requestMap = packageInfo.findTargetPackage(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.asType(bakery.getConfig().get("allowMissingPackageInstallation"), Boolean.class))));
        if (DefaultTypeTransformation.booleanUnbox(((StageExecution)stage2.get()).getContext().get("account"))) {
            String string = (String)ScriptBytecodeAdapter.asType(((StageExecution)stage2.get()).getContext().get("account"), String.class);
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)requestMap, (String)"accountName");
        }
        public final class _bakeFromContext_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stage;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _bakeFromContext_closure2(Object _outerInstance, Object _thisObject, Reference stage) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.stage = reference = stage;
            }

            public Object doCall(String artifactId) {
                return ((CreateBakeTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), CreateBakeTask.class)).getArtifactUtils().getBoundArtifactForId((StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class), artifactId);
            }

            @Generated
            public Object call(String artifactId) {
                return this.doCall(artifactId);
            }

            @Generated
            public StageExecution getStage() {
                return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bakeFromContext_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list = DefaultGroovyMethods.collect(((StageExecution)stage2.get()).getContext().get("packageArtifactIds"), (Closure)new _bakeFromContext_closure2(this, this, stage2));
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)requestMap, (String)"packageArtifacts");
        if (ScriptBytecodeAdapter.compareEqual((Object)"docker", requestMap.get("storeType"))) {
            requestMap.remove("baseOs");
        }
        if (ScriptBytecodeAdapter.compareEqual(requestMap.get("baseName"), (Object)"")) {
            requestMap.remove("baseName");
        }
        if (((StageExecution)stage2.get()).getContext().get("baseOs") == null) {
            String string = (String)ScriptBytecodeAdapter.asType(((StageExecution)stage2.get()).getContext().get("managedImage"), String.class);
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)requestMap, (String)"custom_managed_image_name");
            if (((StageExecution)stage2.get()).getContext().get("managedImage") == null) {
                String string2 = (String)ScriptBytecodeAdapter.asType(((StageExecution)stage2.get()).getContext().get("sku"), String.class);
                ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)requestMap, (String)"sku");
                String string3 = (String)ScriptBytecodeAdapter.asType(((StageExecution)stage2.get()).getContext().get("offer"), String.class);
                ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)requestMap, (String)"offer");
                String string4 = (String)ScriptBytecodeAdapter.asType(((StageExecution)stage2.get()).getContext().get("publisher"), String.class);
                ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)requestMap, (String)"publisher");
            }
        }
        BakeRequest request = (BakeRequest)ScriptBytecodeAdapter.castToType((Object)this.mapper.convertValue((Object)requestMap, BakeRequest.class), BakeRequest.class);
        if (!DefaultTypeTransformation.booleanUnbox(bakery.getConfig().get("roscoApisEnabled"))) {
            request.other().clear();
        }
        return request;
    }

    private static PackageType getCustomPackageType(StageExecution stage) {
        if (ScriptBytecodeAdapter.compareNotEqual(stage.getContext().get("osType"), (Object)"linux")) {
            return PackageType.NUPKG;
        }
        PackageType type = (PackageType)ScriptBytecodeAdapter.asType(stage.getContext().get("packageType"), PackageType.class);
        if (type == null) {
            PackageType packageType;
            type = packageType = new OperatingSystem((String)ScriptBytecodeAdapter.asType(stage.getContext().get("managedImage"), String.class)).getPackageType();
        }
        return type;
    }

    private static PackageType getBaseOsPackageType(SelectableService.SelectedService<BakeryService> bakery, StageExecution stage) {
        return DefaultTypeTransformation.booleanUnbox(bakery.getConfig().get("roscoApisEnabled")) ? ((BakeryService)bakery.getService()).getBaseImage((String)ScriptBytecodeAdapter.asType(stage.getContext().get("cloudProviderType"), String.class), (String)ScriptBytecodeAdapter.asType(stage.getContext().get("baseOs"), String.class)).getPackageType() : new OperatingSystem((String)ScriptBytecodeAdapter.asType(stage.getContext().get("baseOs"), String.class)).getPackageType();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreateBakeTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ ArtifactUtils pfaccess$0(CreateBakeTask $that) {
        return $that.getArtifactUtils();
    }

    public static /* synthetic */ Front50Service pfaccess$1(CreateBakeTask $that) {
        return $that.getFront50Service();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public long getBackoffPeriod() {
        return this.backoffPeriod;
    }

    @Generated
    public void setBackoffPeriod(long l) {
        this.backoffPeriod = l;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Generated
    public ArtifactUtils getArtifactUtils() {
        return this.artifactUtils;
    }

    @Generated
    public void setArtifactUtils(ArtifactUtils artifactUtils) {
        this.artifactUtils = artifactUtils;
    }

    @Generated
    public BakerySelector getBakerySelector() {
        return this.bakerySelector;
    }

    @Generated
    public void setBakerySelector(BakerySelector bakerySelector) {
        this.bakerySelector = bakerySelector;
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public void setMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    @Generated
    public RetrySupport getRetrySupport() {
        return this.retrySupport;
    }

    @Generated
    public void setRetrySupport(RetrySupport retrySupport) {
        this.retrySupport = retrySupport;
    }
}

