/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.bakery.tasks;

import com.netflix.spinnaker.kork.web.selector.v2.SelectableService;
import com.netflix.spinnaker.orca.api.pipeline.OverridableTimeoutRetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.bakery.BakerySelector;
import com.netflix.spinnaker.orca.bakery.api.BakeStatus;
import com.netflix.spinnaker.orca.bakery.api.BakeryService;
import com.netflix.spinnaker.orca.bakery.tasks.CreateBakeTask;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Component
public class MonitorBakeTask
implements OverridableTimeoutRetryableTask,
GroovyObject {
    private long backoffPeriod;
    @Value(value="${tasks.monitor-bake.timeout-millis:3600000}")
    private long timeout;
    @Autowired(required=false)
    private BakerySelector bakerySelector;
    @Autowired
    private CreateBakeTask createBakeTask;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public MonitorBakeTask() {
        MetaClass metaClass;
        int n = 30000;
        this.backoffPeriod = n;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskResult execute(StageExecution stage) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.bakerySelector)) {
            throw (Throwable)new UnsupportedOperationException("You have not enabled baking for this orca instance. Set bakery.enabled: true");
        }
        String region = (String)ScriptBytecodeAdapter.asType(stage.getContext().get("region"), String.class);
        BakeStatus previousStatus = (BakeStatus)ScriptBytecodeAdapter.asType(stage.getContext().get("status"), BakeStatus.class);
        try {
            Object v0;
            SelectableService.SelectedService<BakeryService> bakery = this.bakerySelector.select(stage);
            BakeStatus newStatus = ((BakeryService)bakery.getService()).lookupStatus(region, previousStatus.getId());
            if (!(MonitorBakeTask.isCanceled(newStatus.getState()) && ScriptBytecodeAdapter.compareEqual((Object)((Object)previousStatus.getState()), (Object)((Object)BakeStatus.State.PENDING)))) return TaskResult.builder((ExecutionStatus)MonitorBakeTask.mapStatus(newStatus)).context(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"status", newStatus})).build();
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stage.getExecution().getId(), previousStatus.getState()}, new String[]{"Original bake was 'canceled', re-baking (executionId: ", ", previousStatus: ", ")"})));
                v0 = null;
            } else {
                v0 = null;
            }
            TaskResult rebakeResult = this.createBakeTask.execute(stage);
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.RUNNING).context(rebakeResult.getContext()).outputs(rebakeResult.getOutputs()).build();
        }
        catch (RetrofitError e) {
            Object v1;
            if (log.isErrorEnabled()) {
                log.error("Monitor Error {}", (Object)e.getMessage());
                v1 = null;
            } else {
                v1 = null;
            }
            Response response = e.getResponse();
            if (!ScriptBytecodeAdapter.compareEqual((Object)(response != null ? Integer.valueOf(response.getStatus()) : null), (Object)404)) throw (Throwable)e;
            return TaskResult.ofStatus((ExecutionStatus)ExecutionStatus.RUNNING);
        }
    }

    public static boolean isCanceled(BakeStatus.State state) {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{BakeStatus.State.CANCELED, BakeStatus.State.CANCELLED}).contains((Object)state);
    }

    private static ExecutionStatus mapStatus(BakeStatus newStatus) {
        BakeStatus.State state = newStatus.getState();
        if (ScriptBytecodeAdapter.isCase((Object)((Object)state), (Object)((Object)BakeStatus.State.COMPLETED))) {
            return ScriptBytecodeAdapter.compareEqual((Object)((Object)newStatus.getResult()), (Object)((Object)BakeStatus.Result.SUCCESS)) ? ExecutionStatus.SUCCEEDED : ExecutionStatus.TERMINAL;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)state), (Object)((Object)BakeStatus.State.CANCELED))) {
            return ExecutionStatus.TERMINAL;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)state), (Object)((Object)BakeStatus.State.CANCELLED))) {
            return ExecutionStatus.TERMINAL;
        }
        return ExecutionStatus.RUNNING;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MonitorBakeTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.bakery.tasks.MonitorBakeTask");
    }

    @Generated
    public long getBackoffPeriod() {
        return this.backoffPeriod;
    }

    @Generated
    public void setBackoffPeriod(long l) {
        this.backoffPeriod = l;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Generated
    public BakerySelector getBakerySelector() {
        return this.bakerySelector;
    }

    @Generated
    public void setBakerySelector(BakerySelector bakerySelector) {
        this.bakerySelector = bakerySelector;
    }

    @Generated
    public CreateBakeTask getCreateBakeTask() {
        return this.createBakeTask;
    }

    @Generated
    public void setCreateBakeTask(CreateBakeTask createBakeTask) {
        this.createBakeTask = createBakeTask;
    }
}

