/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.config.DryRunProperties;
import com.netflix.spinnaker.orca.StageResolver;
import com.netflix.spinnaker.orca.dryrun.DryRunStageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"dryrun.enabled"})
@ComponentScan(value={"com.netflix.spinnaker.orca.dryrun"})
@EnableConfigurationProperties(value={DryRunProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/config/DryRunConfiguration;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dryRunStageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "stageResolver", "Lcom/netflix/spinnaker/orca/StageResolver;", "orca-dry-run"})
public class DryRunConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Bean
    @NotNull
    public StageDefinitionBuilderFactory dryRunStageDefinitionBuilderFactory(@NotNull StageResolver stageResolver) {
        Intrinsics.checkNotNullParameter((Object)stageResolver, (String)"stageResolver");
        this.log.info("Dry run trigger support enabled");
        return (StageDefinitionBuilderFactory)new DryRunStageDefinitionBuilderFactory(stageResolver);
    }
}

