/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.dryrun;

import com.netflix.spinnaker.orca.StageResolver;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.dryrun.DryRunStage;
import com.netflix.spinnaker.orca.pipeline.DefaultStageDefinitionBuilderFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0018\u0010\n\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001e\u0010\u000b\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\bR\u0018\u0010\u000e\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0018\u0010\u0010\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0018\u0010\u0011\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0018\u0010\u0012\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0018\u0010\u0013\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0018\u0010\u0014\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/orca/dryrun/DryRunStageDefinitionBuilderFactory;", "Lcom/netflix/spinnaker/orca/pipeline/DefaultStageDefinitionBuilderFactory;", "stageResolver", "Lcom/netflix/spinnaker/orca/StageResolver;", "(Lcom/netflix/spinnaker/orca/StageResolver;)V", "isDetermineTargetServerGroup", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Z", "isEvalVariables", "isExpressionChild", "isExpressionParent", "isExpressionParent$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)V", "isExpressionPrecondition", "isFindImage", "isManualJudgment", "isPipeline", "isPreconditionStage", "isRollbackCluster", "shouldExecuteNormallyInDryRun", "getShouldExecuteNormallyInDryRun", "builderFor", "Lcom/netflix/spinnaker/orca/api/pipeline/graph/StageDefinitionBuilder;", "stage", "orca-dry-run"})
public final class DryRunStageDefinitionBuilderFactory
extends DefaultStageDefinitionBuilderFactory {
    @NotNull
    public StageDefinitionBuilder builderFor(@NotNull StageExecution stage) {
        StageDefinitionBuilder stageDefinitionBuilder;
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        PipelineExecution pipelineExecution = stage.getExecution();
        boolean bl = false;
        boolean bl2 = false;
        PipelineExecution execution = pipelineExecution;
        boolean bl3 = false;
        StageDefinitionBuilder stageDefinitionBuilder2 = super.builderFor(stage);
        boolean bl4 = false;
        boolean bl5 = false;
        StageDefinitionBuilder it = stageDefinitionBuilder2;
        boolean bl6 = false;
        PipelineExecution pipelineExecution2 = execution;
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"execution");
        Trigger trigger = pipelineExecution2.getTrigger();
        Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"execution.trigger");
        if (!trigger.isDryRun() || this.getShouldExecuteNormallyInDryRun(stage)) {
            stageDefinitionBuilder = it;
        } else {
            StageDefinitionBuilder stageDefinitionBuilder3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageDefinitionBuilder3, (String)"it");
            stageDefinitionBuilder = new DryRunStage(stageDefinitionBuilder3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)stageDefinitionBuilder, (String)"if (!execution.trigger.i\u2026DryRunStage(it)\n        }");
        Intrinsics.checkNotNullExpressionValue((Object)stageDefinitionBuilder, (String)"stage.execution.let { ex\u2026)\n        }\n      }\n    }");
        return stageDefinitionBuilder;
    }

    private final boolean getShouldExecuteNormallyInDryRun(StageExecution $this$shouldExecuteNormallyInDryRun) {
        return this.isManualJudgment($this$shouldExecuteNormallyInDryRun) || this.isPipeline($this$shouldExecuteNormallyInDryRun) || this.isExpressionPrecondition($this$shouldExecuteNormallyInDryRun) || this.isFindImage($this$shouldExecuteNormallyInDryRun) || this.isDetermineTargetServerGroup($this$shouldExecuteNormallyInDryRun) || this.isRollbackCluster($this$shouldExecuteNormallyInDryRun) || this.isEvalVariables($this$shouldExecuteNormallyInDryRun);
    }

    private final boolean isManualJudgment(StageExecution $this$isManualJudgment) {
        return Intrinsics.areEqual((Object)$this$isManualJudgment.getType(), (Object)"manualJudgment");
    }

    private final boolean isPipeline(StageExecution $this$isPipeline) {
        return Intrinsics.areEqual((Object)$this$isPipeline.getType(), (Object)"pipeline");
    }

    private final boolean isFindImage(StageExecution $this$isFindImage) {
        return SetsKt.setOf((Object[])new String[]{"findImage", "findImageFromTags"}).contains($this$isFindImage.getType());
    }

    private final boolean isDetermineTargetServerGroup(StageExecution $this$isDetermineTargetServerGroup) {
        return Intrinsics.areEqual((Object)$this$isDetermineTargetServerGroup.getType(), (Object)"determineTargetServerGroup");
    }

    private final boolean isExpressionPrecondition(StageExecution $this$isExpressionPrecondition) {
        return this.isPreconditionStage($this$isExpressionPrecondition) && (this.isExpressionChild($this$isExpressionPrecondition) || this.isExpressionParent($this$isExpressionPrecondition));
    }

    private final boolean isPreconditionStage(StageExecution $this$isPreconditionStage) {
        return Intrinsics.areEqual((Object)$this$isPreconditionStage.getType(), (Object)"checkPreconditions");
    }

    private final boolean isExpressionChild(StageExecution $this$isExpressionChild) {
        return Intrinsics.areEqual($this$isExpressionChild.getContext().get("preconditionType"), (Object)"expression");
    }

    private static /* synthetic */ void isExpressionParent$annotations(StageExecution stageExecution) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExpressionParent(StageExecution $this$isExpressionParent) {
        Map it;
        Iterable iterable = (Iterable)$this$isExpressionParent.getContext().get("preconditions");
        if (iterable == null) return false;
        Iterable iterable2 = iterable;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$run = iterable2;
        boolean bl3 = false;
        Iterable $this$all$iv = $this$run;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Map)element$iv;
            boolean bl4 = false;
        } while (Intrinsics.areEqual(it.get("type"), (Object)"expression"));
        return false;
    }

    private final boolean isRollbackCluster(StageExecution $this$isRollbackCluster) {
        return Intrinsics.areEqual((Object)$this$isRollbackCluster.getType(), (Object)"rollbackCluster");
    }

    private final boolean isEvalVariables(StageExecution $this$isEvalVariables) {
        return Intrinsics.areEqual((Object)$this$isEvalVariables.getType(), (Object)"evaluateVariables");
    }

    public DryRunStageDefinitionBuilderFactory(@NotNull StageResolver stageResolver) {
        Intrinsics.checkNotNullParameter((Object)stageResolver, (String)"stageResolver");
        super(stageResolver);
    }
}

