/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.dryrun;

import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.dryrun.stub.OutputStub;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\fH\u0012R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/orca/dryrun/DryRunTask;", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "outputStubs", "", "Lcom/netflix/spinnaker/orca/dryrun/stub/OutputStub;", "(Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "Lcom/netflix/spinnaker/orca/api/pipeline/TaskResult;", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "generateOutputs", "", "", "", "orca-dry-run"})
public class DryRunTask
implements Task {
    private final Logger log;
    private final List<OutputStub> outputStubs;

    @NotNull
    public TaskResult execute(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Map<String, Object> map = this.generateOutputs(stage);
        boolean bl = false;
        boolean bl2 = false;
        Map<String, Object> outputs = map;
        boolean bl3 = false;
        PipelineExecution pipelineExecution = stage.getExecution();
        boolean bl4 = false;
        boolean bl5 = false;
        PipelineExecution execution = pipelineExecution;
        boolean bl6 = false;
        StringBuilder stringBuilder = new StringBuilder().append("Dry run of ");
        PipelineExecution pipelineExecution2 = execution;
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"execution");
        this.log.info(stringBuilder.append(pipelineExecution2.getApplication()).append(' ').append(execution.getName()).append(' ').append(execution.getId()).append(" stage ").append(stage.getType()).append(' ').append(stage.getRefId()).append(" outputting ").append(outputs).toString());
        TaskResult taskResult = TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).outputs(outputs).build();
        Intrinsics.checkNotNullExpressionValue((Object)taskResult, (String)"stage.generateOutputs().\u2026ts(outputs).build()\n    }");
        return taskResult;
    }

    private Map<String, Object> generateOutputs(StageExecution $this$generateOutputs) {
        Map<String, Object> map;
        Object v0;
        block2: {
            Iterable iterable = this.outputStubs;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                OutputStub it = (OutputStub)t;
                boolean bl3 = false;
                if (!it.supports($this$generateOutputs)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((map = (OutputStub)v0) == null || (map = map.outputs($this$generateOutputs)) == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public DryRunTask(@NotNull List<? extends OutputStub> outputStubs) {
        Intrinsics.checkNotNullParameter(outputStubs, (String)"outputStubs");
        this.outputStubs = outputStubs;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

