/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.dryrun.stub;

import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.dryrun.stub.OutputStub;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/orca/dryrun/stub/TitusRunJobOutputStub;", "Lcom/netflix/spinnaker/orca/dryrun/stub/OutputStub;", "()V", "outputs", "", "", "", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "supports", "", "orca-dry-run"})
public class TitusRunJobOutputStub
implements OutputStub {
    @Override
    public boolean supports(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return Intrinsics.areEqual((Object)stage.getType(), (Object)"runJob") && Intrinsics.areEqual(stage.getContext().get("cloudProvider"), (Object)"titus");
    }

    @Override
    @NotNull
    public Map<String, Object> outputs(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        PipelineExecution pipelineExecution = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
        String app = pipelineExecution.getApplication();
        Object account = stage.getContext().get("credentials");
        Object v = stage.getContext().get("cluster");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        Map cluster = (Map)v;
        Object region = cluster.get("region");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String jobId = string;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
        String taskId = string2;
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"UUID.randomUUID().toString()");
        String instanceId = string3;
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jobStatus", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)jobId), TuplesKt.to((Object)"name", (Object)(app + "-v000")), TuplesKt.to((Object)"type", (Object)"titus"), TuplesKt.to((Object)"createdTime", (Object)0), TuplesKt.to((Object)"provider", (Object)"titus"), TuplesKt.to((Object)"account", account), TuplesKt.to((Object)"application", (Object)app), TuplesKt.to((Object)"region", (Object)String.valueOf(region)), TuplesKt.to((Object)"completionDetails", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"taskId", (Object)taskId), TuplesKt.to((Object)"instanceId", (Object)instanceId)})), TuplesKt.to((Object)"jobState", (Object)"Succeeded")})), TuplesKt.to((Object)"completionDetails", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"taskId", (Object)taskId), TuplesKt.to((Object)"instanceId", (Object)instanceId)}))});
    }

    @Override
    @NotNull
    public List<String> getRegions(@NotNull StageExecution $this$regions) {
        Intrinsics.checkNotNullParameter((Object)$this$regions, (String)"$this$regions");
        return OutputStub.DefaultImpls.getRegions(this, $this$regions);
    }
}

