/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.orca.echo.EchoService;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class JiraService {
    private final EchoService echoService;
    private final ObjectMapper mapper;

    @Autowired
    public JiraService(EchoService echoService, ObjectMapper mapper) {
        this.echoService = echoService;
        this.mapper = mapper;
    }

    public CreateJiraIssueResponse createJiraIssue(CreateIssueRequest createIssueRequest) throws CreateJiraIssueException {
        try {
            this.validateInputs(createIssueRequest);
            EchoService.Notification notification = new EchoService.Notification();
            EchoService.Notification.Source source = new EchoService.Notification.Source();
            Optional.ofNullable(createIssueRequest.getFields().getReporter()).ifPresent(reporter -> {
                source.setUser(reporter.getName());
                notification.setTo(Collections.singletonList(reporter.getName()));
            });
            notification.setSource(source);
            notification.setNotificationType(EchoService.Notification.Type.JIRA);
            notification.setAdditionalContext((Map<String, Object>)ImmutableMap.of((Object)"issueContext", (Object)createIssueRequest));
            Response response = (Response)AuthenticatedRequest.allowAnonymous(() -> this.echoService.create(notification));
            return (CreateJiraIssueResponse)this.mapper.readValue(response.getBody().in(), CreateJiraIssueResponse.class);
        }
        catch (Exception e) {
            throw new CreateJiraIssueException(String.format("Failed to create Jira Issue for project %s %s", createIssueRequest.getFields().getProject(), e.getMessage()));
        }
    }

    private void validateInputs(CreateIssueRequest createIssueRequest) {
        Set violations = Validation.buildDefaultValidatorFactory().getValidator().validate((Object)createIssueRequest, new Class[0]);
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException("Failed validation: " + violations.stream().map(v -> String.format("%s: %s", v.getPropertyPath().toString(), v.getMessage())).collect(Collectors.toList()));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CreateIssueRequest {
        private Fields fields = new Fields();
        private Update update;

        public CreateIssueRequest withProjectId(String projectId) {
            this.fields.setProject(new Fields.Project().withId(projectId));
            return this;
        }

        public CreateIssueRequest withProjectKey(String key) {
            this.fields.setProject(new Fields.Project().withKey(key));
            return this;
        }

        public CreateIssueRequest withParentKey(String key) {
            this.fields.setParent(new Fields.Parent().withKey(key));
            return this;
        }

        public CreateIssueRequest withParentId(String id) {
            this.fields.setParent(new Fields.Parent().withId(id));
            return this;
        }

        public CreateIssueRequest withSummary(String summary) {
            this.fields.setSummary(summary);
            return this;
        }

        public CreateIssueRequest withDescription(String description) {
            this.fields.setDescription(description);
            return this;
        }

        public CreateIssueRequest withIssueTypeName(String issueTypeName) {
            this.fields.setIssueType(new Fields.IssueType().withName(issueTypeName));
            return this;
        }

        public CreateIssueRequest withIssueTypeId(String id) {
            this.fields.setIssueType(new Fields.IssueType().withId(id));
            return this;
        }

        public CreateIssueRequest withReporter(String reporter) {
            this.fields.setReporter(new Fields.Reporter().withName(reporter));
            return this;
        }

        public CreateIssueRequest withAssignee(String assignee) {
            this.fields.setAssignee(new Fields.Assignee().withName(assignee));
            return this;
        }

        public CreateIssueRequest withLinkedIssue(String type, String key) {
            this.update = new Update().withLink(type, key);
            return this;
        }

        public void addDetails(String key, Object object) {
            this.fields.details().put(key, object);
        }

        public Fields getFields() {
            return this.fields;
        }

        public Update getUpdate() {
            return this.update;
        }

        public void setFields(Fields fields) {
            this.fields = fields;
        }

        public void setReporter(String reporter) {
            new Fields.Reporter().withName(reporter);
        }

        public String toString() {
            return "CreateIssueContext{fields=" + this.fields + "}";
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Fields {
            @NotNull
            private Project project;
            @NotNull
            private String description;
            @JsonProperty(value="issuetype")
            private IssueType issueType;
            private String summary;
            private Parent parent;
            private Reporter reporter;
            private Assignee assignee;
            private Map<String, Object> details = new HashMap<String, Object>();

            public Project getProject() {
                return this.project;
            }

            public void setProject(Project project) {
                this.project = project;
            }

            public String getSummary() {
                return this.summary;
            }

            public void setSummary(String summary) {
                this.summary = summary;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public IssueType getIssueType() {
                return this.issueType;
            }

            public void setIssueType(IssueType issueType) {
                this.issueType = issueType;
            }

            public Parent getParent() {
                return this.parent;
            }

            public void setParent(Parent parent) {
                this.parent = parent;
            }

            public Reporter getReporter() {
                return this.reporter;
            }

            public void setReporter(Reporter reporter) {
                this.reporter = reporter;
            }

            public Assignee getAssignee() {
                return this.assignee;
            }

            public void setAssignee(Assignee assignee) {
                this.assignee = assignee;
            }

            @JsonAnySetter
            public void set(String name, Object value) {
                this.details.put(name, value);
            }

            @JsonAnyGetter
            public Map<String, Object> details() {
                return this.details;
            }

            public String toString() {
                return "Fields{details=" + this.details + ", project=" + this.project + ", description='" + this.description + "', issueType=" + this.issueType + ", summary='" + this.summary + "', parent=" + this.parent + ", reporter='" + this.reporter + "', assignee='" + this.assignee + "'}";
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public static class IssueType {
                private String name;
                private String id;

                public IssueType withName(String name) {
                    this.setName(name);
                    return this;
                }

                public IssueType withId(String id) {
                    this.setId(id);
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String toString() {
                    return "IssueType{name='" + this.name + "', id='" + this.id + "'}";
                }
            }

            static class IdKey {
                private String id;
                private String key;

                IdKey() {
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getKey() {
                    return this.key;
                }

                public void setKey(String key) {
                    this.key = key;
                }
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public static class Parent
            extends IdKey {
                public Parent withId(String id) {
                    this.setId(id);
                    return this;
                }

                public Parent withKey(String key) {
                    this.setKey(key);
                    return this;
                }

                public String toString() {
                    return "Parent{id='" + this.id + "', key='" + this.key + "'}";
                }
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public static class Project
            extends IdKey {
                public Project withId(String id) {
                    this.setId(id);
                    return this;
                }

                public Project withKey(String key) {
                    this.setKey(key);
                    return this;
                }

                public String toString() {
                    return "Project{id='" + this.id + "', key='" + this.key + "'}";
                }
            }

            public static class Assignee {
                private String name;

                public Assignee withName(String name) {
                    this.setName(name);
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String toString() {
                    return "Assignee{name='" + this.name + "'}";
                }
            }

            public static class Reporter {
                private String name;

                public Reporter withName(String name) {
                    this.setName(name);
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String toString() {
                    return "Reporter{name='" + this.name + "'}";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Update {
            private List<IssueLink> issuelinks;

            public Update withLink(String type, String key) {
                this.issuelinks = new ArrayList<IssueLink>();
                this.issuelinks.add(new IssueLink().withAddLink(type, key));
                return this;
            }

            public List<IssueLink> getIssuelinks() {
                return this.issuelinks;
            }

            public String toString() {
                return "Update{linkType=" + this.issuelinks.get(0).getAdd().getType().getName() + ", linkKey=" + this.issuelinks.get(0).getAdd().getInwardIssue().getKey() + "}";
            }

            public static class IssueLink {
                private AddLink add;

                public IssueLink withAddLink(String type, String key) {
                    this.add = new AddLink().withTypeAndKey(type, key);
                    return this;
                }

                public AddLink getAdd() {
                    return this.add;
                }

                public static class AddLink {
                    private IssueLinkType type;
                    private LinkedKey inwardIssue;

                    public AddLink withTypeAndKey(String type, String key) {
                        this.type = new IssueLinkType().withName(type);
                        this.inwardIssue = new LinkedKey().withKey(key);
                        return this;
                    }

                    public IssueLinkType getType() {
                        return this.type;
                    }

                    public LinkedKey getInwardIssue() {
                        return this.inwardIssue;
                    }

                    public static class LinkedKey {
                        private String key;

                        public LinkedKey withKey(String key) {
                            this.setKey(key);
                            return this;
                        }

                        public void setKey(String key) {
                            this.key = key;
                        }

                        public String getKey() {
                            return this.key;
                        }
                    }

                    public static class IssueLinkType {
                        private String name;

                        public IssueLinkType withName(String name) {
                            this.setName(name);
                            return this;
                        }

                        public void setName(String name) {
                            this.name = name;
                        }

                        public String getName() {
                            return this.name;
                        }
                    }
                }
            }
        }
    }

    public static class CreateJiraIssueResponse {
        private Value value;

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public static class Value {
            private String id;
            private String key;
            private String self;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getSelf() {
                return this.self;
            }

            public void setSelf(String self) {
                this.self = self;
            }

            public String toString() {
                return "(id='" + this.id + "', key='" + this.key + "', self='" + this.self + "')";
            }
        }
    }

    public static class CreateJiraIssueException
    extends RuntimeException {
        public CreateJiraIssueException(String message) {
            super(message);
        }
    }
}

