/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jakewharton.retrofit.Ok3Client;
import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.echo.EchoService;
import com.netflix.spinnaker.orca.echo.spring.EchoNotifyingExecutionListener;
import com.netflix.spinnaker.orca.echo.spring.EchoNotifyingStageListener;
import com.netflix.spinnaker.orca.events.ExecutionEvent;
import com.netflix.spinnaker.orca.events.ExecutionListenerAdapter;
import com.netflix.spinnaker.orca.events.StageListenerAdapter;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.listeners.ExecutionListener;
import com.netflix.spinnaker.orca.listeners.StageListener;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.retrofit.RetrofitConfiguration;
import com.netflix.spinnaker.orca.retrofit.logging.RetrofitSlf4jLog;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Configuration
@Import(value={RetrofitConfiguration.class})
@ConditionalOnExpression(value="${echo.enabled:true}")
@ComponentScan(value={"com.netflix.spinnaker.orca.echo"})
public class EchoConfiguration
implements GroovyObject {
    @Autowired
    private OkHttpClientProvider clientProvider;
    @Autowired
    private RestAdapter.LogLevel retrofitLogLevel;
    @Autowired
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public EchoConfiguration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Bean
    public Endpoint echoEndpoint(@Value(value="${echo.base-url}") String echoBaseUrl) {
        return Endpoints.newFixedEndpoint((String)echoBaseUrl);
    }

    @Bean
    public EchoService echoService(Endpoint echoEndpoint) {
        return (EchoService)ScriptBytecodeAdapter.castToType((Object)new RestAdapter.Builder().setEndpoint(echoEndpoint).setClient((Client)new Ok3Client(this.clientProvider.getClient((ServiceEndpoint)new DefaultServiceEndpoint("echo", echoEndpoint.getUrl())))).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new RetrofitSlf4jLog(EchoService.class)).setConverter((Converter)new JacksonConverter()).build().create(EchoService.class), EchoService.class);
    }

    @Bean
    public EchoNotifyingStageListener echoNotifyingStageExecutionListener(EchoService echoService, ExecutionRepository repository, ContextParameterProcessor contextParameterProcessor, DynamicConfigService dynamicConfigService) {
        return new EchoNotifyingStageListener(echoService, contextParameterProcessor, dynamicConfigService);
    }

    @Bean
    public ApplicationListener<ExecutionEvent> echoNotifyingStageExecutionListenerAdapter(EchoNotifyingStageListener echoNotifyingStageListener) {
        return new StageListenerAdapter((StageListener)echoNotifyingStageListener);
    }

    @Bean
    public EchoNotifyingExecutionListener echoNotifyingPipelineExecutionListener(EchoService echoService, Front50Service front50Service, ObjectMapper objectMapper, ContextParameterProcessor contextParameterProcessor) {
        return new EchoNotifyingExecutionListener(echoService, front50Service, objectMapper, contextParameterProcessor);
    }

    @Bean
    public ApplicationListener<ExecutionEvent> echoNotifyingPipelineExecutionListenerAdapter(EchoNotifyingExecutionListener echoNotifyingExecutionListener, ExecutionRepository repository) {
        return new ExecutionListenerAdapter((ExecutionListener)echoNotifyingExecutionListener, repository);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EchoConfiguration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public OkHttpClientProvider getClientProvider() {
        return this.clientProvider;
    }

    @Generated
    public void setClientProvider(OkHttpClientProvider okHttpClientProvider) {
        this.clientProvider = okHttpClientProvider;
    }

    @Generated
    public RestAdapter.LogLevel getRetrofitLogLevel() {
        return this.retrofitLogLevel;
    }

    @Generated
    public void setRetrofitLogLevel(RestAdapter.LogLevel logLevel) {
        this.retrofitLogLevel = logLevel;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

