/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.echo.EchoService;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.ApplicationNotifications;
import com.netflix.spinnaker.orca.listeners.ExecutionListener;
import com.netflix.spinnaker.orca.listeners.Persister;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoNotifyingExecutionListener
implements ExecutionListener,
GroovyObject {
    private final EchoService echoService;
    private final Front50Service front50Service;
    private final ObjectMapper objectMapper;
    private final ContextParameterProcessor contextParameterProcessor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public EchoNotifyingExecutionListener(EchoService echoService, Front50Service front50Service, ObjectMapper objectMapper, ContextParameterProcessor contextParameterProcessor) {
        ContextParameterProcessor contextParameterProcessor2;
        ObjectMapper objectMapper2;
        Front50Service front50Service2;
        EchoService echoService2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.echoService = echoService2 = echoService;
        this.front50Service = front50Service2 = front50Service;
        this.objectMapper = objectMapper2 = objectMapper;
        this.contextParameterProcessor = contextParameterProcessor2 = contextParameterProcessor;
    }

    public void beforeExecution(Persister persister, PipelineExecution execution) {
        block7: {
            Reference execution2 = new Reference((Object)execution);
            try {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((PipelineExecution)execution2.get()).getStatus(), (Object)ExecutionStatus.SUSPENDED)) {
                    this.processSpelInNotifications((PipelineExecution)execution2.get());
                    if (ScriptBytecodeAdapter.compareEqual((Object)((PipelineExecution)execution2.get()).getType(), (Object)ExecutionType.PIPELINE)) {
                        this.addApplicationNotifications((PipelineExecution)execution2.get());
                    }
                    public final class _beforeExecution_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference execution;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _beforeExecution_closure1(Object _outerInstance, Object _thisObject, Reference execution) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.execution = reference = execution;
                        }

                        public Object doCall(Object it) {
                            return ((EchoNotifyingExecutionListener)this.getThisObject()).echoService.recordEvent(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"details", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"source", "orca", "type", new GStringImpl(new Object[]{((PipelineExecution)this.execution.get()).getType()}, new String[]{"orca:", ":starting"}).toString(), "application", ((PipelineExecution)this.execution.get()).getApplication()}), "content", ((EchoNotifyingExecutionListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), EchoNotifyingExecutionListener.class)).buildContent((PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class))}));
                        }

                        @Generated
                        public PipelineExecution getExecution() {
                            return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _beforeExecution_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    AuthenticatedRequest.allowAnonymous((Callable)((Object)new _beforeExecution_closure1(this, this, execution2)));
                }
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    PipelineExecution pipelineExecution = (PipelineExecution)execution2.get();
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pipelineExecution != null ? pipelineExecution.getId() : null}, new String[]{"Failed to send pipeline start event: ", ""})), (Throwable)e);
                    v0 = null;
                    break block7;
                }
                v0 = null;
            }
        }
    }

    public void afterExecution(Persister persister, PipelineExecution execution, ExecutionStatus executionStatus, boolean wasSuccessful) {
        block7: {
            Reference execution2 = new Reference((Object)execution);
            Reference wasSuccessful2 = new Reference((Object)wasSuccessful);
            try {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((PipelineExecution)execution2.get()).getStatus(), (Object)ExecutionStatus.SUSPENDED)) {
                    this.processSpelInNotifications((PipelineExecution)execution2.get());
                    if (ScriptBytecodeAdapter.compareEqual((Object)((PipelineExecution)execution2.get()).getType(), (Object)ExecutionType.PIPELINE)) {
                        this.addApplicationNotifications((PipelineExecution)execution2.get());
                    }
                    public final class _afterExecution_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference execution;
                        private /* synthetic */ Reference wasSuccessful;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _afterExecution_closure2(Object _outerInstance, Object _thisObject, Reference execution, Reference wasSuccessful) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.execution = reference2 = execution;
                            this.wasSuccessful = reference = wasSuccessful;
                        }

                        public Object doCall(Object it) {
                            return ((EchoNotifyingExecutionListener)this.getThisObject()).echoService.recordEvent(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"details", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"source", "orca", "type", new GStringImpl(new Object[]{((PipelineExecution)this.execution.get()).getType(), DefaultTypeTransformation.booleanUnbox((Object)this.wasSuccessful.get()) ? "complete" : "failed"}, new String[]{"orca:", ":", ""}).toString(), "application", ((PipelineExecution)this.execution.get()).getApplication()}), "content", ((EchoNotifyingExecutionListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), EchoNotifyingExecutionListener.class)).buildContent((PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class))}));
                        }

                        @Generated
                        public PipelineExecution getExecution() {
                            return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class);
                        }

                        @Generated
                        public boolean getWasSuccessful() {
                            return DefaultTypeTransformation.booleanUnbox((Object)this.wasSuccessful.get());
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _afterExecution_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    AuthenticatedRequest.allowAnonymous((Callable)((Object)new _afterExecution_closure2(this, this, execution2, wasSuccessful2)));
                }
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    PipelineExecution pipelineExecution = (PipelineExecution)execution2.get();
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pipelineExecution != null ? pipelineExecution.getId() : null}, new String[]{"Failed to send pipeline end event: ", ""})), (Throwable)e);
                    v0 = null;
                    break block7;
                }
                v0 = null;
            }
        }
    }

    private void processSpelInNotifications(PipelineExecution execution) {
        Reference execution2 = new Reference((Object)execution);
        public final class _processSpelInNotifications_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference execution;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processSpelInNotifications_closure3(Object _outerInstance, Object _thisObject, Reference execution) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.execution = reference = execution;
            }

            public Object doCall(Object it) {
                return ((EchoNotifyingExecutionListener)this.getThisObject()).contextParameterProcessor.process((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class), ((EchoNotifyingExecutionListener)this.getThisObject()).contextParameterProcessor.buildExecutionContext((PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class)), true);
            }

            @Generated
            public PipelineExecution getExecution() {
                return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.execution.get(), PipelineExecution.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processSpelInNotifications_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List spelProcessedNotifications = DefaultGroovyMethods.collect((Iterable)((PipelineExecution)execution2.get()).getNotifications(), (Closure)new _processSpelInNotifications_closure3(this, this, execution2));
        List list = spelProcessedNotifications;
        ((PipelineExecution)execution2.get()).setNotifications(list);
    }

    private void addApplicationNotifications(PipelineExecution pipeline) {
        Reference pipeline2 = new Reference((Object)pipeline);
        PipelineExecution.AuthenticationDetails authenticationDetails = ((PipelineExecution)pipeline2.get()).getAuthentication();
        String user = authenticationDetails != null ? authenticationDetails.getUser() : null;
        ApplicationNotifications notifications = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)user)) {
            Collection collection = ((PipelineExecution)pipeline2.get()).getAuthentication().getAllowedAccounts();
            public final class _addApplicationNotifications_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference pipeline;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addApplicationNotifications_closure4(Object _outerInstance, Object _thisObject, Reference pipeline) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.pipeline = reference = pipeline;
                }

                public Object doCall(Object it) {
                    return ((EchoNotifyingExecutionListener)this.getThisObject()).front50Service.getApplicationNotifications(((PipelineExecution)this.pipeline.get()).getApplication());
                }

                @Generated
                public PipelineExecution getPipeline() {
                    return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), PipelineExecution.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addApplicationNotifications_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Object v = AuthenticatedRequest.runAs((String)user, (Collection)(DefaultTypeTransformation.booleanUnbox((Object)collection) ? collection : (Collection)ScriptBytecodeAdapter.createList((Object[])new Object[0])), (Callable)((Object)new _addApplicationNotifications_closure4(this, this, pipeline2))).call();
            notifications = (ApplicationNotifications)ScriptBytecodeAdapter.castToType(v, ApplicationNotifications.class);
        } else {
            public final class _addApplicationNotifications_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference pipeline;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addApplicationNotifications_closure5(Object _outerInstance, Object _thisObject, Reference pipeline) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.pipeline = reference = pipeline;
                }

                public Object doCall(Object it) {
                    return ((EchoNotifyingExecutionListener)this.getThisObject()).front50Service.getApplicationNotifications(((PipelineExecution)this.pipeline.get()).getApplication());
                }

                @Generated
                public PipelineExecution getPipeline() {
                    return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), PipelineExecution.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addApplicationNotifications_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Object object = AuthenticatedRequest.allowAnonymous((Callable)((Object)new _addApplicationNotifications_closure5(this, this, pipeline2)));
            notifications = (ApplicationNotifications)ScriptBytecodeAdapter.castToType((Object)object, ApplicationNotifications.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)notifications)) {
            public final class _addApplicationNotifications_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference pipeline;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addApplicationNotifications_closure6(Object _outerInstance, Object _thisObject, Reference pipeline) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.pipeline = reference = pipeline;
                }

                public Object doCall(Object appNotification) {
                    Reference appNotification2 = new Reference(appNotification);
                    Map map = ((EchoNotifyingExecutionListener)this.getThisObject()).contextParameterProcessor.process((Map)ScriptBytecodeAdapter.castToType((Object)appNotification2.get(), Map.class), ((EchoNotifyingExecutionListener)this.getThisObject()).contextParameterProcessor.buildExecutionContext((PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), PipelineExecution.class)), true);
                    appNotification2.set((Object)map);
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference appNotification;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject, Reference appNotification) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.appNotification = reference = appNotification;
                        }

                        public Object doCall(Object pipelineNotification) {
                            boolean addressMatches = DefaultTypeTransformation.booleanUnbox(this.appNotification.get().get("address")) && DefaultTypeTransformation.booleanUnbox(pipelineNotification.get("address")) && ScriptBytecodeAdapter.compareEqual(pipelineNotification.get("address"), this.appNotification.get().get("address"));
                            boolean publisherMatches = DefaultTypeTransformation.booleanUnbox(this.appNotification.get().get("publisherName")) && DefaultTypeTransformation.booleanUnbox(pipelineNotification.get("publisherName")) && ScriptBytecodeAdapter.compareEqual(pipelineNotification.get("publisherName"), this.appNotification.get().get("publisherName"));
                            boolean typeMatches = DefaultTypeTransformation.booleanUnbox(this.appNotification.get().get("type")) && DefaultTypeTransformation.booleanUnbox(pipelineNotification.get("type")) && ScriptBytecodeAdapter.compareEqual(pipelineNotification.get("type"), this.appNotification.get().get("type"));
                            return (addressMatches || publisherMatches) && typeMatches;
                        }

                        @Generated
                        public Object getAppNotification() {
                            return this.appNotification.get();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Map targetMatch = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)((PipelineExecution)this.pipeline.get()).getNotifications(), (Closure)new _closure7((Object)this, this.getThisObject(), appNotification2)), Map.class);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)targetMatch)) {
                        return DefaultGroovyMethods.push((List)((PipelineExecution)this.pipeline.get()).getNotifications(), (Object)appNotification2.get());
                    }
                    Collection appWhen = (Collection)ScriptBytecodeAdapter.castToType(appNotification2.get().get("when"), Collection.class);
                    Collection pipelineWhen = (Collection)ScriptBytecodeAdapter.castToType(targetMatch.get("when"), Collection.class);
                    appWhen.removeAll(pipelineWhen);
                    if (!appWhen.isEmpty()) {
                        return DefaultGroovyMethods.push((List)((PipelineExecution)this.pipeline.get()).getNotifications(), (Object)appNotification2.get());
                    }
                    return null;
                }

                @Generated
                public PipelineExecution getPipeline() {
                    return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), PipelineExecution.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addApplicationNotifications_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)notifications.getPipelineNotifications(), (Closure)new _addApplicationNotifications_closure6(this, this, pipeline2));
        }
    }

    private Map<String, Object> buildContent(PipelineExecution execution) {
        return this.contextParameterProcessor.process(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", execution, "executionId", execution.getId()}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", execution}), true);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EchoNotifyingExecutionListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.echo.spring.EchoNotifyingExecutionListener");
    }
}

