/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.spring;

import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.echo.EchoService;
import com.netflix.spinnaker.orca.listeners.StageListener;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

public class EchoNotifyingStageListener
implements StageListener,
GroovyObject {
    public static final String INCLUDE_FULL_EXECUTION_PROPERTY = "echo.events.includeFullExecution";
    private final EchoService echoService;
    private final ContextParameterProcessor contextParameterProcessor;
    private final DynamicConfigService dynamicConfigService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public EchoNotifyingStageListener(EchoService echoService, ContextParameterProcessor contextParameterProcessor, DynamicConfigService dynamicConfigService) {
        DynamicConfigService dynamicConfigService2;
        ContextParameterProcessor contextParameterProcessor2;
        EchoService echoService2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.echoService = echoService2 = echoService;
        this.contextParameterProcessor = contextParameterProcessor2 = contextParameterProcessor;
        this.dynamicConfigService = dynamicConfigService2 = dynamicConfigService;
    }

    public void beforeTask(StageExecution stage, TaskExecution task) {
        this.recordEvent("task", "starting", stage, task);
    }

    public void beforeStage(StageExecution stage) {
        CallSite[] callSiteArray = EchoNotifyingStageListener.$getCallSiteArray();
        callSiteArray[0].callCurrent((GroovyObject)this, (Object)"stage", (Object)"starting", (Object)stage);
    }

    public void afterTask(StageExecution stage, TaskExecution task) {
        ExecutionStatus status = task.getStatus();
        if (ScriptBytecodeAdapter.compareEqual((Object)status, (Object)ExecutionStatus.RUNNING)) {
            return;
        }
        this.recordEvent("task", status.isSuccessful() ? "complete" : "failed", stage, task);
    }

    public void afterStage(StageExecution stage) {
        CallSite[] callSiteArray = EchoNotifyingStageListener.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty((Object)stage), (Object)callSiteArray[2].callGetProperty(ExecutionStatus.class))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call((Object)log)) ? callSiteArray[4].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty((Object)stage)), callSiteArray[7].callGetProperty((Object)stage)}, new String[]{"***** ", " Echo stage ", " skipped v2"})) : null;
            callSiteArray[8].callCurrent((GroovyObject)this, (Object)"stage", (Object)"skipped", (Object)stage);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty((Object)stage), (Object)callSiteArray[10].callGetProperty(ExecutionStatus.class))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call((Object)log)) ? callSiteArray[12].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty((Object)stage)), callSiteArray[15].callGetProperty((Object)stage)}, new String[]{"***** ", " Echo stage ", " complete v2"})) : null;
            callSiteArray[16].callCurrent((GroovyObject)this, (Object)"stage", (Object)"complete", (Object)stage);
        } else {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)log)) ? callSiteArray[18].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[19].callGetProperty(callSiteArray[20].callGetProperty((Object)stage)), callSiteArray[21].callGetProperty((Object)stage)}, new String[]{"***** ", " Echo stage ", " failed v2"})) : null;
            callSiteArray[22].callCurrent((GroovyObject)this, (Object)"stage", (Object)"failed", (Object)stage);
        }
    }

    private void recordEvent(String type, String phase, StageExecution stage, TaskExecution task) {
        this.recordEvent(type, phase, stage, Optional.of(task));
    }

    private void recordEvent(String type, String phase, StageExecution stage) {
        this.recordEvent(type, phase, stage, Optional.empty());
    }

    private void recordEvent(String type, String phase, StageExecution stage, Optional<TaskExecution> maybeTask) {
        block11: {
            Reference stage2 = new Reference((Object)stage);
            try {
                Reference event = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"details", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"source", "orca", "type", new GStringImpl(new Object[]{type, phase}, new String[]{"orca:", ":", ""}).toString(), "application", ((StageExecution)stage2.get()).getExecution().getApplication()}), "content", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"standalone", ScriptBytecodeAdapter.compareEqual((Object)((StageExecution)stage2.get()).getExecution().getType(), (Object)ExecutionType.ORCHESTRATION), "canceled", ((StageExecution)stage2.get()).getExecution().isCanceled(), "context", this.buildContext(((StageExecution)stage2.get()).getExecution(), ((StageExecution)stage2.get()).getContext()), "startTime", ((StageExecution)stage2.get()).getStartTime(), "endTime", ((StageExecution)stage2.get()).getEndTime(), "executionId", ((StageExecution)stage2.get()).getExecution().getId(), "stageId", ((StageExecution)stage2.get()).getId(), "isSynthetic", ((StageExecution)stage2.get()).getSyntheticStageOwner() != null, "name", ((StageExecution)stage2.get()).getName()})}), LinkedHashMap.class)));
                public final class _recordEvent_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference event;
                    private /* synthetic */ Reference stage;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _recordEvent_closure1(Object _outerInstance, Object _thisObject, Reference event, Reference stage) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.event = reference2 = event;
                        this.stage = reference = stage;
                    }

                    public Object doCall(TaskExecution task) {
                        String string = new GStringImpl(new Object[]{((StageExecution)this.stage.get()).getType(), task.getName()}, new String[]{"", ".", ""}).toString();
                        ScriptBytecodeAdapter.setProperty((Object)string, null, this.event.get().get("content"), (String)"taskName");
                        return string;
                    }

                    @Generated
                    public Object call(TaskExecution task) {
                        return this.doCall(task);
                    }

                    @Generated
                    public Object getEvent() {
                        return this.event.get();
                    }

                    @Generated
                    public StageExecution getStage() {
                        return (StageExecution)ScriptBytecodeAdapter.castToType((Object)this.stage.get(), StageExecution.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _recordEvent_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                maybeTask.ifPresent((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _recordEvent_closure1(this, this, event, stage2)), Consumer.class));
                Object object = this.dynamicConfigService.getConfig(Boolean.class, INCLUDE_FULL_EXECUTION_PROPERTY, (Object)true);
                if (object == null ? false : (Boolean)object) {
                    PipelineExecution pipelineExecution = ((StageExecution)stage2.get()).getExecution();
                    ScriptBytecodeAdapter.setProperty((Object)pipelineExecution, null, ((LinkedHashMap)event.get()).get("content"), (String)"execution");
                } else if (!ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"task")) {
                    PipelineExecution pipelineExecution = ((StageExecution)stage2.get()).getExecution();
                    ScriptBytecodeAdapter.setProperty((Object)pipelineExecution, null, ((LinkedHashMap)event.get()).get("content"), (String)"execution");
                }
                try {
                    MDC.put((String)Header.EXECUTION_ID.getHeader(), (String)((StageExecution)stage2.get()).getExecution().getId());
                    PipelineExecution pipelineExecution = ((StageExecution)stage2.get()).getExecution();
                    PipelineExecution.AuthenticationDetails authenticationDetails = pipelineExecution != null ? pipelineExecution.getAuthentication() : null;
                    String string = authenticationDetails != null ? authenticationDetails.getUser() : null;
                    MDC.put((String)Header.USER.getHeader(), (String)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "anonymous"));
                    public final class _recordEvent_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference event;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _recordEvent_closure2(Object _outerInstance, Object _thisObject, Reference event) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.event = reference = event;
                        }

                        public Object doCall(Object it) {
                            return ((EchoNotifyingStageListener)this.getThisObject()).echoService.recordEvent((Map)ScriptBytecodeAdapter.castToType((Object)this.event.get(), Map.class));
                        }

                        @Generated
                        public Object getEvent() {
                            return this.event.get();
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _recordEvent_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    AuthenticatedRequest.allowAnonymous((Callable)((Object)new _recordEvent_closure2(this, this, event)));
                }
                finally {
                    MDC.remove((String)Header.EXECUTION_ID.getHeader());
                    MDC.remove((String)Header.USER.getHeader());
                }
            }
            catch (Exception e) {
                Object v1;
                if (log.isErrorEnabled()) {
                    public final class _recordEvent_closure3
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _recordEvent_closure3(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(TaskExecution task) {
                            return task.getName();
                        }

                        @Generated
                        public Object call(TaskExecution task) {
                            return this.doCall(task);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _recordEvent_closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{type, phase, ((StageExecution)stage2.get()).getExecution().getId(), maybeTask.map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _recordEvent_closure3(this, this)), Function.class))}, new String[]{"Failed to send ", " event ", " ", " ", ""})), (Throwable)e);
                    v1 = null;
                    break block11;
                }
                v1 = null;
            }
        }
    }

    private Map<String, Object> buildContext(PipelineExecution execution, Map context) {
        return this.contextParameterProcessor.process(context, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", execution}), true);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EchoNotifyingStageListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.echo.spring.EchoNotifyingStageListener");
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "recordEvent";
        stringArray[1] = "status";
        stringArray[2] = "SKIPPED";
        stringArray[3] = "isDebugEnabled";
        stringArray[4] = "debug";
        stringArray[5] = "id";
        stringArray[6] = "execution";
        stringArray[7] = "name";
        stringArray[8] = "recordEvent";
        stringArray[9] = "status";
        stringArray[10] = "SUCCEEDED";
        stringArray[11] = "isDebugEnabled";
        stringArray[12] = "debug";
        stringArray[13] = "id";
        stringArray[14] = "execution";
        stringArray[15] = "name";
        stringArray[16] = "recordEvent";
        stringArray[17] = "isDebugEnabled";
        stringArray[18] = "debug";
        stringArray[19] = "id";
        stringArray[20] = "execution";
        stringArray[21] = "name";
        stringArray[22] = "recordEvent";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[23];
        EchoNotifyingStageListener.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(EchoNotifyingStageListener.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = EchoNotifyingStageListener.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

