/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.tasks;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.echo.JiraService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateJiraIssueTask
implements RetryableTask {
    private final JiraService jiraService;

    @Autowired
    public CreateJiraIssueTask(JiraService jiraService) {
        this.jiraService = jiraService;
    }

    public long getBackoffPeriod() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(5L);
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        JiraService.CreateIssueRequest createIssueRequest = (JiraService.CreateIssueRequest)stage.mapTo(JiraService.CreateIssueRequest.class);
        Optional.ofNullable(stage.getExecution().getAuthentication()).map(PipelineExecution.AuthenticationDetails::getUser).ifPresent(createIssueRequest::setReporter);
        JiraService.CreateJiraIssueResponse createJiraIssueResponse = this.jiraService.createJiraIssue(createIssueRequest);
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context((Map)ImmutableMap.of((Object)"createJiraIssueResponse", (Object)createJiraIssueResponse)).build();
    }
}

