/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.tasks;

import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.echo.EchoService;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.Application;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageApplicationOwnerTask
implements RetryableTask,
GroovyObject {
    private long backoffPeriod;
    private long timeout;
    @Autowired
    private EchoService echoService;
    @Autowired(required=false)
    private Front50Service front50Service;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PageApplicationOwnerTask() {
        MetaClass metaClass;
        int n = 15000;
        this.backoffPeriod = n;
        long l = TimeUnit.MINUTES.toMillis(5);
        this.timeout = l;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public TaskResult execute(StageExecution stage) {
        Object v0;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.front50Service)) {
            throw (Throwable)new UnsupportedOperationException("Front50 is not enabled, no way to fetch pager duty. Fix this by setting front50.enabled: true");
        }
        List applications = (List)ScriptBytecodeAdapter.asType(stage.getContext().get("applications"), List.class);
        List incomingPagerDutyKeys = (List)ScriptBytecodeAdapter.asType(stage.getContext().get("keys"), List.class);
        Reference allPagerDutyKeys = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        if (DefaultTypeTransformation.booleanUnbox((Object)incomingPagerDutyKeys)) {
            ((List)allPagerDutyKeys.get()).addAll(incomingPagerDutyKeys);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)applications)) {
            Reference invalidApplications = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _execute_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference invalidApplications;
                private /* synthetic */ Reference allPagerDutyKeys;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _execute_closure1(Object _outerInstance, Object _thisObject, Reference invalidApplications, Reference allPagerDutyKeys) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.invalidApplications = reference2 = invalidApplications;
                    this.allPagerDutyKeys = reference = allPagerDutyKeys;
                }

                public Object doCall(Object application) {
                    String applicationPagerDutyKey = ((PageApplicationOwnerTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PageApplicationOwnerTask.class)).fetchApplicationPagerDutyKey(ShortTypeHandling.castToString((Object)application));
                    if (!DefaultTypeTransformation.booleanUnbox((Object)applicationPagerDutyKey)) {
                        return DefaultGroovyMethods.push((List)((List)ScriptBytecodeAdapter.castToType((Object)this.invalidApplications.get(), List.class)), (Object)application);
                    }
                    return DefaultGroovyMethods.push((List)((List)ScriptBytecodeAdapter.castToType((Object)this.allPagerDutyKeys.get(), List.class)), (Object)applicationPagerDutyKey);
                }

                @Generated
                public Object getInvalidApplications() {
                    return this.invalidApplications.get();
                }

                @Generated
                public Object getAllPagerDutyKeys() {
                    return this.allPagerDutyKeys.get();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)applications, (Closure)new _execute_closure1(this, this, invalidApplications, allPagerDutyKeys));
            if (((List)invalidApplications.get()).size() > 0) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)((List)invalidApplications.get()), (String)", "), ((List)invalidApplications.get()).size() > 1 ? "do" : "does"}, new String[]{"", " ", " not have a pager duty service key."})));
            }
        }
        Object details = stage.getContext().get("details");
        if (details == null) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            details = map;
        }
        if (DefaultGroovyMethods.getAt(details, (String)"from") == null) {
            String string = stage.getExecution().getAuthentication().getUser();
            ScriptBytecodeAdapter.invokeMethodN(PageApplicationOwnerTask.class, details, (String)"putAt", (Object[])new Object[]{"from", string});
        }
        EchoService.Notification notification = new EchoService.Notification();
        List list = (List)allPagerDutyKeys.get();
        notification.setTo(list);
        EchoService.Notification.Type type = EchoService.Notification.Type.PAGER_DUTY;
        notification.setNotificationType(type);
        EchoService.Notification.Source source = new EchoService.Notification.Source();
        String string = stage.getExecution().getAuthentication().getUser();
        source.setUser(string);
        EchoService.Notification.Source source2 = source;
        notification.setSource(source2);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", stage.getContext().get("message"), "details", details});
        notification.setAdditionalContext(map);
        this.echoService.create(notification);
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)((List)allPagerDutyKeys.get()), (String)", "), stage.getContext().get("message")}, new String[]{"Sent page (key(s): ", ", message: '", "')"})));
            v0 = null;
        } else {
            v0 = null;
        }
        return TaskResult.ofStatus((ExecutionStatus)ExecutionStatus.SUCCEEDED);
    }

    private String fetchApplicationPagerDutyKey(String applicationName) {
        Application application = this.front50Service.get(applicationName);
        String string = (String)ScriptBytecodeAdapter.asType(application.details().get("pdApiKey"), String.class);
        try {
            return string;
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{applicationName, e.getMessage()}, new String[]{"Unable to retrieve application '", "', reason: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            String string2 = ShortTypeHandling.castToString(null);
            return string2;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PageApplicationOwnerTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.orca.echo.tasks.PageApplicationOwnerTask");
    }

    @Generated
    public long getBackoffPeriod() {
        return this.backoffPeriod;
    }

    @Generated
    public void setBackoffPeriod(long l) {
        this.backoffPeriod = l;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Generated
    public EchoService getEchoService() {
        return this.echoService;
    }

    @Generated
    public void setEchoService(EchoService echoService) {
        this.echoService = echoService;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }
}

