/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.echo.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.model.resources.Role;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManualJudgmentAuthorization {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FiatPermissionEvaluator fiatPermissionEvaluator;
    private final FiatStatus fiatStatus;

    @Autowired
    public ManualJudgmentAuthorization(Optional<FiatPermissionEvaluator> fiatPermissionEvaluator, FiatStatus fiatStatus) {
        this.fiatPermissionEvaluator = fiatPermissionEvaluator.orElse(null);
        this.fiatStatus = fiatStatus;
    }

    public boolean isAuthorized(Collection<String> requiredJudgmentRoles, String currentUser) {
        if (!this.fiatStatus.isEnabled() || requiredJudgmentRoles.isEmpty()) {
            return true;
        }
        if (Strings.isNullOrEmpty((String)currentUser)) {
            return false;
        }
        UserPermission.View permission = this.fiatPermissionEvaluator.getPermission(currentUser);
        if (permission == null) {
            this.log.warn("Attempted to get user permission for '{}' but none were found.", (Object)currentUser);
            return false;
        }
        return permission.isAdmin() || this.isAuthorized(requiredJudgmentRoles, permission.getRoles().stream().map(Role.View::getName).collect(Collectors.toList()));
    }

    private boolean isAuthorized(Collection<String> requiredJudgmentRoles, Collection<String> currentUserRoles) {
        if (requiredJudgmentRoles == null || requiredJudgmentRoles.isEmpty()) {
            return true;
        }
        if (currentUserRoles == null) {
            currentUserRoles = new ArrayList<String>();
        }
        return !Sets.intersection(new HashSet<String>(requiredJudgmentRoles), new HashSet<String>(currentUserRoles)).isEmpty();
    }
}

