/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.flex.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.flex.FlexService;
import com.netflix.spinnaker.orca.retrofit.RetrofitConfiguration;
import com.netflix.spinnaker.orca.retrofit.logging.RetrofitSlf4jLog;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Configuration
@Import(value={RetrofitConfiguration.class})
@ConditionalOnProperty(value={"flex.base-url"})
@ComponentScan(value={"com.netflix.spinnaker.orca.flex.pipeline", "com.netflix.spinnaker.orca.flex.tasks"})
public class FlexConfiguration
implements GroovyObject {
    @Autowired
    private Client retrofitClient;
    @Autowired
    private RestAdapter.LogLevel retrofitLogLevel;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public FlexConfiguration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Bean
    public Endpoint flexEndpoint(@Value(value="${flex.base-url}") String flexBaseUrl) {
        return Endpoints.newFixedEndpoint((String)flexBaseUrl);
    }

    @Bean
    public FlexService flexService(Endpoint flexEndpoint, ObjectMapper mapper) {
        return (FlexService)ScriptBytecodeAdapter.castToType((Object)new RestAdapter.Builder().setEndpoint(flexEndpoint).setClient(this.retrofitClient).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new RetrofitSlf4jLog(FlexService.class)).setConverter((Converter)new JacksonConverter(mapper)).build().create(FlexService.class), FlexService.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FlexConfiguration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public Client getRetrofitClient() {
        return this.retrofitClient;
    }

    @Generated
    public void setRetrofitClient(Client client) {
        this.retrofitClient = client;
    }

    @Generated
    public RestAdapter.LogLevel getRetrofitLogLevel() {
        return this.retrofitLogLevel;
    }

    @Generated
    public void setRetrofitLogLevel(RestAdapter.LogLevel logLevel) {
        this.retrofitLogLevel = logLevel;
    }
}

