/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50;

import com.netflix.spinnaker.fiat.model.resources.ServiceAccount;
import com.netflix.spinnaker.orca.front50.model.Application;
import com.netflix.spinnaker.orca.front50.model.ApplicationNotifications;
import com.netflix.spinnaker.orca.front50.model.DeliveryConfig;
import com.netflix.spinnaker.orca.front50.model.Front50Credential;
import com.netflix.spinnaker.orca.front50.model.PluginInfo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.PATCH;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;

public interface Front50Service {
    @GET(value="/credentials")
    public List<Front50Credential> getCredentials();

    @GET(value="/v2/applications/{applicationName}")
    public Application get(@Path(value="applicationName") String var1);

    @GET(value="/v2/applications")
    public Collection<Application> getAllApplications();

    @POST(value="/v2/applications")
    public Response create(@Body Application var1);

    @DELETE(value="/v2/applications/{applicationName}")
    public Response delete(@Path(value="applicationName") String var1);

    @PATCH(value="/v2/applications/{applicationName}")
    public Response update(@Path(value="applicationName") String var1, @Body Application var2);

    @DELETE(value="/permissions/applications/{applicationName}")
    public Response deletePermission(@Path(value="applicationName") String var1);

    @PUT(value="/permissions/applications/{applicationName}")
    public Response updatePermission(@Path(value="applicationName") String var1, @Body Application.Permission var2);

    @POST(value="/pluginInfo")
    public PluginInfo upsertPluginInfo(@Body PluginInfo var1);

    @GET(value="/pluginInfo/{pluginId}")
    public PluginInfo getPluginInfo(@Path(value="pluginId") String var1);

    @DELETE(value="/pluginInfo/{pluginId}")
    public Response deletePluginInfo(@Path(value="pluginId") String var1);

    @PUT(value="/pluginInfo/{pluginId}/releases/{version}")
    public Response setPreferredPluginVersion(@Path(value="pluginId") String var1, @Path(value="version") String var2, @Query(value="preferred") boolean var3);

    @GET(value="/pipelines/{applicationName}")
    public List<Map<String, Object>> getPipelines(@Path(value="applicationName") String var1);

    @GET(value="/pipelines/{applicationName}")
    public List<Map<String, Object>> getPipelines(@Path(value="applicationName") String var1, @Query(value="refresh") boolean var2);

    @GET(value="/pipelines/{pipelineId}/get")
    public Map<String, Object> getPipeline(@Path(value="pipelineId") String var1);

    @POST(value="/pipelines")
    public Response savePipeline(@Body Map var1, @Query(value="staleCheck") boolean var2);

    @PUT(value="/pipelines/{pipelineId}")
    public Response updatePipeline(@Path(value="pipelineId") String var1, @Body Map var2);

    @GET(value="/strategies/{applicationName}")
    public List<Map<String, Object>> getStrategies(@Path(value="applicationName") String var1);

    @GET(value="/pipelines?restricted=false")
    public List<Map<String, Object>> getAllPipelines();

    @POST(value="/actions/pipelines/reorder")
    public Response reorderPipelines(@Body ReorderPipelinesCommand var1);

    @DELETE(value="/pipelines/{applicationName}/{pipelineName}")
    public Response deletePipeline(@Path(value="applicationName") String var1, @Path(value="pipelineName") String var2);

    @POST(value="/actions/strategies/reorder")
    public Response reorderPipelineStrategies(@Body ReorderPipelinesCommand var1);

    @GET(value="/pipelineTemplates")
    public List<Map<String, Object>> getPipelineTemplates(@Query(value="scopes") List<String> var1);

    @POST(value="/pipelineTemplates")
    public Response savePipelineTemplate(@Body Map var1);

    @GET(value="/pipelineTemplates/{pipelineTemplateId}")
    public Map<String, Object> getPipelineTemplate(@Path(value="pipelineTemplateId") String var1);

    @PUT(value="/pipelineTemplates/{pipelineTemplateId}")
    public Response updatePipelineTemplate(@Path(value="pipelineTemplateId") String var1, @Body Map var2);

    @DELETE(value="/pipelineTemplates/{pipelineTemplateId}")
    public Response deletePipelineTemplate(@Path(value="pipelineTemplateId") String var1);

    @GET(value="/pipelineTemplates/{pipelineTemplateId}/dependentPipelines")
    public List<Map<String, Object>> getPipelineTemplateDependents(@Path(value="pipelineTemplateId") String var1, @Query(value="recursive") boolean var2);

    @POST(value="/v2/pipelineTemplates")
    public Response saveV2PipelineTemplate(@Query(value="tag") String var1, @Body Map var2);

    @GET(value="/v2/pipelineTemplates/{pipelineTemplateId}/dependentPipelines")
    public List<Map<String, Object>> getDependentPipelinesForTemplate(@Path(value="pipelineTemplateId") String var1);

    @PUT(value="/v2/pipelineTemplates/{pipelineTemplateId}")
    public Response updateV2PipelineTemplate(@Path(value="pipelineTemplateId") String var1, @Query(value="tag") String var2, @Body Map var3);

    @DELETE(value="/v2/pipelineTemplates/{pipelineTemplateId}")
    public Response deleteV2PipelineTemplate(@Path(value="pipelineTemplateId") String var1, @Query(value="tag") String var2, @Query(value="digest") String var3);

    @GET(value="/strategies")
    public List<Map<String, Object>> getAllStrategies();

    @POST(value="/v2/projects")
    public Project createProject(@Body Map var1);

    @PUT(value="/v2/projects/{projectId}")
    public Project updateProject(@Path(value="projectId") String var1, @Body Map var2);

    @GET(value="/v2/projects/{projectId}")
    public Project getProject(@Path(value="projectId") String var1);

    @DELETE(value="/v2/projects/{projectId}")
    public Response deleteProject(@Path(value="projectId") String var1);

    @GET(value="/notifications/application/{applicationName}")
    public ApplicationNotifications getApplicationNotifications(@Path(value="applicationName") String var1);

    @POST(value="/serviceAccounts")
    public Response saveServiceAccount(@Body ServiceAccount var1);

    @GET(value="/deliveries/{id}")
    public DeliveryConfig getDeliveryConfig(@Path(value="id") String var1);

    @POST(value="/deliveries")
    public DeliveryConfig createDeliveryConfig(@Body DeliveryConfig var1);

    @PUT(value="/deliveries/{id}")
    public DeliveryConfig updateDeliveryConfig(@Path(value="id") String var1, @Body DeliveryConfig var2);

    @DELETE(value="/applications/{application}/deliveries/{id}")
    public Response deleteDeliveryConfig(@Path(value="application") String var1, @Path(value="id") String var2);

    public static class Project
    implements GroovyObject {
        private String id;
        private String name;
        private ProjectConfig config;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public Project() {
            MetaClass metaClass;
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            Object object = callSiteArray[0].callConstructor(ProjectConfig.class);
            this.config = (ProjectConfig)ScriptBytecodeAdapter.castToType((Object)object, ProjectConfig.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Project.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Project.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Project.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.getGroovyObjectProperty(Project.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Project.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Project.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Project.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Project.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Project.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public ProjectConfig getConfig() {
            return this.config;
        }

        @Generated
        public void setConfig(ProjectConfig projectConfig) {
            this.config = projectConfig;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(Project.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Project.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public static class ProjectConfig
        implements GroovyObject {
            private Collection<PipelineConfig> pipelineConfigs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ ClassInfo $staticClassInfo$;
            private static /* synthetic */ SoftReference $callSiteArray;

            @Generated
            public ProjectConfig() {
                MetaClass metaClass;
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != ProjectConfig.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(ProjectConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(ProjectConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(ProjectConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = ProjectConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(ProjectConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            @Generated
            public Collection<PipelineConfig> getPipelineConfigs() {
                return this.pipelineConfigs;
            }

            @Generated
            public void setPipelineConfigs(Collection<PipelineConfig> collection) {
                this.pipelineConfigs = collection;
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(ProjectConfig.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = ProjectConfig.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }

        public static class PipelineConfig
        implements GroovyObject {
            private String application;
            private String pipelineConfigId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ ClassInfo $staticClassInfo$;
            private static /* synthetic */ SoftReference $callSiteArray;

            @Generated
            public PipelineConfig() {
                MetaClass metaClass;
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != PipelineConfig.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(PipelineConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(PipelineConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(PipelineConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = PipelineConfig.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(PipelineConfig.class, Project.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            @Generated
            public String getApplication() {
                return this.application;
            }

            @Generated
            public void setApplication(String string) {
                this.application = string;
            }

            @Generated
            public String getPipelineConfigId() {
                return this.pipelineConfigId;
            }

            @Generated
            public void setPipelineConfigId(String string) {
                this.pipelineConfigId = string;
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(PipelineConfig.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = PipelineConfig.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public static class ReorderPipelinesCommand
    implements GroovyObject {
        private Map<String, Integer> idsToIndices;
        private String application;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ReorderPipelinesCommand(Map<String, Integer> idsToIndices, String application) {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Map<String, Integer> map = idsToIndices;
            this.idsToIndices = map;
            this.application = string = application;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReorderPipelinesCommand.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ReorderPipelinesCommand.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ReorderPipelinesCommand.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReorderPipelinesCommand.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ReorderPipelinesCommand.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReorderPipelinesCommand.class, Front50Service.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Map<String, Integer> getIdsToIndices() {
            return this.idsToIndices;
        }

        @Generated
        public void setIdsToIndices(Map<String, Integer> map) {
            this.idsToIndices = map;
        }

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public void setApplication(String string) {
            this.application = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ReorderPipelinesCommand.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ReorderPipelinesCommand.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

