/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.google.common.base.Strings;
import com.netflix.spinnaker.kork.api.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.expressions.SpelHelperFunctionException;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class PipelineExpressionFunctionProvider
implements ExpressionFunctionProvider {
    private static Front50Service front50Service = null;

    PipelineExpressionFunctionProvider(Optional<Front50Service> front50Service) {
        front50Service.ifPresent(service -> {
            front50Service = service;
        });
    }

    @Nullable
    public String getNamespace() {
        return null;
    }

    @NotNull
    public ExpressionFunctionProvider.Functions getFunctions() {
        return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("pipelineId", "Lookup pipeline ID given the name of the pipeline in the current application", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(PipelineExecution.class, "execution", "The execution containing the currently executing stage"), new ExpressionFunctionProvider.FunctionParameter(String.class, "pipelineName", "A valid stage reference identifier")}), new ExpressionFunctionProvider.FunctionDefinition("pipelineIdOrNull", "Lookup pipeline ID (or null if not found) given the name of the pipeline in the current application", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(PipelineExecution.class, "execution", "The execution containing the currently executing stage"), new ExpressionFunctionProvider.FunctionParameter(String.class, "pipelineName", "A valid stage reference identifier")}), new ExpressionFunctionProvider.FunctionDefinition("pipelineIdInApplication", "Lookup pipeline ID (or null if not found) given the name of the pipeline and the name of the application", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(PipelineExecution.class, "execution", "The execution containing the currently executing stage"), new ExpressionFunctionProvider.FunctionParameter(String.class, "pipelineName", "The name of the pipeline"), new ExpressionFunctionProvider.FunctionParameter(String.class, "applicationName", "The name of the application")})});
    }

    public static String pipelineId(PipelineExecution execution, String pipelineName) {
        if (Strings.isNullOrEmpty((String)pipelineName)) {
            throw new SpelHelperFunctionException("pipelineName must be specified for function #pipelineId");
        }
        String currentApplication = execution.getApplication();
        Map<String, Object> pipeline = PipelineExpressionFunctionProvider.searchForPipelineInApplication("pipelineId", currentApplication, pipelineName);
        if (pipeline == null) {
            throw new SpelHelperFunctionException(String.format("Pipeline with name '%s' could not be found on application %s", pipelineName, currentApplication));
        }
        return (String)pipeline.get("id");
    }

    public static String pipelineIdOrNull(PipelineExecution execution, String pipelineName) {
        try {
            return PipelineExpressionFunctionProvider.pipelineId(execution, pipelineName);
        }
        catch (SpelHelperFunctionException e) {
            if (e.getMessage().startsWith("Pipeline with name ")) {
                return null;
            }
            throw e;
        }
    }

    public static String pipelineIdInApplication(PipelineExecution execution, String pipelineName, String applicationName) {
        if (Strings.isNullOrEmpty((String)applicationName)) {
            throw new SpelHelperFunctionException("applicationName must be specified for function #pipelineIdInApplication");
        }
        Map<String, Object> pipeline = PipelineExpressionFunctionProvider.searchForPipelineInApplication("pipelineIdInApplication", applicationName, pipelineName);
        if (pipeline == null) {
            return null;
        }
        return (String)pipeline.get("id");
    }

    private static Map<String, Object> searchForPipelineInApplication(String functionName, String applicationName, String pipelineName) {
        if (front50Service == null) {
            throw new SpelHelperFunctionException(String.format("front50 service is missing. It's required when using #%s function", functionName));
        }
        try {
            RetrySupport retrySupport = new RetrySupport();
            return (Map)retrySupport.retry(() -> front50Service.getPipelines(applicationName).stream().filter(p -> pipelineName.equals(p.getOrDefault("name", null))).findFirst().orElse(null), 3, 1000L, true);
        }
        catch (Exception e) {
            throw new SpelHelperFunctionException(String.format("Failed to evaluate #%s function", functionName), (Throwable)e);
        }
    }
}

